/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.Task_num;
import java.io.File;

class OpGetAttr
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String[] msg;

    public OpGetAttr(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.msg = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to get attributes for a file, but there are no files", "available, and there are no threads currently active that can create new files."};
    }

    @Override
    protected boolean doOperation() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.fwg.anchor.getFile(this.fwg);
            if (fileEntry == null) {
                return false;
            }
            if (!fileEntry.setFileBusy()) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (!fileEntry.exists()) {
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_MUST_EXIST);
                if (this.canWeGetMoreFiles(this.msg)) continue;
                return false;
            }
            long l = Native.get_simple_tod();
            File file = new File(fileEntry.getFullName());
            long l2 = file.lastModified();
            FwdStats.count(Operations.GETATTR, l);
            this.fwg.blocked.count(Blocked.GET_ATTR);
            fileEntry.setUnBusy();
            return true;
        }
        return false;
    }
}

