/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.CurlHandling;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.Task_num;

class OpGetCloud
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private CurlHandling curl;

    public OpGetCloud(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.curl = fwgEntry.anchor.curl;
    }

    @Override
    protected boolean doOperation() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.findFileToRead();
            if (fileEntry == null) {
                return false;
            }
            if (this.curl.file_map.get(fileEntry.getFullName()) == null) {
                this.block(Blocked.FILE_MUST_EXIST);
                fileEntry.setUnBusy();
                continue;
            }
            long l = Native.get_simple_tod();
            this.curl.downloadFile(fileEntry.getFullName());
            FwdStats.count(Operations.GET, l);
            fileEntry.setUnBusy();
            return true;
        }
        return true;
    }
}

