/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Vdb.RD_entry;
import Vdb.common;
import java.io.File;
import java.util.Vector;

public class ParseFlat {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private static boolean quiet = false;
    private static boolean comma = true;
    private static String input_file = null;
    private static String output_file = "-";
    private static String label_file = null;
    private static boolean average = false;
    private static Vector<String[]> split_data = new Vector(256);
    private static Vector<String> column_names = new Vector(36);
    private static Vector<String> filter_columns = new Vector(36);
    private static Vector<String> filter_values = new Vector(36);
    private static Vector<String> output_cols = new Vector(36);
    private static boolean all_columns = false;

    public static void main(String[] stringArray) throws Exception {
        int n;
        ParseFlat.scanParms(stringArray);
        for (n = 90; n < filter_columns.size(); ++n) {
            common.ptod("filter_columns: " + filter_columns.elementAt(n));
        }
        for (n = 90; n < filter_values.size(); ++n) {
            common.ptod("filter_values:  " + filter_values.elementAt(n));
        }
        for (n = 90; n < output_cols.size(); ++n) {
            common.ptod("output_cols:    " + output_cols.elementAt(n));
        }
        ParseFlat.readColumnHeadersAndData();
        if (output_cols.size() == 1 && output_cols.get(0).equals("all")) {
            output_cols.clear();
            for (String string : column_names) {
                output_cols.add(string);
            }
        }
        ParseFlat.checkColumnNames(filter_columns);
        ParseFlat.checkColumnNames(output_cols);
        ParseFlat.createOutput();
        common.ptod("ParseFlat completed successfully.");
    }

    private static void readColumnHeadersAndData() {
        String[] stringArray;
        Fget fget = new Fget(input_file);
        String string = null;
        while ((string = fget.get()) != null) {
            if (string.trim().length() == 0 || !string.startsWith(" ")) continue;
            stringArray = string.trim().split(" +");
            for (int i = 0; i < stringArray.length; ++i) {
                column_names.add(stringArray[i]);
            }
        }
        while ((string = fget.get()) != null) {
            if (string.startsWith("*")) continue;
            stringArray = string.trim().split(" +");
            if (stringArray.length != column_names.size()) {
                common.ptod("line: " + string);
                common.ptod("ParseFlat: data line incomplete, expecting %d columns, getting %d. Line ignored.", column_names.size(), stringArray.length);
                common.ptod("This is acceptable for the last line in the file.");
                continue;
            }
            split_data.add(stringArray);
        }
        fget.close();
    }

    private static void checkColumnNames(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            ParseFlat.findColumnNo(string);
        }
    }

    private static int findColumnNo(String string) {
        for (int i = 0; i < column_names.size(); ++i) {
            String string2 = column_names.elementAt(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return i;
        }
        common.failure("Column '" + string + "' unknown'");
        return 0;
    }

    private static void createOutput() {
        String[] stringArray;
        int n;
        int n2 = 0;
        Fput fput = new Fput(output_file);
        String string = "";
        for (n = 0; n < output_cols.size(); ++n) {
            stringArray = output_cols.elementAt(n);
            if (n > 0) {
                string = string + (comma ? "," : "\t");
            }
            string = string + (String)stringArray;
        }
        fput.println(string);
        ParseFlat.checkAverage();
        block3: for (n = 0; n < split_data.size(); ++n) {
            int n3;
            try {
                int n4;
                String string2;
                int n5;
                stringArray = split_data.elementAt(n);
                n3 = 1;
                for (n5 = 0; n5 < filter_columns.size(); ++n5) {
                    string2 = filter_columns.elementAt(n5);
                    n4 = ParseFlat.findColumnNo(string2);
                    if (stringArray[n4].equalsIgnoreCase(filter_values.elementAt(n5))) continue;
                    n3 = 0;
                }
                if (n3 == 0) continue;
                string = "";
                for (n5 = 0; n5 < output_cols.size(); ++n5) {
                    string2 = output_cols.elementAt(n5);
                    n4 = ParseFlat.findColumnNo(string2);
                    String string3 = stringArray[n4];
                    if (string3.equals("?")) {
                        string3 = "0";
                    }
                    if (n5 > 0) {
                        string = string + (comma ? "," : "\t");
                    }
                    string = string + string3;
                    if (string2.equalsIgnoreCase("interval") && (!average && string3.startsWith("avg") || average && !string3.startsWith("avg"))) continue block3;
                }
                ++n2;
                fput.println(string);
                continue;
            }
            catch (Exception exception) {
                for (n3 = 0; n3 < split_data.get(n).length; ++n3) {
                    common.ptod("Failed column: %2d: ", n3, split_data.get(n)[n3]);
                }
                common.failure(exception);
            }
        }
        fput.close();
        if (n2 == 0) {
            common.failure("No output written. Check column names and filters");
        }
    }

    private static void removeFormat() {
        int n = 0;
        for (int i = 0; i < split_data.size(); ++i) {
            int n2;
            String[] stringArray = split_data.elementAt(i);
            if (!stringArray[n2 = ParseFlat.findColumnNo("run")].startsWith(RD_entry.FSD_FORMAT_RUN)) continue;
            ++n;
            split_data.removeElementAt(i--);
        }
        if (n > 0) {
            common.ptod("Flatfile parser removed all Run Definitions starting with '%s'", RD_entry.FSD_FORMAT_RUN);
        }
    }

    private static void checkAverage() {
        for (int i = 0; i < split_data.size(); ++i) {
            String[] stringArray = split_data.elementAt(i);
            int n = ParseFlat.findColumnNo("interval");
            String string = stringArray[n];
            if (!average && string.startsWith("avg")) {
                split_data.removeElementAt(i--);
                continue;
            }
            if (!average || string.startsWith("avg")) continue;
            split_data.removeElementAt(i--);
        }
    }

    private static void usage(String string) {
        common.ptod("");
        common.ptod("");
        common.ptod("");
        common.ptod("Usage:");
        common.ptod("./vdbench parseflat -i flatfile.html -o output.csv [-c col1 col2 ..] ");
        common.ptod("                 [-t][-a] [-f col1 value1 col2 value2 .. ..] [-q]");
        common.ptod("");
        common.ptod("-i input flatfile, e.g. output/flatfile.html");
        common.ptod("-o output csv file name (default stdout)");
        common.ptod("-c which column to write to output. Columns are written in the order specified.");
        common.ptod("-f filters: 'if (colX == valueX) ... ...' (Alphabetic compare)");
        common.ptod("-a include only the 'avg' data. Default: include only non-avg data.");
        common.ptod("-a Creat tab-separated file, not comma-separated");
        common.ptod("");
        common.ptod("");
        common.ptod("");
        common.failure(string);
    }

    private static void scanParms(String[] stringArray) {
        Vector<String> vector = new Vector<String>(64);
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-") && string.length() > 2) {
                vector.add(string.substring(0, 2));
                vector.add(string.substring(2));
                continue;
            }
            if (string.startsWith("-q")) {
                quiet = true;
                continue;
            }
            if (string.startsWith("-t")) {
                comma = false;
                continue;
            }
            vector.add(string);
        }
        String[] stringArray2 = vector.toArray(new String[0]);
        if (!quiet) {
            System.err.println("vdbench parseflat arguments:");
            for (int i = 0; i < stringArray2.length; ++i) {
                System.err.println("Argument " + i + ": " + stringArray2[i]);
            }
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].startsWith("-i")) {
                input_file = stringArray2[++i];
                continue;
            }
            if (stringArray2[i].startsWith("-o")) {
                output_file = stringArray2[++i];
                continue;
            }
            if (stringArray2[i].startsWith("-f")) {
                ++i;
                while (i < stringArray2.length && !stringArray2[i].startsWith("-")) {
                    filter_columns.add(stringArray2[i++]);
                    if (i == stringArray2.length) {
                        ParseFlat.usage("'-f' filters must be specified in pairs");
                    }
                    filter_values.add(stringArray2[i++]);
                }
                --i;
                continue;
            }
            if (stringArray2[i].startsWith("-c")) {
                for (int j = i + 1; j < stringArray2.length && !stringArray2[j].startsWith("-"); ++j) {
                    if (stringArray2[j].equals("all")) {
                        all_columns = true;
                    }
                    output_cols.add(stringArray2[++i]);
                }
                continue;
            }
            if (stringArray2[i].startsWith("-a")) {
                average = true;
                continue;
            }
            if (stringArray2[i].startsWith("-q")) {
                quiet = true;
                continue;
            }
            if (stringArray2[i].startsWith("-l")) {
                label_file = stringArray2[++i];
                continue;
            }
            ParseFlat.usage("invalid parameter: " + stringArray2[i]);
        }
        if (input_file == null) {
            ParseFlat.usage("No input file specified '-f xxx'");
        }
        if (output_cols.size() == 0) {
            ParseFlat.usage("No data columns specified '-c xxx yyy zzz'");
        }
        if (Fget.dir_exists(input_file) && Fget.file_exists(input_file, "flatfile.html")) {
            input_file = new File(input_file, "flatfile.html").getAbsolutePath();
        }
    }
}

