/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Vdb.Debug_cmds;
import Vdb.common;
import java.util.ArrayList;

public class PdmStart {
    private static final String c = "Copyright (c) 2000, 2017, Oracle and/or its affiliates. All rights reserved.";
    private static ArrayList<String> pdm_lines = new ArrayList(16);
    private static ArrayList<String> servers = new ArrayList(16);
    private static ArrayList<String> clients = new ArrayList(16);
    private static String keywords = "";
    private static String type = null;
    private static String output = null;
    private static String clock_check = "5";
    private static String system_check = "y";
    private static String swat_home = "/net/sbm-240a.us.oracle.com/export/swat/swat";

    public static void setOutputDir(String string) {
        output = string;
    }

    public static void setup() {
        if (pdm_lines.size() == 0) {
            return;
        }
        for (String string : pdm_lines) {
            int n;
            String[] stringArray = string.split(" +");
            if (stringArray.length < 2) {
                common.failure("PdmStart: unexpected input: " + string);
            }
            if (stringArray[0].equals("client")) {
                for (n = 1; n < stringArray.length; ++n) {
                    clients.add(stringArray[n]);
                }
                continue;
            }
            if (stringArray[0].equals("server")) {
                for (n = 1; n < stringArray.length; ++n) {
                    servers.add(stringArray[n]);
                }
                continue;
            }
            if (stringArray[0].equals("keywords")) {
                stringArray = string.split(" +", 2);
                keywords = keywords + stringArray[1] + " ";
                continue;
            }
            if (stringArray[0].equals("type")) {
                type = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("output")) continue;
            if (stringArray[0].equals("clock_check")) {
                clock_check = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("system_check")) {
                system_check = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("swat")) {
                swat_home = stringArray[1];
                continue;
            }
            common.failure("PdmStart: unexpected *pdm input: " + string);
        }
        if (type == null) {
            common.failure("PdmStart: 'type' parameter required. ");
        }
        if (clients.size() + servers.size() == 0) {
            common.failure("PDM start requested, but no servers or clients specified");
        }
        PdmStart.createSimpleRunfile();
    }

    private static void createSimpleRunfile() {
        String string2;
        Fput fput = new Fput(output, "runfile");
        fput.println("%-12s %s", "type", type);
        fput.println("%-12s %s", "keywords", keywords);
        fput.println("%-12s %s", "output", output);
        fput.println("%-12s %s", "clock_check", clock_check);
        fput.println("%-12s %s", "system_check", system_check);
        for (String string2 : servers) {
            fput.println("%-12s %s", "server", string2);
        }
        for (String string2 : clients) {
            fput.println("%-12s %s", "client", string2);
        }
        fput.close();
        Object object = swat_home;
        object = (String)object + " pdm start -r " + fput.getName();
        Debug_cmds.starting_command.storeCommands(new String[]{object, "master", "cons", "abort"});
        string2 = swat_home;
        string2 = string2 + " pdm end -r " + fput.getName();
        Debug_cmds.ending_command.storeCommands(new String[]{string2, "master", "cons", "abort"});
    }

    public static String lookForOutputDir(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.startsWith("-f")) continue;
            if (string2.length() > 2) {
                string = string2.substring(2);
                break;
            }
            if (stringArray.length <= i + 1) continue;
            string = stringArray[i + 1];
            break;
        }
        if (string == null) {
            return null;
        }
        if (!Fget.file_exists(string)) {
            return null;
        }
        for (String string3 : Fget.readFileToArray(string)) {
            String[] stringArray2;
            if (!(string3 = string3.trim()).startsWith("*pdm") || (stringArray2 = (string3 = string3.substring(5).trim()).split(" +")).length < 2) continue;
            if (stringArray2[0].equals("output")) {
                output = stringArray2[1];
                continue;
            }
            pdm_lines.add(string3);
        }
        return output;
    }

    public static void main(String[] stringArray) {
        String string = PdmStart.lookForOutputDir(stringArray);
        common.ptod("output: " + string);
    }
}

