/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Vdb.DVModel;
import Vdb.DvKeyBlock;
import Vdb.Message;
import Vdb.Native;
import Vdb.PrintBlock;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PostGui
extends JFrame
implements ActionListener {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private JSplitPane split_panel = new JSplitPane();
    private JPanel left_panel = new JPanel();
    private JScrollPane left_scroll = new JScrollPane();
    private JScrollPane error_scroll = new JScrollPane();
    private JScrollPane right_scroll = new JScrollPane();
    private JTextArea right_text = new JTextArea();
    private JPanel buttons = new JPanel();
    private DVModel left_model = new DVModel();
    private JTable left_table = new JTable();
    private StringBuffer overview;
    private String SELECT = "Display selection";
    private String RESET = "Reset selection";
    private JButton overview_button = new JButton("Overview");
    private JButton close_button = new JButton("Close");
    private JButton reread = new JButton("Reread block");
    private JButton lba_button = new JButton("Display block");
    private JButton only_button = new JButton(this.SELECT);
    private JButton save_button = new JButton("Save text");
    private JButton read_text = new JButton("Read text");
    private JButton read_error = new JButton("Read errorlog");
    private JTextArea error_text = new JTextArea();
    private String filename = "";
    private String last_text = null;

    public PostGui(String string, DvKeyBlock[] dvKeyBlockArray, ArrayList arrayList) {
        this.filename = string;
        this.setTitle("Vdbench Data Validation post processing utility for file " + new File(this.filename).getAbsolutePath());
        Dimension dimension = new Dimension(1280, 768);
        this.setSize(dimension);
        this.split_panel.setSize(dimension);
        this.overview = new StringBuffer(65536);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.overview.append((String)arrayList.get(i) + "\n");
        }
        this.right_text.setFont(new Font("Courier New", 0, 12));
        this.setAndSaveText(this.overview.toString());
        this.left_table.setModel(this.left_model);
        this.left_model.setBlocks(dvKeyBlockArray);
        this.sizeColumn(0, this.left_table);
        this.sizeColumn(1, this.left_table);
        this.sizeColumn(2, this.left_table);
        this.sizeColumn(3, this.left_table);
        this.overview_button.addActionListener(this);
        this.close_button.addActionListener(this);
        this.lba_button.addActionListener(this);
        this.reread.addActionListener(this);
        this.only_button.addActionListener(this);
        this.save_button.addActionListener(this);
        this.read_text.addActionListener(this);
        this.read_error.addActionListener(this);
        this.buttons.add(this.close_button);
        this.buttons.add(this.overview_button);
        this.buttons.add(this.reread);
        this.buttons.add(this.lba_button);
        this.buttons.add(this.only_button);
        this.buttons.add(this.save_button);
        this.buttons.add(this.read_text);
        this.buttons.add(this.read_error);
        this.left_panel.setLayout(new GridBagLayout());
        this.left_panel.add((Component)this.error_scroll, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.2, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.left_panel.add((Component)this.left_scroll, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.8, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.split_panel.setLeftComponent(this.left_panel);
        this.split_panel.setRightComponent(this.right_scroll);
        this.error_text.setBackground(new Color(238, 238, 238));
        this.left_scroll.setViewportView(this.left_table);
        this.right_scroll.setViewportView(this.right_text);
        this.error_scroll.setViewportView(this.error_text);
        this.error_scroll.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Short error text"));
        this.left_scroll.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Failed Key blocks"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.left_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PostGui.this.tbl_mousePressed(mouseEvent);
            }
        });
        this.left_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PostGui.this.row_changed();
            }
        });
        this.right_text.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PostGui.this.displayOnly();
                }
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.buttons, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.split_panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.left_table.setRowSelectionInterval(0, 0);
        this.split_panel.setDividerLocation(0.3);
        Message.centerscreen(this);
    }

    public void setText(String string) {
        this.right_text.setText(string);
        this.right_text.setCaretPosition(0);
        this.only_button.setText(this.SELECT);
    }

    public void setAndSaveText(String string) {
        this.setText(string);
        this.last_text = string;
    }

    public void infoMsg(String string) {
        JOptionPane.showMessageDialog(this, string, "Information message", 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.overview_button.getText())) {
            this.setAndSaveText(this.overview.toString());
        } else if (string.equals(this.lba_button.getText())) {
            this.displayCurrentLba();
        } else if (string.equals(this.close_button.getText())) {
            this.dispose();
        } else if (string.equals(this.save_button.getText())) {
            this.saveDisplayData();
        } else if (string.equals(this.read_text.getText())) {
            this.readDisplayData(null);
        } else if (string.equals(this.read_error.getText())) {
            this.readDisplayData(this.filename);
        } else if (string.equals(this.SELECT)) {
            this.displayOnly();
        } else if (string.equals(this.RESET)) {
            this.setText(this.last_text);
        } else if (string.equals(this.reread.getText())) {
            this.reReadCurrentLba();
        }
    }

    private void displayOnly() {
        if (this.right_text.getSelectedText() == null) {
            return;
        }
        String string = this.right_text.getSelectedText().toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(65536);
        StringTokenizer stringTokenizer = new StringTokenizer(this.last_text, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.toLowerCase().indexOf(string) == -1) continue;
            stringBuffer.append(string2 + "\n");
        }
        this.setText(stringBuffer.toString());
        this.only_button.setText(this.RESET);
    }

    void tbl_mousePressed(MouseEvent mouseEvent) {
        int n = this.left_table.getSelectedRow();
        if (mouseEvent.getClickCount() > 1) {
            this.displayCurrentLba();
        } else {
            this.row_changed();
        }
    }

    void row_changed() {
        int n = this.left_table.getSelectedRow();
        DvKeyBlock dvKeyBlock = this.left_model.getRowAt(n);
        this.error_text.setText("Double click on any row to display just this Key block.\nDouble click on any data on the right side to only display selected values.\nErrors for this block:\n" + dvKeyBlock.getBlockStatus());
    }

    private void saveDisplayData() {
        String string = PostGui.askForFile(this.filename, "Enter file name:");
        if (string == null) {
            return;
        }
        if (!string.endsWith(".txt")) {
            string = string + ".txt";
        }
        Fput fput = new Fput(string);
        fput.println(this.right_text.getText() + "\n");
        fput.close();
    }

    private void readDisplayData(String string) {
        String string2 = string;
        if (string == null && (string2 = PostGui.askForFile(this.filename, "Enter file name:")) == null) {
            return;
        }
        Fget fget = new Fget(string2);
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer(32768);
        while ((string3 = fget.get()) != null) {
            stringBuffer.append(string3 + "\n");
        }
        fget.close();
        this.setAndSaveText(stringBuffer.toString());
    }

    private void reReadCurrentLba() {
        int n = this.left_table.getSelectedRow();
        DvKeyBlock dvKeyBlock = this.left_model.getRowAt(n);
        long l = Native.openFile(dvKeyBlock.lun);
        if (l < 0L) {
            this.infoMsg(String.format("Lun '%s' either does not exist or you do not have read access.", dvKeyBlock.lun));
            return;
        }
        Native.closeFile(l);
        Vector vector = PrintBlock.printit(dvKeyBlock.lun, dvKeyBlock.logical_lba - dvKeyBlock.file_start_lba, dvKeyBlock.key_block_size, dvKeyBlock.key_block_size);
        StringBuffer stringBuffer = new StringBuffer(65536);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.elementAt(i) + "\n");
        }
        this.setAndSaveText(stringBuffer.toString());
    }

    private void displayCurrentLba() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSS zzz");
        String string = "%" + simpleDateFormat.toPattern().length() + "s";
        int n = this.left_table.getSelectedRow();
        DvKeyBlock dvKeyBlock = this.left_model.getRowAt(n);
        StringBuffer stringBuffer = new StringBuffer(65536);
        stringBuffer.append("Timeline for this Key block (not guaranteed to be reported in proper sequence): \n");
        if (dvKeyBlock.first_sector_written_tod != null) {
            stringBuffer.append(String.format("%s - 'time written' found in first bad sector: \n", simpleDateFormat.format(dvKeyBlock.first_sector_written_tod)));
        }
        if (dvKeyBlock.last_valid != null && dvKeyBlock.last_valid_rw != null) {
            stringBuffer.append(String.format("%s - Last time this Key block was %s \n", simpleDateFormat.format(dvKeyBlock.last_valid), dvKeyBlock.last_valid_rw));
        }
        if (dvKeyBlock.first_dvpost_line_tod != null) {
            stringBuffer.append(String.format(string + " - TOD of first 'dvpost' error found for this Key block. \n", dvKeyBlock.first_dvpost_line_tod + "    "));
        }
        for (int i = 0; i < dvKeyBlock.raw_input.size(); ++i) {
            stringBuffer.append((String)dvKeyBlock.raw_input.get(i) + "\n");
        }
        this.setAndSaveText(stringBuffer.toString());
    }

    public void sizeColumn(int n, JTable jTable) {
        int n2 = 0;
        for (int i = 0; i < this.left_model.getRowCount(); ++i) {
            String string = (String)this.left_model.getValueAt(i, n);
            if (string == null) continue;
            n2 = Math.max(n2, jTable.getFontMetrics(jTable.getFont()).stringWidth(string));
        }
        if (jTable.getRowCount() == 0) {
            return;
        }
        Insets insets = ((JComponent)((Object)jTable.getCellRenderer(0, n))).getInsets();
        n2 += insets.left + insets.right + 5;
        n2 = Math.max(n2, 25);
        jTable.getColumnModel().getColumn(n).setMinWidth(n2);
    }

    public static String askForFile(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser(new File(string).getAbsolutePath());
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(string2);
        if (jFileChooser.showOpenDialog(null) == 0) {
            String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
            return string3;
        }
        return null;
    }
}

