/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Utils.Getopt;
import Vdb.BoxPrint;
import Vdb.DvKeyBlock;
import Vdb.File_handles;
import Vdb.Jnl_entry;
import Vdb.Native;
import Vdb.OpenFlags;
import Vdb.common;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class PrintBlock {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static DateFormat df = new SimpleDateFormat("(MM/dd/yyyy HH:mm:ss.SSS zzz)");
    private static DateFormat df_utc = new SimpleDateFormat("(MM/dd/yyyy HH:mm:ss.SSS zzz)");
    private static boolean zapit = false;
    private static int zapoffset = -1;
    private static int zapvalue = 19088743;
    private static boolean quiet = true;
    private static int dedupunit = 0;
    private static String openflag = null;
    private static OpenFlags oflags = new OpenFlags();

    private static void usage() {
        common.ptod("");
        common.ptod("Usage: ./vdbench print device lba xfersize [-f openflag]");
        common.ptod("       device:   any device or file");
        common.ptod("       lba:      logical byte address. ");
        common.ptod("                 May be prefixed with 0x if this is hexadecimal. ");
        common.ptod("                 You may also specify k or m for kilobytes or megabytes.");
        common.ptod("                 lba must be multiple of 512 bytes, but will be truncated if not.");
        common.ptod("       length:   Number of bytes to print.");
        common.ptod("       -f:       'open flag' One open flag, e.g. 'directio', see Vdbench doc under 'openflags='");
        common.ptod("");
    }

    public static void print(String[] stringArray) {
        stringArray[0] = "print";
        Getopt getopt = new Getopt(stringArray, "u:qzo:v:f:h", 99);
        Vector<String> vector = getopt.get_positionals();
        if (vector.size() != 4) {
            PrintBlock.usage();
            common.failure("Bad syntax");
        }
        Native.allocSharedMemory();
        zapit = getopt.check('z');
        if (getopt.check('o')) {
            zapoffset = Integer.parseInt(getopt.get_string(), 16);
        }
        if (getopt.check('v')) {
            zapvalue = (int)Long.parseLong(getopt.get_string(), 16);
        }
        if (getopt.check('u')) {
            dedupunit = getopt.extractInt();
        }
        if (getopt.check('f')) {
            oflags = new OpenFlags(new String[]{getopt.get_string()}, null);
            BoxPrint.printOne("Opening input file/disk using open() flag '%s'", getopt.get_string());
        }
        String string = getopt.get_positional(1);
        String string2 = getopt.get_positional(2);
        String string3 = getopt.get_positional(3);
        long l = string2.startsWith("0x") ? Long.parseLong(string2.substring(2), 16) : (string2.endsWith("k") ? Long.parseLong(string2.substring(0, string2.length() - 1)) * 1024L : (string2.endsWith("m") ? Long.parseLong(string2.substring(0, string2.length() - 1)) * 1024L * 1024L : (string2.endsWith("g") ? Long.parseLong(string2.substring(0, string2.length() - 1)) * 1024L * 1024L * 1024L : Long.parseLong(string2))));
        if (l % 512L != 0L) {
            long l2 = l;
            common.ptod("lba truncated from 0x%08x to 0x%08x (must be multiple of 512)", l2, l &= 0xFFFFFFFFFFFFFE00L);
        }
        int n = string3.endsWith("k") ? Integer.parseInt(string3.substring(0, string3.length() - 1)) * 1024 : (string3.endsWith("m") ? Integer.parseInt(string3.substring(0, string3.length() - 1)) * 1024 * 1024 : Integer.parseInt(string3));
        int n2 = (n + 511) / 512 * 512;
        System.out.println(String.format("Device: %s; lba: 0x%08x length: %d", string, l, n));
        Vector vector2 = PrintBlock.printit(string, l, n2, n);
        for (int i = 0; i < vector2.size(); ++i) {
            System.out.println((String)vector2.elementAt(i));
        }
    }

    public static Vector printit(String string, long l, int n, int n2) {
        int n3;
        Vector<String> vector = new Vector<String>(512);
        Vector<Integer> vector2 = new Vector<Integer>(n / 512);
        int n4 = 0;
        int[] nArray = new int[128];
        long l2 = Native.openFile(string, oflags, 0);
        if (l2 < 0L) {
            common.failure("Can't open disk file: " + string);
        }
        File_handles.addHandle(l2, "Vdbench print " + string);
        long l3 = Native.allocBuffer(n);
        int[] nArray2 = new int[n / 4];
        long l4 = Native.readFile(l2, l, n, l3);
        if (l4 != 0L) {
            common.failure("Error reading block " + string + " " + l + " " + n);
        }
        Native.closeFile(l2);
        Native.buffer_to_array(nArray2, l3, n);
        if (dedupunit == 0) {
            vector.add("lba             blk      sector data read                           " + (!quiet ? "Notes; LFSR data valid t/f " : ""));
        } else {
            vector.add("lba             blk       dedup    sector data read                           " + (!quiet ? "Notes; LFSR data valid t/f " : ""));
        }
        int n5 = n / 512;
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            boolean bl = false;
            vector.add("");
            String string2 = "";
            int n7 = nArray2[n6 + 2];
            int n8 = nArray2[n6 + 3];
            long l5 = Jnl_entry.make64(n7, n8);
            String string3 = df.format(new Date(l5));
            df_utc.setTimeZone(TimeZone.getTimeZone("UTC"));
            String string4 = df_utc.format(new Date(l5));
            long l6 = PrintBlock.calc_checksum(l5);
            int n9 = nArray2[n6 + 0];
            int n10 = nArray2[n6 + 1];
            long l7 = Jnl_entry.make64(n9, n10);
            if (!quiet && l7 != l) {
                string2 = "(wrong lba) ";
                bl = true;
                vector.add("Wrong lba read. LFSR pattern generated using this lba");
            }
            int n11 = nArray2[n6 + 4] >> 24;
            String string5 = PrintBlock.xlateToString(nArray2[5], nArray2[6]);
            int[] nArray3 = new int[128];
            System.arraycopy(nArray, 0, nArray3, 8, 120);
            nArray = nArray3;
            for (int i = 0; i < 32 && i < (n2 + 15) / 4 / 4; ++i) {
                int n12;
                String string6 = "";
                String string7 = "";
                String string8 = "";
                string6 = string6 + String.format("0x%012x ", l + (long)(n6 * 4));
                string6 = string6 + Format.f("+0x%06x ", n6 * 4);
                if (dedupunit != 0) {
                    string6 = string6 + Format.f("+0x%06x ", (l + (long)(n6 * 4)) % (long)dedupunit);
                }
                string6 = string6 + Format.f("0x%03x  ", n6 * 4 % 512);
                for (n12 = 0; n12 < 4; ++n12) {
                    string6 = string6 + Format.f("%08x ", nArray2[n6 + n12]);
                }
                if (!quiet) {
                    for (n12 = 0; n6 % 128 > 4 && n12 < 4; ++n12) {
                        if (nArray2[n6 + n12] == nArray[n6 % 128 + n12]) {
                            string7 = string7 + "t";
                            continue;
                        }
                        string7 = string7 + "f";
                        bl = true;
                        string8 = string8 + Format.f(" %08x", nArray[n6 % 128 + n12]);
                    }
                    if (n6 % 128 == 0) {
                        string6 = string6 + string2;
                        string6 = string6 + string3;
                    } else if (n6 % 128 > 1) {
                        string6 = string6 + string7 + string8;
                    }
                }
                if (dedupunit != 0 && (l + (long)(n6 * 4)) % (long)dedupunit == 0L) {
                    string6 = string6 + String.format(" dedup %08x %08x", nArray2[n6 + 0], nArray2[n6 + 1]);
                    long l8 = (long)nArray2[n6 + 0] << 32 | (long)nArray2[n6 + 1];
                    string6 = l8 == l + (long)(n6 * 4) ? string6 + " unique" : string6 + " duplicate";
                }
                if (n6 + 4 < nArray2.length && l6 == (long)(nArray2[n6 + 4] >> 16 & 0xFF)) {
                    string6 = string6 + string3 + " " + string4;
                }
                vector.add(string6);
                n6 += 4;
            }
            if (!bl) continue;
            ++n4;
            vector2.add(new Integer(n3));
        }
        if (!quiet) {
            vector.insertElementAt("", 0);
            vector.insertElementAt(String.format("With a block size of %d bytes, %d of %d sectors had miscompares.", n, n4, n5), 0);
        }
        vector.insertElementAt("", 0);
        if (!quiet) {
            vector.insertElementAt(DvKeyBlock.compressSectorNumbers(vector2, n5), 0);
        }
        if (!zapit) {
            return vector;
        }
        l2 = Native.openFile(string, 1);
        if (l2 < 0L) {
            common.failure("Can't open disk file");
        }
        if (zapoffset < 0) {
            for (n3 = 0; n3 < nArray2.length; n3 += 2) {
                nArray2[n3] = 19088743;
                nArray2[n3 + 1] = -1985229329;
            }
            vector.add("Block has now been overwritten with values 0x0123456789abcdef");
        } else {
            vector.add(String.format("Offset 0x%08x contains      0x%08x", zapoffset, nArray2[zapoffset / 4]));
            nArray2[PrintBlock.zapoffset / 4] = zapvalue;
            vector.add(String.format("Offset 0x%08x replaced with 0x%08x", zapoffset, zapvalue));
        }
        Native.arrayToBuffer(nArray2, l3);
        l4 = Native.writeFile(l2, l, n, l3);
        if (l4 != 0L) {
            common.failure("Error writing block");
        }
        Native.closeFile(l2);
        return vector;
    }

    private static String xlateToString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        String string = System.getProperty("os.arch");
        if (string.equals("x86")) {
            stringBuffer.append((char)(n & 0xFF));
            stringBuffer.append((char)(n >>> 8 & 0xFF));
            stringBuffer.append((char)(n >>> 16 & 0xFF));
            stringBuffer.append((char)(n >>> 24 & 0xFF));
            stringBuffer.append((char)(n2 & 0xFF));
            stringBuffer.append((char)(n2 >>> 8 & 0xFF));
            stringBuffer.append((char)(n2 >>> 16 & 0xFF));
            stringBuffer.append((char)(n2 >>> 24 & 0xFF));
        } else {
            stringBuffer.append((char)(n >>> 24 & 0xFF));
            stringBuffer.append((char)(n >>> 16 & 0xFF));
            stringBuffer.append((char)(n >>> 8 & 0xFF));
            stringBuffer.append((char)(n & 0xFF));
            stringBuffer.append((char)(n2 >>> 24 & 0xFF));
            stringBuffer.append((char)(n2 >>> 16 & 0xFF));
            stringBuffer.append((char)(n2 >>> 8 & 0xFF));
            stringBuffer.append((char)(n2 & 0xFF));
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (Character.isSpace(stringBuffer.charAt(i)) || Character.isLetterOrDigit(stringBuffer.charAt(i))) continue;
            return "nostring";
        }
        return stringBuffer.toString();
    }

    private static long calc_checksum(long l) {
        long l2 = 0L;
        l2 += l;
        l2 += l >> 8;
        l2 += l >> 16;
        l2 += l >> 24;
        l2 += l >> 32;
        l2 += l >> 40;
        l2 += l >> 48;
        l2 += l >> 56;
        return l2 &= 0xFFL;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[128];
        nArray[5] = 1633837924;
        nArray[6] = 1701209856;
        String string = PrintBlock.xlateToString(nArray[5], nArray[6]);
        common.ptod("ret: " + string + "<");
    }
}

