/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.ControlUsers;
import Utils.ClassPath;
import Utils.Format;
import Utils.printf;
import Vdb.BoxPrint;
import Vdb.Bursts;
import Vdb.ConcatSds;
import Vdb.Debug_cmds;
import Vdb.FileAnchor;
import Vdb.Flat;
import Vdb.For_loop;
import Vdb.FormatFlags;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwgEntry;
import Vdb.HandleSkew;
import Vdb.Host;
import Vdb.Jnl_entry;
import Vdb.OpenFlags;
import Vdb.Operations;
import Vdb.ReplayInfo;
import Vdb.Report;
import Vdb.SD_entry;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.Status;
import Vdb.StreamContext;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.WD_entry;
import Vdb.WG_entry;
import Vdb.WhereWhatWork;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class RD_entry
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String rd_name;
    String[] wd_names = new String[0];
    String[] sd_names = null;
    SD_entry concat_sd = null;
    Vector<WD_entry> wds_for_rd = new Vector(4, 0);
    Vector<FwdEntry> fwds_for_rd = new Vector(4, 0);
    String[] fwd_names = new String[0];
    String[] fsd_names = new String[0];
    String[] fwd_operations = new String[0];
    double[] skew = null;
    boolean foroperations_used = false;
    boolean operations_used = false;
    Vector<FwgEntry> fwgs_for_rd = new Vector(4, 0);
    double fwd_rate = 0.0;
    FormatFlags format = new FormatFlags();
    double compression_ratio_to_use = -1.0;
    Bursts bursts = null;
    String rd_mount = null;
    public int rd_stream_count = 0;
    double iorate;
    double iorate_pct = 0.0;
    double iorate_req = 0.0;
    static long NO_ELAPSED = 99999998L;
    private long elapsed = 30L;
    private long interval = 1L;
    private long warmup = 0L;
    private boolean variable = false;
    private boolean spread = true;
    private double[] pending_rates = null;
    int distribution = 0;
    long pause = 0L;
    Vector for_list = new Vector(4, 0);
    public ArrayList<WG_entry> wgs_for_rd = null;
    boolean use_waiter = true;
    static RD_entry next_rd = null;
    static Vector next_do_list = null;
    static int next_do_entry = 0;
    double max_data = Double.MAX_VALUE;
    double max_data_r = Double.MAX_VALUE;
    double max_data_w = Double.MAX_VALUE;
    For_loop current_override = null;
    double[] curve_points = null;
    boolean doing_curve_max = false;
    boolean doing_curve_point = false;
    boolean curve_used_waiter = false;
    double curve_end = Double.MAX_VALUE;
    public OpenFlags open_flags = null;
    static RD_entry dflt = new RD_entry();
    public static int MAX_RATE = 9999988;
    public static int CURVE_RATE = 0x989669;
    public Debug_cmds start_cmd = new Debug_cmds();
    public Debug_cmds end_cmd = new Debug_cmds();
    public static RD_entry recovery_rd = null;
    private static int sequence = 0;
    private int seqno = sequence++;
    private HashMap<String, ArrayList<StreamContext>> threads_per_slave_map = null;
    public static int IOS_PER_JVM = 100000;
    public static int DEFAULT_JVMS = 8;
    public static boolean fwd_thread_adjust = true;
    public static String FSD_FORMAT_RUN = "format_for_";
    private static boolean debug_rd_list = false;
    private static int workload_index = 0;
    private static Vector extra_wds = new Vector(8, 0);
    private static int once = 0;
    private boolean format_inserted = false;
    private WD_entry prev_wd = null;
    private static String restart_rd = null;
    private static boolean rd_only = true;

    public Object clone() {
        try {
            RD_entry rD_entry = (RD_entry)super.clone();
            rD_entry.seqno = sequence++ + 1000;
            rD_entry.wd_names = (String[])this.wd_names.clone();
            rD_entry.fwd_names = (String[])this.fwd_names.clone();
            rD_entry.fsd_names = (String[])this.fsd_names.clone();
            rD_entry.fwd_operations = (String[])this.fwd_operations.clone();
            rD_entry.for_list = (Vector)this.for_list.clone();
            rD_entry.start_cmd = (Debug_cmds)this.start_cmd.clone();
            rD_entry.end_cmd = (Debug_cmds)this.end_cmd.clone();
            rD_entry.wds_for_rd = (Vector)this.wds_for_rd.clone();
            rD_entry.fwds_for_rd = (Vector)this.fwds_for_rd.clone();
            rD_entry.fwgs_for_rd = (Vector)this.fwgs_for_rd.clone();
            if (rD_entry.bursts != null) {
                rD_entry.bursts = (Bursts)this.bursts.clone();
            }
            if (this.curve_points != null) {
                rD_entry.curve_points = (double[])this.curve_points.clone();
            }
            if (this.skew != null) {
                rD_entry.skew = (double[])this.skew.clone();
            }
            if (this.open_flags != null) {
                rD_entry.open_flags = (OpenFlags)this.open_flags.clone();
            }
            rD_entry.format = null;
            return rD_entry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    private static void rd_get_first_workload(Vector vector) {
        next_rd = (RD_entry)vector.firstElement();
        next_do_entry = 0;
        next_do_list = new Vector(32, 0);
        For_loop.for_get(0, next_rd, next_do_list);
        RD_entry.next_rd.current_override = (For_loop)next_do_list.elementAt(next_do_entry++);
    }

    private static void rd_get_next_rd(Vector vector) {
        int n = vector.indexOf(next_rd);
        if (n < 0) {
            common.failure("rd_get_next_rd(): rd_list search failed()");
        }
        if (n + 1 >= vector.size()) {
            next_rd = null;
            return;
        }
        next_rd = (RD_entry)vector.elementAt(n + 1);
        next_do_entry = 0;
        next_do_list = new Vector(32, 0);
        For_loop.for_get(0, next_rd, next_do_list);
        RD_entry.next_rd.current_override = (For_loop)next_do_list.elementAt(next_do_entry++);
    }

    private static RD_entry rd_next_workload(Vector vector) {
        if (next_rd == null) {
            RD_entry.rd_get_first_workload(vector);
        } else if (next_do_entry < next_do_list.size()) {
            RD_entry.next_rd.current_override = (For_loop)next_do_list.elementAt(next_do_entry++);
        } else {
            RD_entry.rd_get_next_rd(vector);
        }
        return next_rd;
    }

    public static RD_entry getNextWorkload() {
        if (next_rd == null) {
            workload_index = 0;
        }
        next_rd = Vdbmain.rd_list.size() == workload_index ? null : Vdbmain.rd_list.elementAt(workload_index++);
        return next_rd;
    }

    public static void displaySimulatedRuns() {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < Vdbmain.rd_list.size(); ++i) {
            RD_entry rD_entry = Vdbmain.rd_list.elementAt(i);
            rD_entry.display_run();
            if (rD_entry.getElapsed() != NO_ELAPSED) {
                l2 += rD_entry.getElapsed();
            }
            l2 += rD_entry.getWarmup();
            ++l;
        }
        common.ptod("Total amount of Run Definitions: %d; total elapsed time %d seconds, or %.4f hours, plus a format if requested.", l, l2, (double)l2 / 3600.0);
    }

    public void display_run() {
        boolean bl = false;
        String string = this.rd_name;
        String string2 = null;
        String string3 = "";
        if (!this.rd_name.startsWith(FSD_FORMAT_RUN) && this.current_override.getText() != null) {
            string3 = this.current_override.getText();
        }
        Status.clear();
        Status.printRdStatus("Starting", new Object[0]);
        String string4 = this.getElapsed() == NO_ELAPSED ? "; elapsed=(none); " : (this.getWarmup() > 0L ? "; elapsed=" + this.getElapsed() + " warmup=" + this.getWarmup() + "; " : "; elapsed=" + this.getElapsed() + "; ");
        if (Vdbmain.isFwdWorkload()) {
            String string5 = "fwdrate=";
            string5 = this.fwd_rate == (double)MAX_RATE ? string5 + "max. " : (this.fwd_rate == (double)CURVE_RATE ? string5 + "curve. " : string5 + (int)this.fwd_rate + "; ");
            string2 = (Vdbmain.simulate ? "Simulating RD=" : "Starting RD=") + this.rd_name;
            if (!this.rd_name.startsWith(FSD_FORMAT_RUN)) {
                string2 = string2 + string4 + string5 + string3;
            }
        } else {
            String string6;
            String string7;
            String string8 = string7 = Vdbmain.simulate ? "Simulating RD=" : "Starting RD=";
            if (ReplayInfo.isReplay()) {
                string6 = Format.f("; I/O rate (Replay): %6d", this.iorate);
            } else if (this.iorate == (double)MAX_RATE && this.use_waiter) {
                string6 = "; I/O rate: Controlled MAX";
            } else if (this.iorate == (double)MAX_RATE && !this.use_waiter) {
                string6 = "; I/O rate: Uncontrolled MAX";
            } else if (this.iorate == (double)CURVE_RATE && this.use_waiter) {
                string6 = "; I/O rate: Controlled curve";
            } else if (this.iorate == (double)CURVE_RATE && !this.use_waiter) {
                string6 = "; I/O rate: Uncontrolled curve";
            } else if (this.bursts != null) {
                string6 = "; I/O rate: Variable";
            } else {
                bl = this.iorate == 0.0;
                string6 = Format.f("; I/O rate: %d", this.iorate);
            }
            string2 = string7 + string + string6 + string4 + string3;
        }
        if (Vdbmain.isWdWorkload() && !Vdbmain.simulate) {
            Flat.reportWgParameters(this);
        }
        if (Vdbmain.isFwdWorkload() && !Vdbmain.simulate) {
            Flat.reportFwgParameters(this);
        }
        if (Vdbmain.simulate) {
            common.pboth(string2, new Object[0]);
        } else {
            Report.displayRunStart(string2, this);
        }
        if (bl) {
            common.failure("iorate= parameter is missing.");
        }
        if (Vdbmain.simulate) {
            return;
        }
        Flat.put_col("Run", string);
        if (Vdbmain.isWdWorkload()) {
            Flat.put_col("reqrate", this.iorate);
        } else {
            Flat.put_col("reqrate", this.fwd_rate);
        }
    }

    static RD_entry rd_check_duplicate(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            RD_entry rD_entry = (RD_entry)vector.elementAt(i);
            if (rD_entry.rd_name.compareTo(string) != 0) continue;
            common.failure("Duplicate RD names not allowed: " + string);
        }
        return null;
    }

    static String readParms(Vector vector, String string) {
        String string2 = string;
        Vdb_scan vdb_scan = null;
        RD_entry rD_entry = null;
        if (string == null) {
            return null;
        }
        try {
            do {
                vdb_scan = Vdb_scan.parms_split(string2);
                if (vdb_scan.keyword.equals("rd")) {
                    if (vdb_scan.alphas[0].equals("default")) {
                        rD_entry = dflt;
                        continue;
                    }
                    rD_entry = (RD_entry)dflt.clone();
                    rD_entry.format = new FormatFlags();
                    rD_entry.rd_name = vdb_scan.alphas[0];
                    if (Vdbmain.isFwdWorkload()) {
                        rD_entry.format.parseParameters(new String[0]);
                    }
                    if (rD_entry.rd_name.equals(Jnl_entry.RECOVERY_RUN_NAME)) {
                        recovery_rd = rD_entry;
                        continue;
                    }
                    RD_entry.rd_check_duplicate(vector, vdb_scan.alphas[0]);
                    vector.addElement(rD_entry);
                    continue;
                }
                if (vdb_scan.keyword.equals("wd")) {
                    rD_entry.addWD(vdb_scan.alphas);
                    continue;
                }
                if (vdb_scan.keyword.equals("sd")) {
                    rD_entry.sd_names = vdb_scan.alphas;
                    continue;
                }
                if (vdb_scan.keyword.equals("fsd")) {
                    rD_entry.fsd_names = vdb_scan.alphas;
                    continue;
                }
                if ("iorate".startsWith(vdb_scan.keyword)) {
                    if (Vdbmain.isFwdWorkload()) {
                        common.failure("Specifying 'iorate=' for a File System workload. Use 'fwdrate=' instead.");
                    }
                    if (vdb_scan.getAlphaCount() == 1 && vdb_scan.alphas[0].compareTo("curve") == 0) {
                        rD_entry.iorate_req = CURVE_RATE;
                        rD_entry.doing_curve_max = true;
                        continue;
                    }
                    if (vdb_scan.getAlphaCount() == 1 && vdb_scan.alphas[0].toLowerCase().compareTo("max") == 0) {
                        rD_entry.iorate_req = MAX_RATE;
                        continue;
                    }
                    if (vdb_scan.getNumCount() > 1) {
                        rD_entry.pending_rates = (double[])vdb_scan.numerics.clone();
                    }
                    rD_entry.iorate_req = vdb_scan.numerics[0];
                    continue;
                }
                if (vdb_scan.keyword.startsWith("maxdata")) {
                    if (vdb_scan.numerics[0] < 100.0 && !Vdbmain.isWdWorkload()) {
                        common.failure("maxdata= (<100) only allowed for SD/WD workloads");
                    }
                    if (vdb_scan.keyword.equals("maxdata")) {
                        rD_entry.max_data = vdb_scan.numerics[0];
                        continue;
                    }
                    if (vdb_scan.keyword.equals("maxdataread")) {
                        rD_entry.max_data_r = vdb_scan.numerics[0];
                        continue;
                    }
                    if (vdb_scan.keyword.equals("maxdatawritten")) {
                        rD_entry.max_data_w = vdb_scan.numerics[0];
                        continue;
                    }
                    common.failure("Unknown parameter: " + vdb_scan.keyword);
                    continue;
                }
                if ("curve".startsWith(vdb_scan.keyword)) {
                    rD_entry.curve_points = vdb_scan.numerics;
                    continue;
                }
                if ("stopcurve".startsWith(vdb_scan.keyword)) {
                    rD_entry.curve_end = vdb_scan.numerics[0];
                    continue;
                }
                if ("elapsed".startsWith(vdb_scan.keyword)) {
                    rD_entry.setElapsed((long)vdb_scan.numerics[0]);
                    continue;
                }
                if ("interval".startsWith(vdb_scan.keyword)) {
                    rD_entry.setInterval((long)vdb_scan.numerics[0]);
                    continue;
                }
                if ("warmup".startsWith(vdb_scan.keyword)) {
                    rD_entry.setWarmup((long)vdb_scan.numerics[0]);
                    continue;
                }
                if (vdb_scan.keyword.equals("replay")) {
                    ReplayInfo.setReplay();
                    ReplayInfo.getInfo().parseParameters(vdb_scan.alphas);
                    continue;
                }
                if ("pause".startsWith(vdb_scan.keyword)) {
                    rD_entry.pause = (long)vdb_scan.numerics[0];
                    continue;
                }
                if (For_loop.checkForLoop(rD_entry, vdb_scan)) continue;
                if ("distribution".startsWith(vdb_scan.keyword)) {
                    rD_entry.useDistribution(vdb_scan);
                    continue;
                }
                if ("startcmd".startsWith(vdb_scan.keyword) || "start_cmd".startsWith(vdb_scan.keyword)) {
                    rD_entry.start_cmd.storeCommands(vdb_scan.alphas);
                    continue;
                }
                if ("endcmd".startsWith(vdb_scan.keyword) || "end_cmd".startsWith(vdb_scan.keyword)) {
                    rD_entry.end_cmd.storeCommands(vdb_scan.alphas);
                    continue;
                }
                if (vdb_scan.keyword.equals("fwd")) {
                    rD_entry.fwd_names = vdb_scan.alphas;
                    continue;
                }
                if ("fwdrate".startsWith(vdb_scan.keyword)) {
                    if (Vdbmain.isWdWorkload()) {
                        common.failure("Specifying 'fwdrate=' for a raw workload. Use 'iorate=' instead.");
                    }
                    if (vdb_scan.getAlphaCount() == 1 && vdb_scan.alphas[0].compareTo("curve") == 0) {
                        rD_entry.fwd_rate = CURVE_RATE;
                        rD_entry.doing_curve_max = true;
                        continue;
                    }
                    if (vdb_scan.getAlphaCount() > 0 && vdb_scan.alphas[0].equalsIgnoreCase("max")) {
                        rD_entry.fwd_rate = MAX_RATE;
                        continue;
                    }
                    if (vdb_scan.getNumCount() > 1) {
                        rD_entry.fwd_rate = 1.0;
                        new For_loop("foriorate", vdb_scan.numerics, rD_entry.for_list);
                        continue;
                    }
                    rD_entry.fwd_rate = vdb_scan.numerics[0];
                    continue;
                }
                if ("operations".startsWith(vdb_scan.keyword)) {
                    rD_entry.storeOperations(vdb_scan);
                    continue;
                }
                if ("format".startsWith(vdb_scan.keyword)) {
                    if (rD_entry == dflt) {
                        common.failure("'format=' parameter is not allowed for rd=default");
                    }
                    rD_entry.format.parseParameters(vdb_scan.alphas);
                    continue;
                }
                if ("openflags".startsWith(vdb_scan.keyword)) {
                    rD_entry.open_flags = new OpenFlags(vdb_scan.alphas, vdb_scan.numerics);
                    continue;
                }
                if ("mount".startsWith(vdb_scan.keyword)) {
                    if (!Host.anyMountCommands()) {
                        common.failure("'rd=" + rD_entry.rd_name + ",mount=' requested without " + "an accompanying 'hd=xxx,mount=' request");
                    }
                    rD_entry.rd_mount = vdb_scan.alphas[0];
                    if (!rD_entry.rd_mount.startsWith("mount")) continue;
                    common.failure("'rd=" + rD_entry.rd_name + ",mount=' may only contain mount options ");
                    continue;
                }
                common.failure("Unknown keyword: " + vdb_scan.keyword);
            } while ((string2 = Vdb_scan.parms_get()) != null);
            if (vector.size() == 0) {
                common.failure("No RD parameters specified");
            }
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.failure("Exception during reading of input parameter file(s).");
        }
        return string2;
    }

    public static void parserCleanup(Vector vector) {
        RD_entry rD_entry;
        int n;
        for (n = 0; n < vector.size(); ++n) {
            rD_entry = (RD_entry)vector.elementAt(n);
            if (!rD_entry.format.format_once_requested || rD_entry.for_list.size() != 0) continue;
            common.failure("'format=once' can only be used with 'forxxx=' parameters");
        }
        for (n = 0; n < vector.size(); ++n) {
            rD_entry = (RD_entry)vector.elementAt(n);
            if (rD_entry.variable) {
                rD_entry.bursts = new Bursts(rD_entry.pending_rates, rD_entry.spread);
                rD_entry.pending_rates = null;
                rD_entry.iorate_req = rD_entry.bursts.getMaxRate();
            }
            if (rD_entry.pending_rates == null) continue;
            new For_loop("foriorate", rD_entry.pending_rates, rD_entry.for_list);
        }
        for (n = 999990; n < vector.size(); ++n) {
            int n2;
            rD_entry = (RD_entry)vector.elementAt(n);
            if (rD_entry.skew == null) continue;
            if (!Vdbmain.isFwdWorkload()) {
                common.failure("'skew=' parameter may only be used for FWD workloads.");
            }
            double d = 0.0;
            for (n2 = 0; n2 < rD_entry.skew.length; ++n2) {
                d += rD_entry.skew[n2];
            }
            if (d != 100.0) {
                common.failure("rd=" + rD_entry.rd_name + ",skew= parameters must total 100%");
            }
            for (n2 = 0; n2 < rD_entry.fwd_names.length; ++n2) {
                if (rD_entry.fwd_names[n2].indexOf("*") == -1) continue;
                common.failure("rd=" + rD_entry.rd_name + ",skew= parameter may only be used " + "when not having a wildcard in  FWD names: " + rD_entry.fwd_names[n2]);
            }
            if (rD_entry.fwd_operations.length == 0 && rD_entry.skew.length != rD_entry.fwd_names.length) {
                common.failure("rd=" + rD_entry.rd_name + ". The 'skew=' and 'fwd=' (or operations=) parameters " + "must have the same amount of values");
            }
            if (rD_entry.fwd_operations.length == 0 || rD_entry.fwd_operations.length == rD_entry.skew.length) continue;
            common.failure("rd=" + rD_entry.rd_name + ". The 'skew=' and 'operations=' parameters " + "must have the same amount of values");
        }
        for (n = 0; n < vector.size(); ++n) {
            rD_entry = (RD_entry)vector.elementAt(n);
            if (Vdbmain.elapsed > 0 && !rD_entry.rd_name.equals(Jnl_entry.RECOVERY_RUN_NAME)) {
                rD_entry.setElapsed(Vdbmain.elapsed);
            }
            if (Vdbmain.interval > 0) {
                rD_entry.setInterval(Vdbmain.interval);
            }
            if (Vdbmain.warmup > 0) {
                rD_entry.setWarmup(Vdbmain.warmup);
            }
            if (rD_entry.getInterval() == 0L) {
                rD_entry.setInterval(Math.min(rD_entry.getElapsed() / 2L, 60L));
                common.ptod("'interval=' not specified. Setting to " + rD_entry.getInterval() + " seconds. ( 'min(elapsed/2,60)' )");
            }
            if (rD_entry.bursts != null && rD_entry.iorate_req == (double)MAX_RATE) {
                common.failure("'bursts=' and 'iorate=max' are mutually exclusive.");
            }
            if (rD_entry.getElapsed() / rD_entry.getInterval() < 2L) {
                common.failure("'elapsed=' time value must be at least twice the 'interval=' value");
            }
            if (Vdbmain.isFwdWorkload() && rD_entry.fwd_rate == 0.0) {
                common.failure("No fwdrate= specified for rd=" + rD_entry.rd_name);
            }
            if (rD_entry.getElapsed() != NO_ELAPSED && rD_entry.getElapsed() % rD_entry.getInterval() != 0L) {
                common.failure("'elapsed=" + rD_entry.getElapsed() + "' must be multiple of 'interval=" + rD_entry.getInterval() + "'.");
            }
            if (rD_entry.getWarmup() % rD_entry.getInterval() == 0L) continue;
            common.failure("'interval=" + rD_entry.getInterval() + "' must be multiple of 'warmup=" + rD_entry.getWarmup() + "'.");
        }
        vector = RD_entry.repeatSdSingles();
        Vdbmain.rd_list = vector;
        if (Vdbmain.isWdWorkload()) {
            RD_entry.selectWhichWdsToUse(vector);
        } else {
            RD_entry.selectWhichFwdsToUse(vector);
        }
    }

    private void addWD(String[] stringArray) {
        if (this.wd_names.length != 0) {
            common.failure("rd=%s: the 'wd=' parameter may be specified only once per RD, but you may specify it as follows: 'rd=%s,wd=(w1,w2,w3)', etc.", this.rd_name, this.rd_name);
        }
        this.wd_names = stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("*") != -1) continue;
            for (int j = 0; j < Vdbmain.wd_list.size(); ++j) {
                WD_entry wD_entry = Vdbmain.wd_list.elementAt(j);
                if (!wD_entry.wd_name.equals(stringArray[i])) continue;
                return;
            }
            String string = ClassPath.classPath() + "workloads" + File.separator + stringArray[i];
            if (!new File(string).exists()) continue;
            extra_wds.add(string);
        }
    }

    public static Vector getExtraWDs() {
        return extra_wds;
    }

    private void storeOperations(Vdb_scan vdb_scan) {
        if (this.foroperations_used) {
            common.failure("rd=" + this.rd_name + ": 'operations' and 'foroperations' parameters are mutually exclusive");
        }
        for (int i = 0; i < vdb_scan.getAlphaCount(); ++i) {
            int n = Operations.getOperationIdentifier(vdb_scan.alphas[i]);
            if (n >= 0) continue;
            common.failure("Unknown operation in 'operation': " + vdb_scan.alphas[i]);
        }
        this.fwd_operations = vdb_scan.alphas;
        this.operations_used = true;
    }

    public void storeForOperations(Vdb_scan vdb_scan) {
        int n;
        this.foroperations_used = true;
        if (this.operations_used) {
            common.failure("rd=" + this.rd_name + ": 'operations' and 'foroperations' parameters are mutually exclusive");
        }
        for (int i = 0; i < vdb_scan.getAlphaCount(); ++i) {
            n = Operations.getOperationIdentifier(vdb_scan.alphas[i]);
            if (n >= 0) continue;
            common.failure("Unknown operation in 'foroperation': " + vdb_scan.alphas[i]);
        }
        double[] dArray = new double[vdb_scan.getAlphaCount()];
        for (n = 0; n < vdb_scan.getAlphaCount(); ++n) {
            int n2 = Operations.getOperationIdentifier(vdb_scan.alphas[n]);
            dArray[n] = n2;
        }
        new For_loop("foroperation", dArray, this.for_list);
    }

    public void set_iorate() {
        this.iorate = this.iorate_req;
        this.iorate_pct = 0.0;
        if (this.iorate < 0.0) {
            int n = this.doing_curve_point ? (int)Vdbmain.last_curve_max * (int)this.iorate * -1 / 100 : (int)Vdbmain.observed_iorate * (int)this.iorate * -1 / 100;
            n = n > 1000 ? (n + 99) / 100 * 100 : (n + 9) / 10 * 10;
            this.iorate_pct = this.iorate * -1.0;
            this.iorate = n;
            this.fwd_rate = n;
        }
    }

    public void getWdsForRd() {
        if (this.wd_names.length == 0) {
            common.failure("No 'wd=' parameter specified for rd=" + this.rd_name);
        }
        if (this.wds_for_rd.size() > 0) {
            common.failure("This code may only be called once");
        }
        Vector<WD_entry> vector = new Vector<WD_entry>(8, 0);
        for (int i = 0; i < this.wd_names.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < Vdbmain.wd_list.size(); ++j) {
                WD_entry wD_entry = Vdbmain.wd_list.elementAt(j);
                if (wD_entry.wd_name.startsWith("rd=") || !common.simple_wildcard(this.wd_names[i], wD_entry.wd_name) || !this.rd_name.equals(Jnl_entry.RECOVERY_RUN_NAME) && wD_entry.wd_name.startsWith(Jnl_entry.RECOVERY_RUN_NAME)) continue;
                wD_entry.setSkew(wD_entry.skew_original);
                vector.addElement(wD_entry);
                bl = true;
            }
            if (bl) continue;
            common.failure("Could not find WD=" + this.wd_names[i] + " for RD=" + this.rd_name);
        }
        this.wds_for_rd = vector;
        if (this.wds_for_rd.size() == 0) {
            common.failure("No wds_for_rd for rd=" + this.rd_name);
        }
        if (this.wds_for_rd.get((int)0).stream_count > 0 && this.wds_for_rd.size() > 1) {
            common.failure("Only ONE Workload Definition (WD) allowed when using streams.");
        }
        WD_entry.checkPriorities(vector);
    }

    private void getFwdsForRd() {
        FwdEntry fwdEntry;
        int n;
        this.fwds_for_rd.clear();
        for (n = 0; n < this.fwd_names.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < FwdEntry.getFwdList().size(); ++i) {
                fwdEntry = FwdEntry.getFwdList().elementAt(i);
                if (!common.simple_wildcard(this.fwd_names[n], fwdEntry.fwd_name)) continue;
                this.fwds_for_rd.addElement(fwdEntry);
                bl = true;
            }
            if (bl) continue;
            common.failure("Could not find fwd=" + this.fwd_names[n] + " for RD=" + this.rd_name);
        }
        n = 0;
        for (FwdEntry fwdEntry2 : this.fwds_for_rd) {
            if (fwdEntry2.skew == 0.0) continue;
            n = 1;
        }
        if (n == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 1; i < this.fwds_for_rd.size(); ++i) {
            fwdEntry = this.fwds_for_rd.get(0);
            FwdEntry fwdEntry3 = this.fwds_for_rd.get(i);
            if (fwdEntry.host_names.length != fwdEntry3.host_names.length) {
                bl = true;
                continue;
            }
            for (int j = 0; j < fwdEntry.host_names.length; ++j) {
                if (fwdEntry.host_names[j].equals(fwdEntry3.host_names[j])) continue;
                bl = true;
            }
        }
        if (bl) {
            BoxPrint boxPrint = new BoxPrint();
            boxPrint.add("When specifying FWD workload skew, all requested host names for 'rd=%s' must be identical", this.rd_name);
            boxPrint.add("", new Object[0]);
            boxPrint.add("Workload skew control requires that all workloads run at the same time on all host.", new Object[0]);
            boxPrint.print();
            common.failure("FWD workload skew control not possible");
        }
    }

    public void willWeUseWaiterForWG() {
        int n = 0;
        if (ReplayInfo.isReplay()) {
            this.use_waiter = true;
            n = 1;
        } else if (this.wds_for_rd.size() == 0) {
            this.use_waiter = this.iorate_req != (double)MAX_RATE && this.iorate_req != (double)CURVE_RATE;
            n = 2;
        } else if (this.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            this.use_waiter = false;
            n = 3;
        } else {
            for (WD_entry wD_entry : this.wds_for_rd) {
                if (wD_entry.skew_original != 0.0 || wD_entry.wd_iorate != 0.0 || wD_entry.priority != Integer.MAX_VALUE) {
                    this.use_waiter = true;
                    n = 4;
                    break;
                }
                if (wD_entry.user_class_parms == null) continue;
                this.use_waiter = true;
                n = 5;
                break;
            }
            if (n == 0) {
                this.use_waiter = this.iorate_req != (double)MAX_RATE && this.iorate_req != (double)CURVE_RATE;
                n = 6;
            }
        }
        this.curve_used_waiter = !this.doing_curve_max ? false : this.use_waiter;
    }

    private void createFwgListForOneRd() {
        FwgEntry fwgEntry = null;
        this.fwgs_for_rd = new Vector(8, 0);
        for (FwdEntry fwdEntry : this.fwds_for_rd) {
            FsdEntry[] fsdEntryArray = fwdEntry.findFsdNames(this);
            Vector vector = Host.findSelectedHosts(fwdEntry.host_names);
            double d = fsdEntryArray.length;
            if (vector.size() > 1) {
                for (FsdEntry fsdEntry : fsdEntryArray) {
                    if (fsdEntry.shared) continue;
                    common.failure("Multiple hosts may only be requested for an FSD when 'shared=yes' is specified. rd=" + this.rd_name);
                }
            }
            for (String string : vector) {
                for (FsdEntry fsdEntry : fsdEntryArray) {
                    int n;
                    if (this.fwd_operations.length == 0) {
                        fwgEntry = new FwgEntry(fsdEntry, fwdEntry, this, string, fwdEntry.getOperation());
                        this.fwgs_for_rd.addElement(fwgEntry);
                        fwgEntry.working_set /= (long)vector.size();
                        if (fwgEntry.total_size != Long.MAX_VALUE) {
                            fwgEntry.total_size /= (long)vector.size();
                        }
                        n = fwdEntry.threads;
                        if (this.current_override != null && this.current_override.getThreads() != For_loop.NOVALUE) {
                            n = (int)this.current_override.getThreads();
                        }
                        fwgEntry.threads = Math.max(1, n / fsdEntryArray.length / vector.size());
                        if (common.get_debug(common.PLOG_WG_STUFF)) {
                            common.ptod("createFwgListForOneRd: " + this.rd_name + " " + string + " fwg.threads: " + fwgEntry.threads + " threads: " + n + " fsds.length: " + fsdEntryArray.length + " fwds_for_rd: " + this.fwds_for_rd.size());
                        }
                        if (fwgEntry.skew == 0.0) continue;
                        fwgEntry.skew /= d;
                        continue;
                    }
                    this.checkRdpctOperations(fwdEntry);
                    for (n = 0; n < this.fwd_operations.length; ++n) {
                        fwgEntry = new FwgEntry(fsdEntry, fwdEntry, this, string, Operations.getOperationIdentifier(this.fwd_operations[n]));
                        this.fwgs_for_rd.addElement(fwgEntry);
                        int n2 = fwdEntry.threads;
                        if (this.current_override.getThreads() != For_loop.NOVALUE) {
                            n2 = (int)this.current_override.getThreads();
                        }
                        fwgEntry.threads = Math.max(1, n2 / this.fwd_operations.length / fsdEntryArray.length / vector.size());
                        if (common.get_debug(common.PLOG_WG_STUFF)) {
                            common.ptod("createFwgListForOneRd: " + this.rd_name + " " + string + " fwg.threads: " + fwgEntry.threads + " threads: " + n2 + " fsds.length: " + fsdEntryArray.length + " fwds_for_rd: " + this.fwds_for_rd.size() + " operation: " + this.fwd_operations[n]);
                        }
                        if (fwgEntry.skew == 0.0) continue;
                        fwgEntry.skew /= d;
                    }
                }
            }
        }
        this.checkThreadCount();
    }

    private void checkThreadCount() {
        HashMap<FwdEntry, Integer> hashMap = new HashMap<FwdEntry, Integer>(32);
        for (int i = 0; i < this.fwgs_for_rd.size(); ++i) {
            FwgEntry fwgEntry = this.fwgs_for_rd.elementAt(i);
            Integer n = (Integer)hashMap.get(fwgEntry.fwd_used);
            if (n == null) {
                n = new Integer(0);
            }
            n = new Integer(n + fwgEntry.threads);
            hashMap.put(fwgEntry.fwd_used, n);
        }
        FwdEntry[] fwdEntryArray = hashMap.keySet().toArray(new FwdEntry[0]);
        for (int i = 0; i < fwdEntryArray.length; ++i) {
            int n = (Integer)hashMap.get(fwdEntryArray[i]);
            int n2 = fwdEntryArray[i].threads;
            if (this.current_override != null && this.current_override.getThreads() != For_loop.NOVALUE) {
                n2 = (int)this.current_override.getThreads();
            }
            if (n == n2 || fwdEntryArray[i].fwd_name.equals("default")) continue;
            common.ptod("");
            common.ptod("Note: fwd=%s,threads=%d,...", fwdEntryArray[i].fwd_name, n2);
            common.ptod("Note: rd=%s,fwd=%s,... ", this.rd_name, fwdEntryArray[i].fwd_name);
            common.ptod("Note: Mismatch between threads requested (%d) and used (%d)", n2, n);
            if (once++ != 0) continue;
            common.ptod("");
            common.ptod("Note: Requesting threads across multiple fsds, operations, slaves or hosts ");
            common.ptod("      may result in fractions of threads. ");
            common.ptod("      There will be a minimum of one thread for each fsd, operation, ");
            common.ptod("      slave or host, or integer truncation of the resulting thread count.");
            common.ptod("      Contact the author of Vdbench if there are unexplained differences.");
            common.ptod("");
            common.ptod("      Use general parameter 'fwd_thread_adjust=no' to cause Vdbench to abort instead. ");
            common.ptod("");
            if (fwd_thread_adjust) continue;
            common.failure("User requested 'fwd_thread_adjust=no'");
        }
    }

    private void checkRdpctOperations(FwdEntry fwdEntry) {
        if (fwdEntry.readpct >= 0.0) {
            for (int i = 0; i < this.fwd_operations.length; ++i) {
                int n = Operations.getOperationIdentifier(this.fwd_operations[i]);
                if (n == Operations.READ || n == Operations.WRITE) continue;
                common.failure("When using 'rdpct=' you may only request 'operation=read' or 'operation=write', and then only one of these.");
            }
            if (this.fwd_operations.length > 1) {
                common.failure("When using 'rdpct=' you may only request 'operation=read' or 'operation=write', and then only one of these.");
            }
        }
    }

    private void printFwgs() {
        for (int i = 0; i < this.fwgs_for_rd.size(); ++i) {
            FwgEntry fwgEntry = this.fwgs_for_rd.elementAt(i);
            common.ptod(fwgEntry);
        }
    }

    private void setFormatOperation(RD_entry rD_entry) {
        for (int i = 0; i < this.fwgs_for_rd.size(); ++i) {
            FwgEntry fwgEntry = this.fwgs_for_rd.elementAt(i);
            fwgEntry.xfersizes = FwdEntry.format_fwd.xfersizes;
            fwgEntry.threads = FwdEntry.format_fwd.threads;
            if (FwdEntry.format_fwd.open_flags != null) {
                fwgEntry.open_flags = FwdEntry.format_fwd.open_flags;
            }
            if (rD_entry.open_flags != null) {
                fwgEntry.open_flags = rD_entry.open_flags;
            }
            fwgEntry.select_random = false;
            fwgEntry.sequential_io = true;
            fwgEntry.anchor.trackXfersizes(fwgEntry.xfersizes);
            fwgEntry.anchor.trackFileSizes(fwgEntry.filesizes);
        }
        this.fwd_rate = MAX_RATE;
        if (!rD_entry.format.format_limited) {
            this.setNoElapsed();
        } else {
            this.setElapsed(rD_entry.getElapsed());
        }
        if (common.get_debug(common.USE_FORMAT_RATE)) {
            this.fwd_rate = rD_entry.fwd_rate;
        }
    }

    public String toString() {
        printf printf2 = new printf("rd=%-18s el=%4s in=%2d fr=%3s ");
        printf2.add(this.rd_name);
        printf2.add(this.getElapsed() == NO_ELAPSED ? "none" : Format.f("%3d", this.getElapsed()));
        printf2.add(this.getInterval());
        printf2.add(this.fwd_rate == (double)MAX_RATE ? "max" : Format.f("%3d", this.fwd_rate));
        if (this.current_override != null) {
            return Format.f("rd:%4d ", this.seqno) + " " + printf2.text + this.current_override.getText();
        }
        return Format.f("rd:%4d ", this.seqno) + " " + printf2.text;
    }

    private boolean insertFwdFormatIfNeeded(Vector vector) {
        boolean bl = false;
        if (bl) {
            common.ptod("format.format_requested: " + this.rd_name + " " + this.format.format_requested);
        }
        if (this.format.format_once_requested && this.format.one_format_done) {
            return false;
        }
        HashMap hashMap = this.createFormatList();
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        if (stringArray.length == 0) {
            if (bl) {
                common.where();
            }
            return false;
        }
        if (!this.format_inserted) {
            this.format_inserted = true;
            FwdEntry.format_fwd.fwd_name = "format";
            FwdEntry.getFwdList().add(FwdEntry.format_fwd);
        }
        RD_entry rD_entry = new RD_entry();
        rD_entry.format = this.format;
        rD_entry.rd_name = FSD_FORMAT_RUN + this.rd_name;
        rD_entry.fwd_names = null;
        rD_entry.fwd_operations = new String[0];
        rD_entry.fwd_rate = MAX_RATE;
        rD_entry.setInterval(this.getInterval());
        rD_entry.fwds_for_rd = new Vector(8);
        vector.addElement(rD_entry);
        this.format.one_format_done = true;
        for (int i = 0; i < stringArray.length; ++i) {
            common.plog(this.rd_name + " fsd to format: " + stringArray[i]);
            HashMap hashMap2 = (HashMap)hashMap.get(stringArray[i]);
            String[] stringArray2 = hashMap2.keySet().toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                common.plog(this.rd_name + " format on host: " + stringArray2[j]);
                FwdEntry fwdEntry = FwdEntry.format_fwd != null ? FwdEntry.format_fwd : FwdEntry.dflt;
                fwdEntry = (FwdEntry)fwdEntry.clone();
                fwdEntry.fwd_name = "format";
                fwdEntry.host_names = new String[]{stringArray2[j]};
                rD_entry.fwds_for_rd.add(fwdEntry);
                fwdEntry.fsd_names = new String[]{stringArray[i]};
            }
            rD_entry.createFwgListForOneRd();
            rD_entry.current_override = this.current_override;
            For_loop.forLoopOverrideFwd(rD_entry);
            rD_entry.setFormatOperation(this);
            rD_entry.start_cmd = this.start_cmd;
            rD_entry.end_cmd = this.end_cmd;
            if (!debug_rd_list) continue;
            common.ptod("format_rd: " + rD_entry);
            common.ptod("format_requested: " + this.format.format_requested);
            common.ptod("format_rd.format.format_requested: " + rD_entry.format.format_requested);
            common.ptod("");
            common.ptod(rD_entry.toString());
        }
        return true;
    }

    private HashMap createFormatList() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        for (FwgEntry fwgEntry : this.fwgs_for_rd) {
            Object object;
            if (fwgEntry.shared && this.format.format_requested && !this.format.format_clean && !this.format.format_restart) {
                object = new BoxPrint();
                ((BoxPrint)object).add("fsd=%s is requesting shared threads.", fwgEntry.fsd_name);
                ((BoxPrint)object).add("This requires you to split your format into two steps:", new Object[0]);
                ((BoxPrint)object).add("rd=step1,.....,format=(clean,only)   This removes the old file structure", new Object[0]);
                ((BoxPrint)object).add("rd=step2,.....,format=(restart,only) This recreates the new file structure", new Object[0]);
                ((BoxPrint)object).add("", new Object[0]);
                ((BoxPrint)object).add("This is necessary because otherwise hostA, still in the 'clean' phase of", new Object[0]);
                ((BoxPrint)object).add("the format, could delete files or directories that hostB has just created. ", new Object[0]);
                ((BoxPrint)object).add("", new Object[0]);
                ((BoxPrint)object).print();
                common.failure("'format=yes' not allowed for shared FSDs used in rd=%s", this.rd_name);
            }
            if ((object = (HashMap<String, String>)hashMap.get(fwgEntry.fsd_name)) == null) {
                object = new HashMap<String, String>(16);
                hashMap.put(fwgEntry.fsd_name, object);
                ((HashMap)object).put(fwgEntry.host_name, fwgEntry.host_name);
            }
            if (!fwgEntry.shared) continue;
            ((HashMap)object).put(fwgEntry.host_name, fwgEntry.host_name);
        }
        return hashMap;
    }

    public static boolean isThisFormatRun() {
        return RD_entry.next_rd.rd_name.startsWith(FSD_FORMAT_RUN);
    }

    public static Vector buildNewRdListForFwd() {
        RD_entry rD_entry;
        Vector<RD_entry> vector = new Vector<RD_entry>(16, 0);
        next_rd = null;
        while ((rD_entry = RD_entry.rd_next_workload(Vdbmain.rd_list)) != null) {
            RD_entry rD_entry2 = (RD_entry)rD_entry.clone();
            rD_entry2.format = rD_entry.format;
            rD_entry2.createFwgListForOneRd();
            For_loop.forLoopOverrideFwd(rD_entry2);
            if (rD_entry2.format.format_requested) {
                rD_entry2.insertFwdFormatIfNeeded(vector);
            }
            if (!rD_entry.format.format_only_requested) {
                vector.addElement(rD_entry2);
                if (rD_entry.fwd_rate == (double)CURVE_RATE) {
                    rD_entry2.insertCurveRuns(vector, true);
                }
                if (debug_rd_list) {
                    common.ptod(rD_entry2);
                }
            }
            for (int i = 0; i < rD_entry2.fwgs_for_rd.size(); ++i) {
                FwgEntry fwgEntry = rD_entry2.fwgs_for_rd.elementAt(i);
                fwgEntry.anchor.depth = fwgEntry.depth;
                fwgEntry.anchor.width = fwgEntry.width;
                fwgEntry.anchor.files = fwgEntry.files;
                fwgEntry.anchor.total_size = fwgEntry.total_size;
                fwgEntry.anchor.filesizes = fwgEntry.filesizes;
                fwgEntry.anchor.calculateStructureSize(fwgEntry, true);
            }
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (FileAnchor fileAnchor : FileAnchor.getAnchorList()) {
            l += (long)fileAnchor.total_directories;
            l2 += (long)fileAnchor.maximum_file_count;
            l3 += fileAnchor.bytes_in_file_list;
        }
        if (FileAnchor.getAnchorList().size() > 1) {
            common.ptod("Estimated totals for all %d anchors: dirs: %,d; files: %,d; bytes: %s ", FileAnchor.getAnchorList().size(), l, l2, common.whatSize(l3));
        }
        if (Validate.isRealValidate() || Validate.isValidateForDedup()) {
            Vector<FileAnchor> vector2 = FileAnchor.getAnchorList();
            for (int i = 0; i < vector2.size(); ++i) {
                FileAnchor fileAnchor = (FileAnchor)vector2.elementAt(i);
                fileAnchor.calculateKeyBlockSize();
            }
        }
        FileAnchor.reportCalculatedMemorySizes(vector);
        if (restart_rd != null) {
            RD_entry.keepRestart(vector);
        }
        return vector;
    }

    public static Vector buildNewRdListForWd() {
        RD_entry rD_entry;
        Vector<RD_entry> vector = new Vector<RD_entry>(16, 0);
        next_rd = null;
        while ((rD_entry = RD_entry.rd_next_workload(Vdbmain.rd_list)) != null) {
            RD_entry rD_entry2 = (RD_entry)rD_entry.clone();
            ConcatSds.checkForWdThreads(rD_entry);
            RD_entry.createWgListForOneRd(rD_entry2, false);
            For_loop.forLoopOverrideWd(rD_entry2);
            rD_entry2.format = rD_entry.format;
            vector.add(rD_entry2);
            if (rD_entry.iorate_req != (double)CURVE_RATE) continue;
            rD_entry2.insertCurveRuns(vector, false);
        }
        if (restart_rd != null) {
            RD_entry.keepRestart(vector);
        }
        return vector;
    }

    private static void keepRestart(Vector<RD_entry> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            RD_entry rD_entry = vector.get(i);
            if (rD_entry.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
                common.failure("Skipping rd=%s during restart is not allowed.", rD_entry.rd_name);
            } else if (rD_entry.rd_name.startsWith(FSD_FORMAT_RUN)) {
                common.failure("Skipping rd=%s during restart is not allowed.", rD_entry.rd_name);
            }
            if (rD_entry.rd_name.startsWith(restart_rd)) break;
            vector.set(i, null);
        }
        while (vector.remove(null)) {
        }
        if (vector.size() == 0) {
            common.failure("Restart rd=%s not found", restart_rd);
        }
    }

    public static void finalizeWgEntries() {
        RD_entry rD_entry = null;
        next_rd = null;
        for (SD_entry cloneable : Vdbmain.sd_list) {
            cloneable.csd_start_lba = -1L;
        }
        while ((rD_entry = RD_entry.getNextWorkload()) != null) {
            for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
                wG_entry.calculateContext(rD_entry, wG_entry.wd_used, wG_entry.sd_used);
                if (Validate.sdConcatenation()) {
                    ConcatSds.calculateLbaRanges(wG_entry);
                }
                if (wG_entry.user_class_parms == null) continue;
                ControlUsers.createInstance(wG_entry);
            }
        }
    }

    public void finalizeWgEntry() {
        for (SD_entry cloneable : Vdbmain.sd_list) {
            cloneable.csd_start_lba = -1L;
        }
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            wG_entry.calculateContext(this, wG_entry.wd_used, wG_entry.sd_used);
            if (Validate.sdConcatenation()) {
                ConcatSds.calculateLbaRanges(wG_entry);
            }
            if (wG_entry.user_class_parms == null) continue;
            ControlUsers.createInstance(wG_entry);
        }
    }

    public static void createWgListForOneRd(RD_entry rD_entry, boolean bl) {
        for (Host cloneable : Host.getDefinedHosts()) {
            for (Slave slave : cloneable.getSlaves()) {
                slave.clearWorkloads();
            }
        }
        if (!rD_entry.doing_curve_point) {
            rD_entry.rd_name = rD_entry.rd_name + (rD_entry.iorate_pct == 0.0 ? "" : Format.f("_(%d%%)", (int)rD_entry.iorate_pct));
        }
        rD_entry.set_iorate();
        for (WD_entry wD_entry : rD_entry.wds_for_rd) {
            rD_entry.prev_wd = null;
            wD_entry.starting_slave = 0;
            if (bl && Validate.sdConcatenation() && wD_entry.seekpct <= 0.0 && wD_entry.stream_count == 0) {
                common.ptod("rd=%s,wd=%s: 100%% sequential i/o while using SD concatenation without the streams= parameter may underestimate your performance", rD_entry.rd_name, wD_entry.wd_name);
            }
            if (rD_entry.rd_stream_count == 0) {
                rD_entry.rd_stream_count = wD_entry.stream_count;
            }
            for (Host host : wD_entry.getSelectedHosts()) {
                Vector vector = wD_entry.getSdsForHost(host);
                if (Validate.sdConcatenation()) {
                    vector.removeAllElements();
                    vector.add(rD_entry.concat_sd == null ? wD_entry.concat_sd : rD_entry.concat_sd);
                    for (SD_entry sD_entry : wD_entry.concat_sd.sds_in_concatenation) {
                        sD_entry.sd_is_referenced = true;
                    }
                }
                for (SD_entry sD_entry : vector) {
                    Slave slave;
                    sD_entry.sd_is_referenced = true;
                    WG_entry wG_entry = new WG_entry().initialize(rD_entry, sD_entry, wD_entry, host);
                    if (Validate.isRealValidate() && (slave = RD_entry.findWorkForSd(sD_entry)) != null) {
                        rD_entry.giveWorkloadToSlave(wG_entry, slave);
                        RD_entry.printWgInfo("Data Validation Work for wd=%s,sd=%s given to slave=%s", wD_entry.wd_name, sD_entry.sd_name, slave.getLabel());
                        continue;
                    }
                    if (WhereWhatWork.mustRunOnSingleSlave(wD_entry, wG_entry) && RD_entry.findWorkForWdSdCombo(wD_entry, sD_entry) != null) {
                        RD_entry.printWgInfo("Work not given to host=%s due to mustRunOnSingleSlave: wd=%s,sd=%s", host.getLabel(), wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name);
                        continue;
                    }
                    rD_entry.giveWorkloadToSlaves(wG_entry, host, bl);
                }
            }
        }
        RD_entry.printWgInfo("", new Object[0]);
        rD_entry.checkWdUsed();
        if (rD_entry.areWeSharingThreads()) {
            rD_entry.spreadSharedThreadsAcrossSlaves(bl);
        } else {
            rD_entry.spreadSdThreadsAcrossSlaves(bl);
        }
        rD_entry.wgs_for_rd = RD_entry.getAllWorkloads();
        HandleSkew.spreadWdSkew(rD_entry);
        HandleSkew.spreadWgSkew(rD_entry);
        HandleSkew.calcLeftoverWgSkew(rD_entry);
        if (!(bl || Host.anyJvmOverrides() || ReplayInfo.isReplay())) {
            WG_entry.adjustJvmCount(rD_entry);
        }
    }

    private void giveWorkloadToSlaves(WG_entry wG_entry, Host host, boolean bl) {
        this.willWeUseWaiterForWG();
        if (Validate.isValidate() && wG_entry.sd_used.slave_used_for_dv != null) {
            Slave slave = wG_entry.sd_used.slave_used_for_dv;
            this.giveWorkloadToSlave(wG_entry, slave);
            RD_entry.printWgInfo("giveWorkloadToSlaves2 added wd=%s,sd=%s to slave=%s", wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, slave.getLabel());
        } else if (WhereWhatWork.mustRunOnSingleSlave(wG_entry.wd_used, wG_entry)) {
            Slave slave = null;
            if (this.use_waiter) {
                slave = host.getSlaveUsingSd(wG_entry.sd_used);
            }
            if (slave == null) {
                slave = host.getLeastBusySlave();
            }
            this.giveWorkloadToSlave(wG_entry, slave);
            RD_entry.printWgInfo("giveWorkloadToSlaves3 added wd=%s,sd=%s to slave=%s", wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, slave.getLabel());
        } else if (this.anySkewRequested()) {
            int n = this.getThreadsFromSdOrRd(wG_entry.sd_used);
            this.sendSkewedWorkloadToSlaves(wG_entry, host, n, bl);
        } else {
            for (Slave slave : host.getSlaves()) {
                WG_entry wG_entry2 = (WG_entry)wG_entry.clone();
                this.giveWorkloadToSlave(wG_entry2, slave);
                RD_entry.printWgInfo("giveWorkloadToSlaves4 added wd=%s,sd=%s to slave=%s", wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, slave.getLabel());
            }
        }
    }

    private void giveWorkloadToSlave(WG_entry wG_entry, Slave slave) {
        wG_entry.setSlave(slave);
        wG_entry.wg_name = slave.getLabel() + " " + wG_entry.wg_name;
        slave.addWorkload(wG_entry, this);
    }

    private void sendSkewedWorkloadToSlaves(WG_entry wG_entry, Host host, int n, boolean bl) {
        Vector<Slave> vector = host.getSlaves();
        WD_entry wD_entry = wG_entry.wd_used;
        if (wD_entry == this.prev_wd) {
            for (int i = 0; i < n && i < vector.size(); ++i) {
                Slave slave = vector.get((wD_entry.starting_slave + wD_entry.sds_added + i) % vector.size());
                this.giveWorkloadToSlave((WG_entry)wG_entry.clone(), slave);
            }
            ++wD_entry.sds_added;
        } else {
            if (this.prev_wd == null) {
                wD_entry.starting_slave = 0;
                wD_entry.sds_added = 0;
            } else {
                wD_entry.starting_slave = this.prev_wd.starting_slave + 1;
                wD_entry.sds_added = 0;
            }
            for (int i = 0; i < n && i < vector.size(); ++i) {
                Slave slave = vector.get((wD_entry.starting_slave + wD_entry.sds_added + i) % vector.size());
                this.giveWorkloadToSlave((WG_entry)wG_entry.clone(), slave);
            }
            ++wD_entry.sds_added;
            this.prev_wd = wD_entry;
        }
        this.reportSpread(true, "%-5b After sendSkewedWorkloadToSlaves()", bl);
    }

    private void testPrint() {
        common.ptod("");
        for (Host host : Host.getDefinedHosts()) {
            SD_entry[] sD_entryArray;
            for (SD_entry sD_entry : sD_entryArray = host.getSds()) {
                for (WG_entry wG_entry : host.getWgsForSd(sD_entry)) {
                    common.ptod("testPrint: rd: %s host: %s sd: %s wg: %s", this.rd_name, host.getLabel(), sD_entry.sd_name, wG_entry.wg_name);
                }
            }
        }
        common.ptod("");
    }

    /*
     * WARNING - void declaration
     */
    private void spreadSdThreadsAcrossSlaves(boolean bl) {
        void var8_22;
        int n;
        int n2 = SlaveList.getSlaveList().size();
        boolean bl2 = common.get_debug(common.DEBUG_SPREAD) && bl;
        int n3 = 0;
        if (bl2) {
            common.ptod("spreadSdThreadsAcrossSlaves: spreadThreads for rd=" + this.rd_name);
        }
        this.threads_per_slave_map = new HashMap(32);
        for (Host object2 : Host.getDefinedHosts()) {
            for (Slave slave : object2.getSlaves()) {
                slave.threads_given_to_slave = 0;
            }
        }
        HashMap hashMap = new HashMap(16);
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            hashMap.put(wG_entry.sd_used, wG_entry.sd_used);
        }
        if (!bl && Validate.sdConcatenation()) {
            String string = String.format("wd=%%-%ds ", WD_entry.max_wd_name);
            BoxPrint boxPrint = new BoxPrint();
            for (SD_entry sD_entry : hashMap.values().toArray(new SD_entry[0])) {
                n = sD_entry.threads;
                if (sD_entry.threads % n2 == 0) continue;
                int n4 = n + n2 - n % n2;
                String string2 = String.format("Workload thread count for " + string + "increased from %2d to %2d to make it a " + "multiple of the number of slaves (%d).", sD_entry.concat_wd_name, n, n4, n2);
                boxPrint.add(string2, new Object[0]);
                sD_entry.threads = n4;
            }
            if (boxPrint.size() > 0) {
                boxPrint.sort();
                boxPrint.print();
            }
        }
        int n5 = -1;
        ArrayList<WG_entry> arrayList = RD_entry.getAllWorkloads();
        for (SD_entry sD_entry : this.getSdsForRD()) {
            sD_entry.setActive();
            ArrayList<Host> arrayList2 = this.getHostsForSd(sD_entry, arrayList);
            if (arrayList2.size() == 0) continue;
            int n6 = this.getThreadsFromSdOrRd(sD_entry);
            n = this.rd_stream_count;
            if (bl && n > 0) {
                if (bl2) {
                    common.ptod("spreadSdThreadsAcrossSlaves: threads_requested: " + n6);
                }
                if (bl2) {
                    common.ptod("spreadSdThreadsAcrossSlaves: slave_count:       " + n2);
                }
                if (bl2) {
                    common.ptod("spreadSdThreadsAcrossSlaves: stream_count:      " + n);
                }
                if (n6 % n != 0) {
                    common.failure("'threads=%d' must be a multiple of the amount of streams=%d", n6, n);
                }
            }
            int[] nArray = new int[arrayList2.size()];
            int n7 = 0;
            while (n7 < n6) {
                int n8;
                Host host;
                if (!this.isSdUsedOnHost(host = arrayList2.get(n8 = n3++ % arrayList2.size()), arrayList, sD_entry)) continue;
                if (n == 0) {
                    int n9 = n8;
                    nArray[n9] = nArray[n9] + 1;
                    ++n7;
                    continue;
                }
                int n10 = n6 / n;
                if (n10 == 0) {
                    common.ptod("threads_requested: " + n6);
                    common.ptod("stream_count: " + n);
                    common.failure("threads_per_stream may not be zero");
                }
                int n11 = n8;
                nArray[n11] = nArray[n11] + n10;
                n7 += n10;
            }
            long l = 0L;
            for (int i = 0; i < arrayList2.size(); ++i) {
                Slave slave;
                Host host = arrayList2.get(i);
                Vector<Slave> vector = host.getSlaves();
                int[] nArray2 = new int[vector.size()];
                int n12 = 0;
                while (n12 < nArray[i]) {
                    Slave slave2;
                    slave = host.getLeastBusyThreads(sD_entry);
                    int n13 = 0;
                    for (n13 = 0; n13 < vector.size() && (slave2 = vector.get(n13)) != slave; ++n13) {
                    }
                    if (l++ > 100000L) {
                        common.ptod("host_thread_count: " + n12);
                        common.ptod("threads_for_host[host_index]: " + nArray[i]);
                        common.failure("loop protection slave=%s,sd=%s", slave.getLabel(), sD_entry.sd_name);
                    }
                    if (!this.isSdUsedOnSlave(slave, arrayList, sD_entry)) continue;
                    if (n == 0) {
                        int n14 = n13;
                        nArray2[n14] = nArray2[n14] + 1;
                        ++n12;
                        ++slave.threads_given_to_slave;
                        continue;
                    }
                    int n15 = n6 / n;
                    if (n15 == 0) {
                        common.failure("threads_per_stream may not be zero");
                    }
                    int n16 = n13;
                    nArray2[n16] = nArray2[n16] + n15;
                    n12 += n15;
                    slave.threads_given_to_slave += n15;
                }
                for (n12 = 0; n12 < vector.size(); ++n12) {
                    this.setThreadsUsedForSlave(sD_entry.sd_name, vector.get(n12), nArray2[n12]);
                }
                for (n12 = 0; n12 < vector.size(); ++n12) {
                    if (!bl || this.getSdThreadsUsedForSlave(sD_entry.sd_name, slave = vector.elementAt(n12)) <= 0 || !bl2) continue;
                    common.ptod("---spreadSdThreadsAcrossSlaves: slave=%s gets %d threads for sd=%s", slave.getLabel(), this.getSdThreadsUsedForSlave(sD_entry.sd_name, slave), sD_entry.sd_name);
                }
            }
        }
        HandleSkew.spreadWgSkew(this);
        this.reportSpread(bl, "Before zero threads check", new Object[0]);
        this.reportSpread(true, "last=%b Before zero threads check", bl);
        boolean bl3 = false;
        while (var8_22 < arrayList.size()) {
            block37: {
                WG_entry wG_entry = arrayList.get((int)var8_22);
                if (this.getSdThreadsUsedForSlave(wG_entry.sd_used.sd_name, wG_entry.getSlave()) == 0) {
                    int n17;
                    for (Slave slave : wG_entry.getSlave().getHost().getSlaves()) {
                        if (slave == wG_entry.getSlave()) continue;
                        ArrayList<WG_entry> arrayList3 = slave.getWorkloads();
                        for (int i = 0; i < arrayList3.size(); ++i) {
                            WG_entry wG_entry2 = arrayList3.get(i);
                            if (!wG_entry2.sd_used.sd_name.equals(wG_entry.sd_used.sd_name) || this.getSdThreadsUsedForSlave(wG_entry.sd_used.sd_name, slave) == 0) continue;
                            if (wG_entry.getSlave().removeWorkload(wG_entry, this) == 0) {
                                common.failure("Unable to remove wd=%s from slave=%s", wG_entry.wd_used.wd_name, wG_entry.getSlave().getLabel());
                            }
                            for (WG_entry wG_entry3 : slave.getWorkloads()) {
                                if (!wG_entry3.wd_used.wd_name.equals(wG_entry.wd_used.wd_name) || !wG_entry3.sd_used.sd_name.equals(wG_entry.sd_used.sd_name)) continue;
                                if (bl2) {
                                    common.ptod("No threads available, removed wd=%s,sd=%s from slave %s", wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, wG_entry.getSlave().getLabel());
                                }
                                break block37;
                            }
                            wG_entry.setSlave(slave);
                            slave.addWorkload(wG_entry, this);
                            HandleSkew.spreadWgSkew(this);
                            this.reportSpread(bl, "Added workload to different slave wd=%s,sd=%s from slave %s to slave %s", wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, wG_entry.getSlave().getLabel(), slave.getLabel());
                            break block37;
                        }
                    }
                    if (bl) {
                        common.plog("spreadSdThreadsAcrossSlaves: Workload removed, not enough threads for slave=%s,wd=%s,sd=%s", wG_entry.getSlave().getLabel(), wG_entry.wd_name, wG_entry.sd_used.sd_name);
                    }
                    if ((n17 = wG_entry.getSlave().removeWorkload(wG_entry, this)) == 0) {
                        common.failure("Unable to remove wd=%s from host=%s", wG_entry.wd_used.wd_name, wG_entry.getSlave().getLabel());
                    }
                }
            }
            ++var8_22;
        }
        HandleSkew.spreadWgSkew(this);
        this.reportSpread(bl, "Final", new Object[0]);
        if (common.get_debug(common.PRINT_SPREAD)) {
            ArrayList<WG_entry> arrayList4 = Host.getAllWorkloads();
            HandleSkew.spreadWgSkew(this);
            common.ptod("Workloads, sorted by slave: ");
            WG_entry.sortWorkloads(arrayList4, "slave");
            for (WG_entry wG_entry : arrayList4) {
                common.ptod(wG_entry.report(this));
            }
            common.ptod("Workloads, sorted by sd: ");
            WG_entry.sortWorkloads(arrayList4, "sd");
            for (WG_entry wG_entry : arrayList4) {
                common.ptod(wG_entry.report(this));
            }
            common.ptod("Workloads, sorted by wd: ");
            WG_entry.sortWorkloads(arrayList4, "wd");
            for (WG_entry wG_entry : arrayList4) {
                common.ptod(wG_entry.report(this));
            }
            this.printThreadsUsedBySlaves();
        }
    }

    private void giveThreadsToSlaves(Host host, SD_entry sD_entry, int n) {
        int n2 = this.getThreadsFromSdOrRd(sD_entry);
        int n3 = 0;
        int n4 = this.rd_stream_count;
        Vector<Slave> vector = host.getSlaves();
        int[] nArray = new int[vector.size()];
        ArrayList<WG_entry> arrayList = RD_entry.getAllWorkloads();
        int n5 = 0;
        while (n5 < n) {
            Slave slave;
            Slave slave2 = host.getLeastBusyThreads(sD_entry);
            int n6 = 0;
            for (n6 = 0; n6 < vector.size() && (slave = vector.get(n6)) != slave2; ++n6) {
            }
            if (n3++ > 100000) {
                common.ptod("host_thread_count: " + n5);
                common.ptod("threads_for_host: " + n);
                common.failure("loop protection slave=%s,sd=%s", slave2.getLabel(), sD_entry.sd_name);
            }
            if (!this.isSdUsedOnSlave(slave2, arrayList, sD_entry)) continue;
            if (n4 == 0) {
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                ++n5;
                ++slave2.threads_given_to_slave;
                continue;
            }
            int n8 = n2 / n4;
            if (n8 == 0) {
                common.failure("threads_per_stream may not be zero");
            }
            int n9 = n6;
            nArray[n9] = nArray[n9] + n8;
            n5 += n8;
            slave2.threads_given_to_slave += n8;
        }
        for (n5 = 0; n5 < vector.size(); ++n5) {
            this.setThreadsUsedForSlave(sD_entry.sd_name, vector.get(n5), nArray[n5]);
        }
    }

    private void reportSpread(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            return;
        }
        if (!common.get_debug(common.PRINT_SPREAD)) {
            return;
        }
        common.ptod("");
        common.ptod("reportSpread: state=" + String.format(string, objectArray));
        for (WG_entry wG_entry : Host.getAllWorkloads()) {
            common.ptod(wG_entry.report(this));
        }
    }

    private void spreadSharedThreadsAcrossSlaves(boolean bl) {
        boolean bl2 = common.get_debug(common.DEBUG_SPREAD) && bl;
        boolean bl3 = false;
        if (bl2) {
            common.ptod("spreadSdThreadsAcrossSlaves: spreadThreads for rd=" + this.rd_name);
        }
        this.threads_per_slave_map = new HashMap(32);
        int n = SlaveList.getSlaveList().size();
        int n2 = (int)this.current_override.getThreads();
        if (bl) {
            BoxPrint boxPrint = new BoxPrint();
            n2 = this.adjustThreadCount(n2, boxPrint);
            if (boxPrint.size() > 0) {
                boxPrint.print();
            }
        }
        int n3 = n2 / n;
        for (SD_entry cloneable : this.getSdsForRD()) {
            cloneable.setActive();
            for (Slave slave : SlaveList.getSlaveList()) {
                this.setThreadsUsedForSlave(cloneable.sd_name, slave, n3);
            }
        }
        for (Host host : Host.getDefinedHosts()) {
            int n4 = 0;
            for (Slave slave : host.getSlaves()) {
                int n5 = this.getThreadsUsedForSlave(slave);
                n4 += n5;
                if (!bl2) continue;
                common.ptod("Threads for rd=" + this.rd_name + " " + slave.getLabel() + ": " + n5);
            }
            if (!bl2) continue;
            common.ptod("Total threads for rd=" + this.rd_name + ": " + n4);
        }
    }

    public void spreadStreamsAcrossSlaves(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = common.get_debug(common.DEBUG_SPREAD) && bl;
        if (this.rd_stream_count == 0) {
            return;
        }
        int n = -1;
        ArrayList<Slave> arrayList = new ArrayList<Slave>(32);
        boolean bl4 = false;
        do {
            bl4 = false;
            ++n;
            for (Host object : Host.getDefinedHosts()) {
                int n2 = -1;
                for (Slave n5 : object.getSlaves()) {
                    if (n5.getWorkloads().size() == 0 || ++n2 != n) continue;
                    arrayList.add(n5);
                    bl4 = true;
                    if (!bl2) continue;
                    common.ptod("spreadStreamsAcrossSlaves, added " + n5.getLabel());
                }
            }
        } while (bl4);
        int n3 = this.rd_stream_count;
        for (SD_entry sD_entry : this.getSdsForRD()) {
            sD_entry.setActive();
            int n4 = this.getThreadsUsedForSD(sD_entry.sd_name);
            int n5 = n4 / n3;
            if (n5 == 0) {
                common.ptod("sd.sd_name:         " + sD_entry.sd_name);
                common.ptod("sd_threads:         " + n4);
                common.ptod("stream_count:       " + n3);
                common.ptod("threads_per_stream: " + n5);
                common.failure("rd=%s Not enough threads per stream: threads: %d, streams: %d, threads/streams: %d ", this.rd_name, n4, n3, n4 / n3);
            }
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3) {
                if (n7++ > 100000) {
                    common.ptod("current_stream:     " + n6);
                    common.ptod("stream_count:       " + n3);
                    common.ptod("threads_per_stream: " + n5);
                    common.ptod("round_list:         " + arrayList.size());
                    common.failure("loop protection");
                }
                block5: for (Slave slave : arrayList) {
                    ArrayList<StreamContext> arrayList2 = this.getStreamListForSD(sD_entry.sd_name, slave);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (arrayList2.get(i) != null) continue;
                        StreamContext streamContext = new StreamContext(sD_entry, n3, n6);
                        RD_entry.printWgInfo("Stream: slave: %s threads: %2d %s", slave.getLabel(), n5, streamContext);
                        for (int j = 0; j < n5; ++j) {
                            if (i + j >= arrayList2.size()) {
                                common.ptod("i/t: " + i + " " + j);
                                common.failure("Improper thread count: %d/%d", arrayList2.size(), n5);
                            }
                            arrayList2.set(i + j, streamContext);
                        }
                        ++n6;
                        continue block5;
                    }
                }
            }
        }
    }

    private boolean isSdUsedOnHost(Host host, ArrayList<WG_entry> arrayList, SD_entry sD_entry) {
        for (WG_entry wG_entry : arrayList) {
            if (wG_entry.getSlave().getHost() != host || wG_entry.sd_used != sD_entry) continue;
            return true;
        }
        return false;
    }

    private boolean isSdUsedOnSlave(Slave slave, ArrayList<WG_entry> arrayList, SD_entry sD_entry) {
        for (WG_entry wG_entry : arrayList) {
            if (wG_entry.getSlave() != slave || wG_entry.sd_used != sD_entry) continue;
            return true;
        }
        return false;
    }

    private void checkWdUsed() {
        for (WD_entry wD_entry : this.wds_for_rd) {
            int n = 0;
            for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
                if (wG_entry.wd_used != wD_entry) continue;
                ++n;
            }
            if (n != 0) continue;
            common.failure("rd=" + this.rd_name + ",wd=" + wD_entry.wd_name + " not used. Could it be that more hosts " + "have been requested than there are threads?");
        }
    }

    private ArrayList<Host> getHostsForSd(SD_entry sD_entry, ArrayList<WG_entry> arrayList) {
        HashMap hashMap = new HashMap(8);
        for (WG_entry wG_entry : arrayList) {
            if (wG_entry.sd_used != sD_entry) continue;
            hashMap.put(wG_entry.getSlave().getHost(), null);
        }
        ArrayList arrayList2 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList2);
        return arrayList2;
    }

    private Vector obsolete_countSlavesForSd(Host host, SD_entry sD_entry) {
        HashMap hashMap = new HashMap(8);
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            if (wG_entry.sd_used != sD_entry || wG_entry.getSlave().getHost() != host) continue;
            hashMap.put(wG_entry.getSlave(), null);
        }
        return new Vector(hashMap.keySet());
    }

    private boolean thisWdAlreadyUsed(WG_entry wG_entry) {
        block11: {
            block10: {
                if (Validate.isValidate() || wG_entry.seekpct <= 0.0 || Validate.removeAfterError()) break block10;
                ReplayInfo.getInfo();
                if (!ReplayInfo.isReplay()) break block11;
            }
            for (Slave slave : SlaveList.getSlaveList()) {
                for (WG_entry wG_entry2 : slave.getWorkloads()) {
                    if (wG_entry2.wd_used != wG_entry.wd_used || wG_entry2.sd_used != wG_entry.sd_used) continue;
                    if (!wG_entry2.wd_used.one_slave_warning_given) {
                        if (Validate.removeAfterError()) {
                            common.ptod("'data_errors=remove_device' requested for sd=" + wG_entry.sd_used.sd_name + ". It will run on only one slave.");
                        } else if (!Validate.isValidate()) {
                            common.plog("Sequential workload for wd=" + wG_entry.wd_used.wd_name + " may run on only ONE slave. " + "It will run on slave=" + slave.getLabel());
                        } else {
                            common.plog("Data Validation: Workload for wd=" + wG_entry.wd_used.wd_name + " may run on only ONE slave. " + "It will run on slave=" + slave.getLabel());
                        }
                    }
                    wG_entry2.wd_used.one_slave_warning_given = true;
                    return true;
                }
            }
        }
        return false;
    }

    private void insertCurveRuns(Vector vector, boolean bl) {
        double[] dArray = new double[]{10.0, 50.0, 70.0, 80.0, 90.0, 100.0};
        if (this.curve_points != null) {
            dArray = this.curve_points;
        }
        for (int i = 0; i < dArray.length; ++i) {
            RD_entry rD_entry = (RD_entry)this.clone();
            rD_entry.doing_curve_max = false;
            rD_entry.doing_curve_point = true;
            rD_entry.iorate_req = rD_entry.iorate = dArray[i] * -1.0;
            rD_entry.rd_name = rD_entry.rd_name + Format.f("_(%d%%)", (int)rD_entry.iorate * -1);
            vector.add(rD_entry);
            if (Vdbmain.isWdWorkload()) {
                RD_entry.createWgListForOneRd(rD_entry, bl);
                continue;
            }
            rD_entry.createFwgListForOneRd();
        }
    }

    private static void selectWhichWdsToUse(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Cloneable cloneable;
            RD_entry rD_entry = (RD_entry)vector.elementAt(i);
            if (rD_entry.sd_names != null && rD_entry.wd_names.length == 0) {
                rD_entry.wds_for_rd.removeAllElements();
                cloneable = (WD_entry)WD_entry.dflt.clone();
                ((WD_entry)cloneable).wd_name = "rd=" + rD_entry.rd_name;
                Vdbmain.wd_list.add((WD_entry)cloneable);
                rD_entry.wds_for_rd.add((WD_entry)cloneable);
                common.plog("No Workload Definitions defined for rd=" + rD_entry.rd_name + "; using the latest wd=default instead.");
            } else {
                rD_entry.getWdsForRd();
            }
            if (rD_entry.sd_names == null) continue;
            cloneable = new Vector(4, 0);
            for (int j = 0; j < rD_entry.wds_for_rd.size(); ++j) {
                WD_entry wD_entry = (WD_entry)rD_entry.wds_for_rd.elementAt(j).clone();
                ((Vector)cloneable).add(wD_entry);
                wD_entry.sd_names = rD_entry.sd_names;
                wD_entry.concat_sd = rD_entry.concat_sd;
            }
            rD_entry.wds_for_rd = cloneable;
        }
    }

    private static void selectWhichFwdsToUse(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            RD_entry rD_entry = (RD_entry)vector.elementAt(i);
            if (rD_entry.fwd_names.length + rD_entry.fsd_names.length == 0) {
                common.failure("No 'fwd=' or 'fsd=' specified for rd=" + rD_entry.rd_name);
            }
            if (rD_entry.fsd_names.length == 0) {
                rD_entry.getFwdsForRd();
                continue;
            }
            if (rD_entry.fwd_names.length == 0) {
                rD_entry.fwds_for_rd.removeAllElements();
                rD_entry.fwds_for_rd.add(FwdEntry.dflt);
                common.ptod("No Filesystem Workload Definitions defined for rd=" + rD_entry.rd_name + "; using fwd=default instead");
            } else {
                rD_entry.getFwdsForRd();
            }
            if (rD_entry.fsd_names.length == 0) continue;
            Vector<FwdEntry> vector2 = new Vector<FwdEntry>(4, 0);
            HashMap<String, String> hashMap = new HashMap<String, String>(8);
            for (int j = 0; j < rD_entry.fwds_for_rd.size(); ++j) {
                FwdEntry fwdEntry = (FwdEntry)rD_entry.fwds_for_rd.elementAt(j).clone();
                vector2.add(fwdEntry);
                hashMap.put(fwdEntry.fwd_name, fwdEntry.fwd_name);
                if (rD_entry.fsd_names.length == 0) {
                    common.failure("No fsd names specified in rd=" + rD_entry.rd_name);
                }
                fwdEntry.fsd_names = rD_entry.fsd_names;
            }
            rD_entry.fwds_for_rd = vector2;
            rD_entry.fwd_names = hashMap.values().toArray(new String[0]);
        }
    }

    public int getSdThreadsUsedForSlave(String string, Slave slave) {
        if (this.threads_per_slave_map == null) {
            return -1;
        }
        String string2 = string + "/" + slave.getLabel();
        ArrayList<StreamContext> arrayList = this.threads_per_slave_map.get(string2);
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public ArrayList<StreamContext> getStreamListForSD(String string, Slave slave) {
        String string2 = string + "/" + slave.getLabel();
        ArrayList<StreamContext> arrayList = this.threads_per_slave_map.get(string2);
        if (arrayList == null) {
            common.failure("Thread count requested for unknown: '%s'", string2);
        }
        return arrayList;
    }

    public int getThreadsUsedForSlave(Slave slave) {
        String[] stringArray = this.threads_per_slave_map.keySet().toArray(new String[0]);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("/" + slave.getLabel())) continue;
            ArrayList<StreamContext> arrayList = this.threads_per_slave_map.get(stringArray[i]);
            n += arrayList.size();
        }
        return n;
    }

    public void printThreadsUsedBySlaves() {
        Object[] objectArray = this.threads_per_slave_map.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ArrayList<StreamContext> arrayList = this.threads_per_slave_map.get(objectArray[i]);
            if (arrayList.size() <= 0) continue;
            common.ptod("printThreadsUsedBySlaves: %12s %2d", objectArray[i], arrayList.size());
        }
    }

    public int getThreadsUsedForSD(String string) {
        String[] stringArray = this.threads_per_slave_map.keySet().toArray(new String[0]);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string + "/")) continue;
            n += this.threads_per_slave_map.get(stringArray[i]).size();
        }
        if (n == 0) {
            common.failure("getThreadsUsedForSD: sd=%s not found", string);
        }
        return n;
    }

    public void setThreadsUsedForSlave(String string, Slave slave, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        String string2 = string + "/" + slave.getLabel();
        this.threads_per_slave_map.put(string2, arrayList);
    }

    public HashMap<String, ArrayList<StreamContext>> getThreadsPerSlaveMap() {
        return this.threads_per_slave_map;
    }

    public int getThreadsFromSdOrRd(SD_entry sD_entry) {
        if (this.current_override.getThreads() == For_loop.NOVALUE) {
            return sD_entry.threads;
        }
        return (int)this.current_override.getThreads();
    }

    public long getWarmup() {
        return this.warmup;
    }

    public void setWarmup(long l) {
        this.warmup = l;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long l) {
        this.elapsed = l;
    }

    public void setNoElapsed() {
        this.elapsed = NO_ELAPSED;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public static boolean getOrPutUsed() {
        for (FwgEntry fwgEntry : RD_entry.next_rd.fwgs_for_rd) {
            if (fwgEntry.getOperation() != Operations.GET && fwgEntry.getOperation() != Operations.PUT) continue;
            return true;
        }
        return false;
    }

    public boolean checkForSequentialWritesOnly() {
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            if (wG_entry.seekpct >= 0.0) {
                return false;
            }
            if (wG_entry.readpct == 0.0) continue;
            return false;
        }
        return true;
    }

    private static Vector<RD_entry> repeatSdSingles() {
        Vector<SD_entry> vector = Vdbmain.sd_list;
        Vector<RD_entry> vector2 = Vdbmain.rd_list;
        Vector<RD_entry> vector3 = new Vector<RD_entry>(vector2.size());
        Vector<SD_entry> vector4 = new Vector<SD_entry>(vector.size());
        for (SD_entry sD_entry : vector) {
            vector4.add(sD_entry);
        }
        Random random = new Random(0L);
        for (int i = 0; i < vector4.size() * 8; ++i) {
            int n;
            int n2 = random.nextInt(vector4.size());
            if (n2 == (n = random.nextInt(vector4.size()))) continue;
            SD_entry sD_entry = (SD_entry)vector4.get(n2);
            vector4.set(n2, (SD_entry)vector4.get(n));
            vector4.set(n, sD_entry);
        }
        for (RD_entry rD_entry : vector2) {
            Cloneable cloneable;
            Cloneable cloneable2;
            if (rD_entry.sd_names == null || rD_entry.sd_names.length != 1) {
                vector3.add(rD_entry);
                continue;
            }
            String string = rD_entry.sd_names[0];
            if (string.equals("single")) {
                string = "setsof1";
            }
            if (!string.equals("range") && !string.startsWith("setsof")) {
                vector3.add(rD_entry);
                continue;
            }
            if (string.startsWith("setsof") || common.isNumeric((string + "           ").substring(6))) {
                String string2 = (string + " ").substring(6);
                int n = Integer.parseInt(string2.trim());
                cloneable2 = n == 1 ? vector : vector4;
                for (int i = 0; i < ((Vector)cloneable2).size(); ++i) {
                    SD_entry sD_entry = ((Vector)cloneable2).get(i);
                    cloneable = (RD_entry)rD_entry.clone();
                    String string3 = rD_entry.rd_name;
                    ArrayList<String> arrayList = new ArrayList<String>(8);
                    for (int j = 0; j < n && i < ((Vector)cloneable2).size(); ++i, ++j) {
                        arrayList.add(((SD_entry)((Vector)cloneable2).get((int)i)).sd_name);
                        string3 = string3 + "_" + ((SD_entry)((Vector)cloneable2).get((int)i)).sd_name;
                    }
                    cloneable.sd_names = arrayList.toArray(new String[0]);
                    cloneable.rd_name = string3;
                    vector3.add((RD_entry)cloneable);
                    --i;
                }
                continue;
            }
            if (string.equals("range")) {
                for (int i = 0; i < vector.size(); ++i) {
                    SD_entry sD_entry = vector.get(0);
                    cloneable2 = vector.get(i);
                    RD_entry rD_entry2 = (RD_entry)rD_entry.clone();
                    rD_entry2.sd_names = new String[i + 1];
                    rD_entry2.rd_name = rD_entry2.rd_name + "_" + sD_entry.sd_name + "-" + ((SD_entry)cloneable2).sd_name;
                    for (int j = 0; j < i + 1; ++j) {
                        cloneable = vector.get(j);
                        rD_entry2.sd_names[j] = ((SD_entry)cloneable).sd_name;
                    }
                    vector3.add(rD_entry2);
                }
                continue;
            }
            vector3.add(rD_entry);
        }
        return vector3;
    }

    private void useDistribution(Vdb_scan vdb_scan) {
        for (int i = 0; i < vdb_scan.getAlphaCount(); ++i) {
            String string = vdb_scan.alphas[i].toLowerCase();
            if ("exponential".startsWith(string)) {
                this.distribution = 0;
                continue;
            }
            if ("uniform".startsWith(string)) {
                this.distribution = 1;
                continue;
            }
            if ("deterministic".startsWith(string)) {
                this.distribution = 2;
                continue;
            }
            if ("variable".startsWith(string)) {
                this.variable = true;
                continue;
            }
            if ("spike".startsWith(string)) {
                this.variable = true;
                this.spread = false;
                continue;
            }
            common.failure("Unknown keyword value: " + vdb_scan.alphas[0]);
        }
    }

    private ArrayList<SD_entry> getSdsForRD() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(64);
        for (WG_entry cloneable2 : RD_entry.getAllWorkloads()) {
            hashMap.put(cloneable2.sd_used.sd_name, cloneable2.sd_used);
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        ArrayList<SD_entry> arrayList = new ArrayList<SD_entry>(32);
        for (Object object : objectArray) {
            arrayList.add((SD_entry)hashMap.get(object));
        }
        return arrayList;
    }

    public static void printWgInfo(String string, Object ... objectArray) {
        if (common.get_debug(common.PTOD_WG_STUFF)) {
            common.ptod("WgInfo: " + string, objectArray);
        } else if (common.get_debug(common.PLOG_WG_STUFF)) {
            common.plog("WgInfo: " + string, objectArray);
        }
    }

    public static void printWgInfo2(String string, Object ... objectArray) {
        if (common.get_debug(common.PTOD_WG_STUFF)) {
            common.ptod("WgInfo2: " + string, objectArray);
        } else {
            common.plog("WgInfo2: " + string, objectArray);
        }
    }

    public static ArrayList<WG_entry> getAllWorkloads() {
        return Host.getAllWorkloads();
    }

    public String[] obsolete_getSdNamesUsedThisRd() {
        HashMap hashMap = new HashMap(16);
        for (WG_entry wG_entry : this.wgs_for_rd) {
            for (String string : wG_entry.getRealSdNames()) {
                hashMap.put(string, null);
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public static String[] getSdNamesUsed() {
        HashMap hashMap = new HashMap(16);
        for (RD_entry rD_entry : Vdbmain.rd_list) {
            for (WG_entry wG_entry : rD_entry.wgs_for_rd) {
                for (String string : wG_entry.getRealSdNames()) {
                    hashMap.put(string, null);
                }
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public String[] getSdsUsedForHostThisRd(Host host) {
        HashMap hashMap = new HashMap(16);
        for (WG_entry wG_entry : this.wgs_for_rd) {
            if (wG_entry.getSlave().getHost() != host) continue;
            for (String string : wG_entry.getRealSdNames()) {
                hashMap.put(string, null);
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public static String[] getSdsUsedForHost(Host host) {
        HashMap hashMap = new HashMap(16);
        for (RD_entry rD_entry : Vdbmain.rd_list) {
            for (WG_entry wG_entry : rD_entry.wgs_for_rd) {
                if (wG_entry.getSlave().getHost() != host) continue;
                for (String string : wG_entry.getRealSdNames()) {
                    hashMap.put(string, null);
                }
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public boolean areWeSharingThreads() {
        return this.current_override.sharingThreads();
    }

    private int adjustThreadCount(int n, BoxPrint boxPrint) {
        int n2 = 0;
        int n3 = SlaveList.getSlaveCount();
        while (true) {
            int n4;
            if (n2++ > 50) {
                common.failure("loop protection");
            }
            if (this.rd_stream_count != 0 && this.rd_stream_count % n3 != 0) {
                n4 = this.rd_stream_count + n3 - this.rd_stream_count % n3;
                boxPrint.add(String.format("Workload stream count for rd=%s increased from %2d to %2d to make it a multiple of the number of slaves (%d).", this.rd_name, this.rd_stream_count, n4, n3), new Object[0]);
                this.rd_stream_count = n4;
                continue;
            }
            if (n % n3 != 0) {
                n4 = n + n3 - n % n3;
                boxPrint.add(String.format("Workload thread count for rd=%s increased from %2d to %2d to make it a multiple of the number of slaves (%d).", this.rd_name, n, n4, n3), new Object[0]);
                this.current_override.changeThreads(n4);
                n = n4;
                continue;
            }
            if (this.rd_stream_count <= 0 || n % this.rd_stream_count == 0) break;
            n4 = n + this.rd_stream_count - n % this.rd_stream_count;
            boxPrint.add(String.format("Workload thread count for rd=%s increased from %2d to %2d to make it a multiple of the number of streams (%d).", this.rd_name, n, n4, this.rd_stream_count), new Object[0]);
            this.current_override.changeThreads(n4);
            n = n4;
        }
        return n;
    }

    private static Slave findWorkForWdSdCombo(WD_entry wD_entry, SD_entry sD_entry) {
        Slave slave = null;
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            if (!wG_entry.wd_name.equals(wD_entry.wd_name) || !wG_entry.sd_used.sd_name.equals(sD_entry.sd_name)) continue;
            if (slave != null) {
                common.failure("Duplicate WD/SD combination found: %s/%s", wD_entry.wd_name, sD_entry.sd_name);
            }
            slave = wG_entry.getSlave();
        }
        return slave;
    }

    private static Slave findWorkForSd(SD_entry sD_entry) {
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            if (!wG_entry.sd_used.sd_name.equals(sD_entry.sd_name)) continue;
            return wG_entry.getSlave();
        }
        return null;
    }

    public static void parseRestart(String string) {
        restart_rd = string;
    }

    private boolean anySkewRequested() {
        for (WD_entry wD_entry : this.wds_for_rd) {
            if (wD_entry.skew_original == 0.0) continue;
            return true;
        }
        return false;
    }
}

