/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Bin;
import Utils.Flat_record;
import Vdb.Cmd_entry;
import Vdb.Dedup;
import Vdb.FileAnchor;
import Vdb.ReplayExtent;
import Vdb.ReplayGroup;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ReplayDevice
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private long device_number;
    private long devno;
    private long duplicate;
    private long records;
    private long max_lba = 0L;
    private long min_lba = Long.MAX_VALUE;
    private int max_xfersize = 0;
    private long first_tod = Long.MAX_VALUE;
    private long last_tod = 0L;
    private boolean reporting_only = false;
    private long xfersize_counts = 0L;
    private long xfersize_sum_of_deltas = 0L;
    private long lba_counts = 0L;
    private long lba_sum_of_deltas = 0L;
    private boolean duplicate_device = false;
    public int duplicates_found = 0;
    private int dedup_unit = 0;
    private ArrayList<ReplayExtent> extent_list = new ArrayList(32);
    private ReplayGroup group;
    private transient Bin split_bin_out = null;

    public ReplayDevice(ReplayGroup replayGroup, long l) {
        ReplayInfo replayInfo = ReplayInfo.getInfo();
        this.erase();
        HashMap hashMap = ReplayInfo.getDeviceMap();
        ReplayDevice replayDevice = (ReplayDevice)hashMap.get(new Long(l));
        this.group = replayGroup;
        this.device_number = l;
        this.devno = l;
        this.reporting_only = replayGroup.isReportingOnly();
        if (replayDevice != null) {
            if (!replayInfo.duplicationNeeded()) {
                common.ptod("Adding duplicate ReplayDevice: " + l);
                common.ptod("Were you planning to use Replay duplication using 'duplication=yes'?");
                common.failure("Adding duplicate ReplayDevice: " + l);
            }
            this.duplicate = ++replayDevice.duplicates_found;
            this.device_number = ReplayDevice.addDupToDevnum(this.device_number, this.duplicate);
        } else if (replayInfo.duplicationNeeded()) {
            try {
                ReplayDevice replayDevice2 = (ReplayDevice)this.clone();
                replayDevice2.duplicates_found = 1;
                replayDevice2.duplicate = 0L;
                if (hashMap.put(replayDevice2.device_number, replayDevice2) != null) {
                    common.failure("Trying to add duplicate ReplayDevice: " + replayDevice2.getDevString());
                }
                common.plog("ReplayDevice added1 " + replayDevice2.getDevString());
                this.duplicate = replayDevice2.duplicates_found;
                this.device_number = ReplayDevice.addDupToDevnum(this.device_number, this.duplicate);
            }
            catch (Exception exception) {
                common.failure(exception);
            }
        }
        if (hashMap.put(this.device_number, this) != null) {
            common.failure("Trying to add duplicate ReplayDevice: " + this.getDevString());
        }
        common.plog("ReplayDevice added2 " + this.getDevString());
    }

    public boolean isReportingOnly() {
        return this.reporting_only;
    }

    public void copyTo(ReplayDevice replayDevice) {
        replayDevice.records = this.records;
        replayDevice.max_lba = this.max_lba;
        replayDevice.min_lba = this.min_lba;
        replayDevice.max_xfersize = this.max_xfersize;
        replayDevice.first_tod = this.first_tod;
        replayDevice.last_tod = this.last_tod;
        replayDevice.reporting_only = this.reporting_only;
        replayDevice.xfersize_counts = this.xfersize_counts;
        replayDevice.xfersize_sum_of_deltas = this.xfersize_sum_of_deltas;
        replayDevice.lba_counts = this.lba_counts;
        replayDevice.lba_sum_of_deltas = this.lba_sum_of_deltas;
    }

    public void erase() {
        this.records = 0L;
        this.max_lba = 0L;
        this.min_lba = Long.MAX_VALUE;
        this.max_xfersize = 0;
        this.first_tod = Long.MAX_VALUE;
        this.last_tod = 0L;
        this.reporting_only = false;
        this.xfersize_counts = 0L;
        this.xfersize_sum_of_deltas = 0L;
        this.lba_counts = 0L;
        this.lba_sum_of_deltas = 0L;
    }

    public static long addDupToDevnum(long l, long l2) {
        long l3 = l | l2 << 48;
        return l3;
    }

    public long getDeviceNumber() {
        return this.device_number;
    }

    public void countRecords() {
        ++this.records;
    }

    public void setRecordCount(long l) {
        this.records = l;
    }

    public long getRecordCount() {
        return this.records;
    }

    public void setMaxLba(long l) {
        this.max_lba = Math.max(this.max_lba, l);
    }

    public long getMaxLba() {
        return this.max_lba;
    }

    public void setMinLba(long l) {
        this.min_lba = Math.min(this.min_lba, l);
    }

    public long getMinLba() {
        return this.min_lba;
    }

    public void addExtent(ReplayExtent replayExtent) {
        this.extent_list.add(replayExtent);
    }

    public static int countUsedDevices() {
        int n = 0;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.reporting_only) continue;
            ++n;
        }
        return n;
    }

    public void setDuplicate() {
        this.duplicate_device = true;
    }

    public boolean isDuplicate() {
        return this.duplicate_device;
    }

    public static ReplayDevice findDeviceAndCreate(long l) {
        HashMap hashMap = ReplayInfo.getDeviceMap();
        ReplayDevice replayDevice = (ReplayDevice)hashMap.get(new Long(l));
        if (replayDevice != null) {
            return replayDevice;
        }
        replayDevice = ReplayGroup.getReportingOnlyGroup().addDevice(l);
        return replayDevice;
    }

    public static ReplayDevice findExistingDevice(long l) {
        HashMap hashMap = ReplayInfo.getDeviceMap();
        ReplayDevice replayDevice = (ReplayDevice)hashMap.get(new Long(l));
        return replayDevice;
    }

    public SD_entry findExtentForLba(Cmd_entry cmd_entry, long l) {
        for (int i = 0; i < this.extent_list.size(); ++i) {
            ReplayExtent replayExtent = this.extent_list.get(i);
            if (!replayExtent.findLbaInExtent(cmd_entry, l)) continue;
            return cmd_entry.sd_ptr;
        }
        return null;
    }

    public SD_entry findExtentForLbaFlat(SD_entry sD_entry, Flat_record flat_record) {
        for (ReplayExtent replayExtent : this.extent_list) {
            SD_entry sD_entry2 = replayExtent.findLbaInExtentFlat(sD_entry, flat_record);
            if (sD_entry2 == null) continue;
            return sD_entry2;
        }
        return null;
    }

    public static long getTotalIoCount() {
        long l = 0L;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        if (ReplayInfo.duplicationNeeded()) {
            vector = ReplayInfo.getDupDevs();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.reporting_only) continue;
            l += replayDevice.records;
        }
        return l;
    }

    public void writeSplitRecord(Flat_record flat_record) {
        if (this.split_bin_out == null) {
            this.split_bin_out = new Bin(this.getSplitFileName());
            this.split_bin_out.output();
            common.ptod("Created Replay split file: " + this.split_bin_out.getFileName());
        }
        flat_record.export(this.split_bin_out);
    }

    public static void closeSplitFiles() {
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt((int)i).split_bin_out == null) continue;
            vector.elementAt((int)i).split_bin_out.close();
        }
    }

    public String getSplitFileName() {
        String string = ReplayInfo.compress() ? String.format("%s%s%s%05d.bin.gz", ReplayInfo.getSplitDirectory(), File.separator, ReplayDevice.getSplitFileNamePrefix(), this.devno) : String.format("%s%s%s%05d.bin", ReplayInfo.getSplitDirectory(), File.separator, ReplayDevice.getSplitFileNamePrefix(), this.devno);
        return string;
    }

    public static String getSplitFileNamePrefix() {
        return "replay_dev_";
    }

    public void setLastTod(long l) {
        this.last_tod = l;
    }

    public long getLastTod() {
        return this.last_tod;
    }

    public void setFirstTod(long l) {
        this.first_tod = l;
    }

    public long getFirstTod() {
        return this.first_tod;
    }

    public static long getAllDevicesLastTod() {
        long l = 0L;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.reporting_only) continue;
            l = Math.max(l, replayDevice.last_tod);
        }
        return l;
    }

    public static long getAllDevicesFirstTod() {
        long l = Long.MAX_VALUE;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.reporting_only) continue;
            l = Math.min(l, replayDevice.first_tod);
        }
        return l;
    }

    public static int getAllDevicesMaxXfersize() {
        int n = 0;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (ReplayDevice replayDevice : vector) {
            if (replayDevice.reporting_only) continue;
            n = Math.max(n, replayDevice.max_xfersize);
        }
        if (n == 0) {
            common.failure("Unknown maximum xfersize");
        }
        return n;
    }

    public void setMaxXfersize(int n) {
        this.max_xfersize = Math.max(this.max_xfersize, n);
    }

    public int getMaxXfersize() {
        return this.max_xfersize;
    }

    public void adjustDedupXfersizeFlat(Flat_record flat_record) {
        int n;
        int n2;
        if (!Dedup.isDedup() || flat_record.flag == 1) {
            return;
        }
        int n3 = flat_record.xfersize;
        n3 = n3 <= this.dedup_unit ? this.dedup_unit : ((n2 = n3 - (n = n3 / this.dedup_unit) * this.dedup_unit) < this.dedup_unit >> 1 ? n * this.dedup_unit : (n + 1) * this.dedup_unit);
        if (n3 - flat_record.xfersize == 0) {
            return;
        }
        ++this.xfersize_counts;
        this.xfersize_sum_of_deltas += (long)(n3 - flat_record.xfersize);
        flat_record.xfersize = n3;
    }

    public void adjustDedupLbaFlat(Flat_record flat_record) {
        if (!Dedup.isDedup() || flat_record.flag == 1) {
            return;
        }
        long l = flat_record.lba;
        long l2 = l % (long)this.dedup_unit;
        l2 = l2 < (long)(this.dedup_unit >> 1) ? (l2 *= -1L) : (long)this.dedup_unit - l2;
        if (l2 == 0L) {
            return;
        }
        ++this.lba_counts;
        this.lba_sum_of_deltas += l2;
        flat_record.lba += l2;
    }

    public static void reportNumbers() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl = false;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        if (ReplayInfo.duplicationNeeded()) {
            vector = ReplayInfo.getDupDevs();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (!replayDevice.isReportingOnly()) {
                l5 += replayDevice.getMaxLba();
            }
            if (!replayDevice.isReportingOnly() && replayDevice.getRecordCount() == 0L) {
                bl = true;
                common.ptod("Replay was requested for device number %s, but no replay records were found for this device. ", replayDevice.getDevString());
                continue;
            }
            String string = String.format("Replay dev: %16s ios: %,10d lba: %7s - %7s Max xf: %7s adjx: %6d adjl: %6d rg=%s", replayDevice.getDevString(), replayDevice.getRecordCount(), replayDevice.getMinLba() == Long.MAX_VALUE ? Integer.valueOf(0) : FileAnchor.whatSize1(replayDevice.getMinLba()), FileAnchor.whatSize1(replayDevice.getMaxLba()), FileAnchor.whatSize1(replayDevice.getMaxXfersize()), replayDevice.xfersize_counts > 0L ? replayDevice.xfersize_sum_of_deltas / replayDevice.xfersize_counts : 0L, replayDevice.lba_counts > 0L ? replayDevice.lba_sum_of_deltas / replayDevice.lba_counts : 0L, replayDevice.group.getName());
            if (replayDevice.reporting_only) {
                common.plog(string);
            } else {
                common.ptod(string);
            }
            l += replayDevice.xfersize_counts;
            l2 += replayDevice.xfersize_sum_of_deltas;
            l3 += replayDevice.lba_counts;
            l4 += replayDevice.lba_sum_of_deltas;
            SD_entry.trackAllSdXfersizes(replayDevice.getMaxXfersize());
        }
        long l6 = 0L;
        long l7 = 0L;
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            if (!sD_entry.isActive()) continue;
            l6 += sD_entry.end_lba;
            l7 += sD_entry.psize;
        }
        common.ptod("Total bytes needed:    %s", FileAnchor.whatSize(l5));
        common.ptod("Total bytes available: %s (%s)", FileAnchor.whatSize(l6), FileAnchor.whatSize(l7));
        if (Dedup.isDedup()) {
            common.ptod("");
            common.ptod("Dedup requires that all data transfer sizes and lbas for write operations");
            common.ptod("are a multiple of dedupunit=%d.", 12345);
            common.ptod("Average xfersize adjustment: %d bytes.", l > 0L ? l2 / l : 0L);
            common.ptod("Average lba adjustment:      %d bytes.", l3 > 0L ? l4 / l3 : 0L);
            common.ptod("");
        }
        if (bl && !common.get_debug(common.IGNORE_MISSING_REPLAY) && !ReplayInfo.duplicationNeeded()) {
            common.failure("One or more requested devices found without replay records");
        }
    }

    public static long[] getDeviceNumbersForSd(String string) {
        Vector<ReplayDevice> vector = new Vector<ReplayDevice>(16);
        Vector<ReplayDevice> vector2 = ReplayInfo.getInfo().getDeviceList();
        if (ReplayInfo.duplicationNeeded()) {
            vector2 = ReplayInfo.getDupDevs();
        }
        for (int i = 0; i < vector2.size(); ++i) {
            ReplayDevice replayDevice = vector2.elementAt(i);
            for (int j = 0; j < replayDevice.extent_list.size(); ++j) {
                if (!replayDevice.extent_list.get(j).getSdName().equals(string)) continue;
                vector.add(replayDevice);
            }
        }
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = (ReplayDevice)vector.elementAt(i);
            lArray[i] = replayDevice.getDeviceNumber();
        }
        return lArray;
    }

    public long getDuplicateNumber() {
        return this.duplicate;
    }

    public String getDevString() {
        if (this.device_number != ReplayDevice.addDupToDevnum(this.devno, this.duplicate)) {
            common.failure("Illegal device number: %016x %08x %08x", this.device_number, this.devno, this.duplicate);
        }
        if (ReplayInfo.duplicationNeeded()) {
            return String.format("%8d.%03d", this.devno, this.duplicate);
        }
        return String.format("%8d", this.devno);
    }

    public static void printDevices(String string) {
        common.ptod("");
        ReplayInfo replayInfo = ReplayInfo.getInfo();
        Vector<ReplayDevice> vector = replayInfo.getDeviceList();
        for (ReplayDevice replayDevice : vector) {
            common.ptod("printDevices %s %s lba: %12d records: %6d", string, replayDevice.getDevString(), replayDevice.getMaxLba(), replayDevice.getRecordCount());
        }
    }

    public String toString() {
        return this.getDevString();
    }

    public static void main(String[] stringArray) {
    }
}

