/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Flat_record;
import Vdb.Cmd_entry;
import Vdb.ReplayDevice;
import Vdb.ReplayGroup;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.SlaveWorker;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;
import java.util.Vector;

class ReplayExtent
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private String rsd_name;
    private ReplayDevice repd;
    private long low_replay_lba;
    private long high_replay_lba;
    private long low_sd_lba;
    private long high_sd_lba;
    private transient SD_entry rsd;
    private static double MB = 1048576.0;
    private static double GB = 1.073741824E9;

    public String getSdName() {
        return this.rsd_name;
    }

    public boolean findLbaInExtent(Cmd_entry cmd_entry, long l) {
        if (l >= this.low_replay_lba && l < this.high_replay_lba) {
            if (this.rsd == null) {
                this.rsd = SlaveWorker.findSd(this.rsd_name);
            }
            cmd_entry.cmd_lba = l - this.low_replay_lba + this.low_sd_lba;
            cmd_entry.sd_ptr = this.rsd;
            long l2 = this.rsd.end_lba - cmd_entry.cmd_lba;
            if (l2 < cmd_entry.cmd_xfersize) {
                cmd_entry.cmd_xfersize = l2;
            }
            if (cmd_entry.cmd_lba + cmd_entry.cmd_xfersize > this.rsd.end_lba) {
                common.ptod("replay_lba: " + l);
                common.ptod("cmd.cmd_lba: " + cmd_entry.cmd_lba);
                this.printRoom("bad", this.rsd.sd_name);
                common.failure("Seek too high");
            }
            return true;
        }
        return false;
    }

    public SD_entry findLbaInExtentFlat(SD_entry sD_entry, Flat_record flat_record) {
        boolean bl = false;
        if (bl) {
            common.ptod("flat.lba:        " + flat_record.lba);
            common.ptod("low_replay_lba:  " + this.low_replay_lba);
            common.ptod("high_replay_lba: " + this.high_replay_lba);
            common.ptod("rsd_name:        " + this.rsd_name);
        }
        if (flat_record.lba >= this.low_replay_lba && flat_record.lba < this.high_replay_lba) {
            if (this.rsd == null) {
                this.rsd = SlaveWorker.findSd(this.rsd_name);
            }
            flat_record.lba = flat_record.lba - this.low_replay_lba + this.low_sd_lba;
            long l = this.rsd.end_lba - flat_record.lba;
            if (l < (long)flat_record.xfersize) {
                flat_record.xfersize = (int)l;
            }
            if (flat_record.lba + (long)flat_record.xfersize > this.rsd.end_lba) {
                common.ptod("replay_lba: " + flat_record.lba);
                this.printRoom("bad", this.rsd.sd_name);
                common.failure("Seek too high");
            }
            return this.rsd;
        }
        return null;
    }

    public static void createExtents() {
        int n;
        Vector vector = ReplayInfo.getGroupList();
        for (int i = 0; i < vector.size(); ++i) {
            n = 0;
            long l = 0L;
            ReplayGroup replayGroup = (ReplayGroup)vector.elementAt(i);
            block1: for (int j = 0; j < replayGroup.getDeviceList().size(); ++j) {
                ReplayDevice replayDevice = (ReplayDevice)replayGroup.getDeviceList().elementAt(j);
                long l2 = replayDevice.getMaxLba();
                long l3 = 0L;
                long l4 = 0L;
                if (replayDevice.getRecordCount() == 0L) {
                    common.failure("Replay requested for device %s. No Replay records found", replayDevice.getDevString(), replayDevice.getRecordCount());
                }
                while (n < replayGroup.getSdList().size()) {
                    SD_entry sD_entry = (SD_entry)replayGroup.getSdList().elementAt(n);
                    long l5 = 0L;
                    ReplayExtent replayExtent = new ReplayExtent();
                    replayExtent.rsd_name = sD_entry.sd_name;
                    replayExtent.repd = replayDevice;
                    replayExtent.low_sd_lba = l;
                    replayExtent.low_replay_lba = l3;
                    replayDevice.addExtent(replayExtent);
                    if (l2 <= sD_entry.end_lba - l) {
                        replayExtent.high_replay_lba = replayDevice.getMaxLba();
                        replayExtent.high_sd_lba = replayExtent.low_sd_lba + l2;
                        l5 += replayExtent.high_sd_lba - replayExtent.low_sd_lba;
                        sD_entry.last_replay_lba_used = l = replayExtent.high_sd_lba;
                        replayExtent.printRoom("room left", replayGroup.getName());
                        continue block1;
                    }
                    long l6 = sD_entry.end_lba - replayExtent.low_sd_lba;
                    l2 -= l6;
                    l3 += l6;
                    replayExtent.high_replay_lba = replayExtent.low_replay_lba + l6;
                    replayExtent.high_sd_lba = replayExtent.low_sd_lba + l6;
                    l = 0L;
                    sD_entry.last_replay_lba_used = l5 += replayExtent.high_sd_lba - replayExtent.low_sd_lba;
                    replayExtent.printRoom("need more", replayGroup.getName());
                    ++n;
                }
            }
        }
        String string = "";
        for (n = 0; n < Vdbmain.sd_list.size(); ++n) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(n);
            if (!sD_entry.isActive() || sD_entry.last_replay_lba_used != 0L) continue;
            string = string + sD_entry.sd_name + " ";
        }
        if (!ReplayInfo.duplicationNeeded() && string.length() > 0) {
            common.failure("ReplayExtent.createExtents(): no replay i/o targeted for one or more SDs (%s) Please remove.", string.trim());
        }
    }

    public void printRoom(String string, String string2) {
        common.plog("%s sd: group: %-8s %-8s %16s replay lba: %11.3fm - %11.3fm sd lba: %11.3fm - %11.3fm", string, string2, this.rsd_name != null ? this.rsd_name : "n/a", this.repd.getDevString(), (double)this.low_replay_lba / MB, (double)this.high_replay_lba / MB, (double)this.low_sd_lba / MB, (double)this.high_sd_lba / MB);
    }
}

