/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.NfsV3;
import Utils.NfsV4;
import Vdb.CpuStats;
import Vdb.FsdEntry;
import Vdb.FwdStats;
import Vdb.Kstat_cpu;
import Vdb.Kstat_data;
import Vdb.NfsStats;
import Vdb.Report;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.Vdbmain;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class ReportData {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Report owner;
    private FwdStats total_fwdstats;
    private FwdStats interval_fwdstats;
    private SdStats total_sdstats;
    private SdStats interval_sdstats;
    private Kstat_cpu total_cpustats;
    private Kstat_cpu interval_cpustats;
    private Kstat_data total_kstats;
    private Kstat_data interval_kstats;
    private NfsV3 total_nfs3;
    private NfsV3 interval_nfs3;
    private NfsV4 total_nfs4;
    private NfsV4 interval_nfs4;
    public long last_real_work;
    public long longest_idle;
    public Date longest_end;

    public ReportData(Report report) {
        this.owner = report;
    }

    public static void clearAllIntervalStats(long l) {
        for (Report report : Report.getReports()) {
            if (Vdbmain.isFwdWorkload()) {
                report.getData().interval_fwdstats = new FwdStats();
                report.getData().interval_fwdstats.setElapsed(l * 1000000L);
            } else {
                report.getData().interval_sdstats = new SdStats();
                report.getData().interval_sdstats.elapsed = l * 1000000L;
            }
            report.getData().interval_cpustats = new Kstat_cpu();
            report.getData().interval_kstats = new Kstat_data();
            report.getData().interval_kstats.elapsed = l * 1000000L;
            if (!NfsStats.areNfsReportsNeeded()) continue;
            report.getData().interval_nfs3 = new NfsV3();
            report.getData().interval_nfs4 = new NfsV4();
        }
    }

    public static void clearAllTotalStats() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            reportArray[i].getData().total_fwdstats = new FwdStats();
            reportArray[i].getData().total_sdstats = new SdStats();
            reportArray[i].getData().total_cpustats = new Kstat_cpu();
            reportArray[i].getData().total_kstats = new Kstat_data();
            reportArray[i].getData().total_nfs3 = new NfsV3();
            reportArray[i].getData().total_nfs4 = new NfsV4();
        }
    }

    public FwdStats getIntervalFwdStats() {
        return this.interval_fwdstats;
    }

    public SdStats getIntervalSdStats() {
        return this.interval_sdstats;
    }

    public Kstat_data getIntervalKstats() {
        return this.interval_kstats;
    }

    public Object getIntervalNfsStats(Object object) {
        if (object instanceof NfsV3) {
            return this.interval_nfs3;
        }
        return this.interval_nfs4;
    }

    public Object getTotalNfsStats(Object object) {
        if (object instanceof NfsV3) {
            return this.total_nfs3;
        }
        return this.total_nfs4;
    }

    public Kstat_cpu getIntervalCpuStats() {
        if (CpuStats.isCpuReporting()) {
            return this.interval_cpustats;
        }
        return null;
    }

    public FwdStats getTotalFwdStats() {
        return this.total_fwdstats;
    }

    public SdStats getTotalSdStats() {
        return this.total_sdstats;
    }

    public Kstat_data getTotalKstats() {
        return this.total_kstats;
    }

    public Kstat_cpu getTotalCpuStats() {
        if (CpuStats.isCpuReporting()) {
            return this.total_cpustats;
        }
        return null;
    }

    public void accumIntervalFwdStats(FwdStats fwdStats) {
        this.interval_fwdstats.accum(fwdStats, false);
    }

    public void accumIntervalSdStats(SdStats sdStats) {
        this.interval_sdstats.stats_accum(sdStats, false);
        if (sdStats.reads + sdStats.writes > 0L) {
            this.last_real_work = System.currentTimeMillis();
        }
    }

    public void accumIntervalCpuStats(Kstat_cpu kstat_cpu) {
        this.interval_cpustats.cpu_accum(kstat_cpu);
    }

    public void accumIntervalKstats(Kstat_data kstat_data) {
        this.interval_kstats.kstat_accum(kstat_data, false);
    }

    public void accumIntervalNfs(Object object) {
        if (object instanceof NfsV3) {
            this.interval_nfs3.accum((NfsV3)object);
        } else {
            this.interval_nfs4.accum((NfsV4)object);
        }
    }

    public static void accumMappedFwdStats(HashMap<String, FwdStats> hashMap) {
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            FwdStats fwdStats = hashMap.get(object);
            ReportData reportData = Report.getReport((String)object).getData();
            reportData.interval_fwdstats.accum(fwdStats, false);
            reportData = Report.getReport(object, "histogram").getData();
            reportData.interval_fwdstats.accum(fwdStats, false);
        }
    }

    public static void accumMappedFsdStats(Slave slave, HashMap<String, FwdStats> hashMap) {
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            FwdStats fwdStats = hashMap.get(object);
            ReportData reportData = Report.getReport((String)object).getData();
            reportData.interval_fwdstats.accum(fwdStats, false);
            reportData = Report.getReport(object, "histogram").getData();
            reportData.interval_fwdstats.accum(fwdStats, false);
            reportData = slave.getReport((String)object).getData();
            reportData.interval_fwdstats.accum(fwdStats, false);
            if (reportData.interval_fwdstats.getTotalRate() > 0.0) {
                reportData.last_real_work = System.currentTimeMillis();
            }
            if (!fwdStats.work_done) continue;
            FsdEntry.findFsd((String)object).work_done = true;
        }
    }

    public static void addFwdIntervalToTotals() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            ReportData reportData = reportArray[i].getData();
            reportData.total_fwdstats.accum(reportData.interval_fwdstats, true);
        }
    }

    public static void addSdIntervalToTotals() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            ReportData reportData = reportArray[i].getData();
            reportData.total_sdstats.stats_accum(reportData.interval_sdstats, true);
        }
    }

    public static void addCpuIntervalToTotals() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            ReportData reportData = reportArray[i].getData();
            reportData.total_cpustats.cpu_accum(reportData.interval_cpustats);
        }
    }

    public static void addKstatIntervalToTotals() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            ReportData reportData = reportArray[i].getData();
            reportData.total_kstats.kstat_accum(reportData.interval_kstats, true);
        }
    }

    public static void addNfsIntervalToTotals() {
        if (!NfsStats.areNfsReportsNeeded()) {
            return;
        }
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            ReportData reportData = reportArray[i].getData();
            reportData.total_nfs3.accum(reportData.interval_nfs3);
            reportData.total_nfs4.accum(reportData.interval_nfs4);
        }
    }

    public static void addHistogramToTotal(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            ReportData reportData = Report.getReport(stringArray[i], "histogram").getData();
            reportData.total_fwdstats.accum(reportData.interval_fwdstats, true);
        }
    }

    public void reportInterval(Kstat_cpu kstat_cpu) {
        this.interval_fwdstats.printLine(this.owner, kstat_cpu);
    }

    public void reportFwdTotal(Kstat_cpu kstat_cpu, String string) {
        this.total_fwdstats.printLineL(this.owner, kstat_cpu, string);
        this.total_fwdstats.printStdLine(this.owner, kstat_cpu, string);
        this.total_fwdstats.printMaxLine(this.owner, kstat_cpu, string);
    }

    public static void reportFwdTotals(String[] stringArray, Kstat_cpu kstat_cpu, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            ReportData reportData = Report.getReport(stringArray[i]).getData();
            reportData.reportFwdTotal(kstat_cpu, string);
        }
    }
}

