/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.CommandOutput;
import Utils.OS_cmd;
import Vdb.SlaveSocket;
import Vdb.SocketMessage;
import Vdb.ThreadControl;
import Vdb.common;
import java.util.Vector;

public class RshUser
extends ThreadControl {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private SlaveSocket socket_to_user;
    public static Vector active_commands = new Vector(32, 0);

    public void setSocket(SlaveSocket slaveSocket) {
        this.socket_to_user = slaveSocket;
    }

    @Override
    public void run() {
        this.setName("RshUser");
        try {
            this.processUser();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public void processUser() {
        this.setIndependent();
        try {
            SocketMessage socketMessage;
            while ((socketMessage = this.socket_to_user.getMessage()) != null) {
                int n = socketMessage.getMessageNum();
                if (n == SocketMessage.RSH_COMMAND) {
                    String string = (String)socketMessage.getData();
                    string = ClassPath.classPath("vdbench") + " SlaveJvm " + string;
                    common.ptod("Executing command: " + string);
                    this.issueCommand(string);
                    this.socket_to_user.putMessage(socketMessage);
                    this.socket_to_user.close();
                    common.ptod("Completed command: " + string);
                    break;
                }
                common.failure("unexpected message from rsh user: " + socketMessage.getMessageText());
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        this.removeIndependent();
    }

    private void issueCommand(String string) {
        active_commands.add(string);
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                int n = string2.equals("stdout") ? SocketMessage.RSH_STDOUT_OUTPUT : SocketMessage.RSH_STDERR_OUTPUT;
                SocketMessage socketMessage = new SocketMessage(n, string);
                if (RshUser.this.socket_to_user.isShutdown()) {
                    return false;
                }
                return RshUser.this.socket_to_user.putMessage(socketMessage);
            }
        });
        oS_cmd.execute();
        active_commands.remove(string);
    }
}

