/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Vdb.BadDataBlock;
import Vdb.ConcatSds;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.DedupBitMap;
import Vdb.Errno;
import Vdb.FifoList;
import Vdb.File_handles;
import Vdb.Host;
import Vdb.Jnl_entry;
import Vdb.Native;
import Vdb.OpenFlags;
import Vdb.RD_entry;
import Vdb.ReplayDevice;
import Vdb.ReplayGroup;
import Vdb.ReplayInfo;
import Vdb.SdDedup;
import Vdb.SdSort;
import Vdb.Slave;
import Vdb.SlaveWorker;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.common;
import Vdb.ownmath;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class SD_entry
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public boolean concatenated_sd = false;
    public String concat_wd_name = null;
    public ArrayList<SD_entry> sds_in_concatenation = null;
    public String sd_name;
    public String sd_name8;
    private boolean active;
    boolean sd_is_referenced = false;
    public int relative_sd_num;
    public int relative_fake_sd;
    private String[] host_names = new String[]{"*"};
    transient Vector host_info = new Vector(2, 0);
    public String lun;
    int filecount = 0;
    int filestart = 0;
    public long end_lba = 0L;
    public long csd_start_lba = 0L;
    public long csd_end_lba = 0L;
    int threads = 8;
    String jnl_dir_name = null;
    public SdDedup sdd = null;
    public Dedup dedup = null;
    public DV_map dv_map = null;
    WG_entry wg_for_sd = null;
    long psize;
    long hitarea = 0x100000L;
    long offset = 0L;
    long align = 0L;
    public boolean open_for_write = false;
    boolean pure_rand_seq;
    public transient FifoList fifo_to_iot;
    boolean journal_recovery_complete = false;
    long fhandle;
    boolean work_done;
    long scsi_lun_reset = 0L;
    long scsi_bus_reset = 0L;
    long scsi_lun_tod = 0L;
    long scsi_bus_tod = 0L;
    double lowrange = -1.0;
    double highrange = -1.0;
    public OpenFlags open_flags = new OpenFlags();
    double[] possible_replay_numbers = new double[0];
    String[] possible_replay_groups = new String[0];
    long duplicate_number = 0L;
    String[] disknames = null;
    String instance = null;
    public long last_replay_lba_used = 0L;
    private HashMap xfersizes_map = new HashMap(8);
    transient Vector raw_device_list = null;
    boolean format_inserted = false;
    long sd_error_count = 0L;
    long sd_error_time = 0L;
    private static Vector pending_host_parms = new Vector(8, 0);
    private static Vector<String> pending_lun_parms = new Vector(8, 0);
    private int key_block_size = 0;
    private int max_xfersize = 0;
    public transient Slave slave_used_for_dv = null;
    private static int all_max_xfersize = 0;
    public static int max_sd_name = 0;
    private static SD_entry dflt = new SD_entry();
    public static String SD_FORMAT_NAME;
    public HashMap<Long, BadDataBlock> bad_data_map = null;
    public Fput rw_log = null;
    private static HashMap<String, Fput> open_rwlog_map;

    public Object clone() {
        try {
            SD_entry sD_entry = (SD_entry)super.clone();
            sD_entry.host_info = (Vector)this.host_info.clone();
            sD_entry.host_names = (String[])this.host_names.clone();
            sD_entry.possible_replay_numbers = (double[])this.possible_replay_numbers.clone();
            sD_entry.possible_replay_groups = (String[])this.possible_replay_groups.clone();
            sD_entry.open_flags = (OpenFlags)this.open_flags.clone();
            if (this.dedup != null) {
                sD_entry.dedup = (Dedup)this.dedup.clone();
            }
            return sD_entry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static void clearAllActive() {
        for (SD_entry sD_entry : Vdbmain.sd_list) {
            sD_entry.active = false;
        }
    }

    public void setActive() {
        this.active = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public static void openAllSds() {
        for (WG_entry wG_entry : SlaveWorker.work.wgs_for_slave) {
            if (Validate.sdConcatenation()) {
                wG_entry.sd_used.fhandle = 0L;
                ArrayList<SD_entry> arrayList = wG_entry.sd_used.sds_in_concatenation;
                for (SD_entry sD_entry : wG_entry.sd_used.sds_in_concatenation) {
                    sD_entry.openOneSd();
                }
                continue;
            }
            wG_entry.sd_used.openOneSd();
        }
    }

    private void openOneSd() {
        long l;
        long l2;
        int n;
        if (this.concatenated_sd) {
            common.failure("Illegal open call for concatenated sd=%s", this.sd_name);
        }
        if (this.fhandle != 0L) {
            return;
        }
        OpenFlags openFlags = this.open_flags;
        if (SlaveWorker.work.rd_open_flags != null) {
            openFlags = SlaveWorker.work.rd_open_flags;
        }
        common.ptod("Opening sd=%s,lun=%s; write: %b; flags: %s", this.sd_name, this.lun, this.open_for_write, openFlags.toString());
        if (common.onLinux() && this.lun.startsWith("/dev/") && openFlags.getOpenFlags() == 0) {
            common.failure("On Linux 'openflags=o_direct' is required for any lun starting with '/dev/': " + this.lun);
        }
        this.fhandle = Native.openFile(this.lun, openFlags, this.open_for_write ? 1 : 0);
        if (this.fhandle == -1L) {
            common.failure("Open for lun '" + this.lun + "' failed");
        }
        File_handles.addHandle(this.fhandle, this);
        if (openFlags.isOther(OpenFlags.SOL_CLEAR_CACHE) && (n = Native.eraseFileSystemCache(this.fhandle, this.end_lba)) != 0) {
            common.ptod("Native.eraseFileSystemCache() failed. file: %s, rc=%d ", this.lun, n);
            common.ptod("('openflags=clear_cache' is only available when file is opened for output.)");
        }
        if (common.get_debug(common.SCSI_RESET_AT_START) && (l2 = Native.writeFile(this.fhandle, 0L, 0L, -1L)) != 0L) {
            common.failure("Scsi lun reset failed: " + Errno.xlate_errno(l2));
        }
        if (common.get_debug(common.SCSI_RESET_ALL_START) && (l = Native.writeFile(this.fhandle, 0L, 0L, -2L)) != 0L) {
            common.failure("Scsi lun reset failed: " + Errno.xlate_errno(l));
        }
        if (Dedup.isDedup()) {
            this.sdd.uniques_bitmap = DedupBitMap.findUniqueBitmap("sd=" + this.sd_name);
            if (this.sdd.uniques_bitmap == null) {
                this.sdd.uniques_bitmap = new DedupBitMap().createMapForUniques(this.dedup, this.end_lba, "sd=" + this.sd_name);
                DedupBitMap.addUniqueBitmap(this.sdd.uniques_bitmap, "sd=" + this.sd_name);
            }
        }
        if (common.get_debug(common.CREATE_READ_WRITE_LOG)) {
            this.setupReadWriteLog(this);
        }
    }

    public static void closeAllSds() {
        for (WG_entry wG_entry : SlaveWorker.work.wgs_for_slave) {
            if (Validate.sdConcatenation()) {
                for (SD_entry sD_entry : wG_entry.sd_used.sds_in_concatenation) {
                    sD_entry.closeOneSd();
                }
                continue;
            }
            wG_entry.sd_used.closeOneSd();
        }
    }

    private void closeOneSd() {
        long l;
        if (this.concatenated_sd) {
            common.failure("Illegal close call for concatenated sd=%s", this.sd_name);
        }
        if (this.fhandle == 0L) {
            return;
        }
        OpenFlags openFlags = this.open_flags;
        if (SlaveWorker.work.rd_open_flags != null) {
            openFlags = SlaveWorker.work.rd_open_flags;
        }
        if ((l = Native.closeFile(this.fhandle, openFlags)) != 0L) {
            common.failure("File close failed: rc=" + l + " " + this.lun);
        }
        File_handles.remove(this.fhandle);
        this.fhandle = 0L;
    }

    static String readParms(Vector vector, String string) {
        String string2 = string;
        SD_entry sD_entry = null;
        Vdb_scan vdb_scan = null;
        try {
            block36: {
                do {
                    if (string2 == null) continue;
                    vdb_scan = Vdb_scan.parms_split(string2);
                    if (vdb_scan.keyword.equals("wd") || vdb_scan.keyword.equals("rd") || vdb_scan.keyword.equals("fwd")) {
                        if (sD_entry != null) {
                            super.finishPendingParms();
                        }
                        break block36;
                    }
                    if (vdb_scan.keyword.equals("sd")) {
                        if (sD_entry != null) {
                            sD_entry.finishPendingParms();
                        }
                        if (vdb_scan.alphas[0].equals("default")) {
                            sD_entry = dflt;
                            continue;
                        }
                        sD_entry = (SD_entry)dflt.clone();
                        sD_entry.sd_name = vdb_scan.alphas[0];
                        vector.add(sD_entry);
                        sD_entry.relative_sd_num = vector.size();
                        max_sd_name = Math.max(max_sd_name, sD_entry.sd_name.length());
                        if (sD_entry.sd_name.equalsIgnoreCase("concat")) {
                            common.failure("Creating an SD named 'concat' is not allowed");
                        }
                        if (sD_entry.sd_name.length() > 8 && Validate.isValidate()) {
                            common.failure("With Data Validation an SD name may be no longer than 8 bytes ('" + sD_entry.sd_name + "')");
                        }
                        if (!Validate.isValidate() || sD_entry.sd_name.length() <= 8) continue;
                        common.failure("For Data Validation an SD name may be only 8 characters or less: " + sD_entry.sd_name);
                        continue;
                    }
                    if ("host".startsWith(vdb_scan.keyword) || vdb_scan.keyword.equals("hd")) {
                        pending_host_parms.add(vdb_scan.alphas);
                        continue;
                    }
                    if ("lun".startsWith(vdb_scan.keyword)) {
                        if (sD_entry == dflt) {
                            common.failure("You may not specify the 'lun=' parameter for sd=default");
                        }
                        sD_entry.lun = vdb_scan.alphas[0];
                        pending_lun_parms.add(sD_entry.lun);
                        continue;
                    }
                    if ("count".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.getNumCount() != 2) {
                            common.failure("'count=(start,count)' parameter requires two values");
                        }
                        sD_entry.filestart = (int)vdb_scan.numerics[0];
                        if (vdb_scan.getNumCount() <= 1) continue;
                        sD_entry.filecount = (int)vdb_scan.numerics[1];
                        if (sD_entry.filecount > 0) continue;
                        common.failure("'count=(start,count)' parameter requires two values of which the second value must be greater than zero.");
                        continue;
                    }
                    if ("size".startsWith(vdb_scan.keyword)) {
                        sD_entry.end_lba = (long)vdb_scan.numerics[0];
                        if (vdb_scan.num_count <= 1) continue;
                        sD_entry.end_lba /= (long)((int)vdb_scan.numerics[1]);
                        continue;
                    }
                    if ("threads".startsWith(vdb_scan.keyword)) {
                        sD_entry.threads = (int)vdb_scan.numerics[0];
                        if (vdb_scan.num_count <= 1) continue;
                        sD_entry.threads /= Math.max(1, (int)vdb_scan.numerics[1]);
                        continue;
                    }
                    if ("hitarea".startsWith(vdb_scan.keyword)) {
                        ConcatSds.abortIf("'hitarea=' parameter may not be used.");
                        sD_entry.hitarea = (long)vdb_scan.numerics[0];
                        continue;
                    }
                    if ("offset".startsWith(vdb_scan.keyword)) {
                        ConcatSds.abortIf("'offset=' parameter may not be used.");
                        sD_entry.offset = (long)vdb_scan.numerics[0];
                        if (sD_entry.offset % 512L != 0L) {
                            common.failure("SD offset= parameter must be multiple of 512 bytes");
                        }
                        if (!Validate.isValidate()) continue;
                        common.failure("Data validation and offset= are mutually exclusive.");
                        continue;
                    }
                    if ("align".startsWith(vdb_scan.keyword)) {
                        ConcatSds.abortIf("'align=' parameter may not be used.");
                        sD_entry.align = (long)vdb_scan.numerics[0];
                        if (sD_entry.align % 512L != 0L) {
                            common.failure("SD align= parameter must be multiple of 512 bytes");
                        }
                        if (!Validate.isValidate()) continue;
                        common.failure("Data validation and align= are mutually exclusive.");
                        continue;
                    }
                    if ("kstat".startsWith(vdb_scan.keyword)) {
                        sD_entry.disknames = vdb_scan.alphas;
                        continue;
                    }
                    if ("instance".startsWith(vdb_scan.keyword)) {
                        sD_entry.instance = vdb_scan.alphas[0];
                        continue;
                    }
                    if ("replay".startsWith(vdb_scan.keyword)) {
                        RD_entry.dflt.setNoElapsed();
                        ReplayInfo.setReplay();
                        sD_entry.storeReplayParms(vdb_scan);
                        continue;
                    }
                    if ("journal".startsWith(vdb_scan.keyword)) {
                        sD_entry.jnl_dir_name = vdb_scan.alphas[0];
                        continue;
                    }
                    if ("resetlun".startsWith(vdb_scan.keyword)) {
                        sD_entry.scsi_lun_reset = (long)vdb_scan.numerics[0];
                        continue;
                    }
                    if ("resetbus".startsWith(vdb_scan.keyword)) {
                        sD_entry.scsi_bus_reset = (long)vdb_scan.numerics[0];
                        continue;
                    }
                    if ("openflags".startsWith(vdb_scan.keyword)) {
                        sD_entry.open_flags = new OpenFlags(vdb_scan.alphas, vdb_scan.numerics);
                        continue;
                    }
                    if ("range".startsWith(vdb_scan.keyword)) {
                        sD_entry.lowrange = vdb_scan.numerics[0];
                        if (vdb_scan.getNumCount() > 1) {
                            sD_entry.highrange = vdb_scan.numerics[1];
                        } else {
                            common.failure("'range=' parameter must be specified with a beginning and ending range, e.g. 'range=(10,20)'");
                        }
                        ConcatSds.abortIf("'range=' parameter may not be used.");
                        continue;
                    }
                    if (vdb_scan.keyword.startsWith("dedup")) {
                        if (sD_entry.dedup == null) {
                            sD_entry.dedup = (Dedup)Dedup.dedup_default.clone();
                        }
                        sD_entry.dedup.parseDedupParms(vdb_scan, false);
                        continue;
                    }
                    if ("streams".startsWith(vdb_scan.keyword)) {
                        common.failure("The 'streams=' parameter no longer is a Storage Definition (SD) parameter, but has become a Workload Definition (WD) parameter. ");
                        continue;
                    }
                    common.failure("Unknown keyword: " + vdb_scan.keyword);
                } while ((string2 = Vdb_scan.parms_get()) != null);
                return null;
            }
            SD_entry.handleFileCount(Vdbmain.sd_list);
            Dedup.checkSdDedup();
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.failure("Exception during reading of input parameter file(s).");
        }
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            sD_entry = Vdbmain.sd_list.elementAt(i);
            sD_entry.sd_name8 = (sD_entry.sd_name + "        ").substring(0, 8);
        }
        return string2;
    }

    private void finishPendingParms() {
        if (this == dflt) {
            if (pending_host_parms.size() > 0) {
                this.host_names = (String[])pending_host_parms.firstElement();
            }
            return;
        }
        if (pending_lun_parms.size() == 0) {
            common.failure("No lun name specified for sd=" + this.sd_name);
        }
        if (pending_lun_parms.size() == 1 && pending_host_parms.size() == 0) {
            pending_host_parms.add(this.host_names);
        }
        if (pending_lun_parms.size() != pending_host_parms.size()) {
            common.failure("'host=' and 'lun=' parameters must be defined in pairs for sd=" + this.sd_name);
        }
        for (int i = 0; i < pending_lun_parms.size(); ++i) {
            String[] stringArray = (String[])pending_host_parms.elementAt(i);
            Vector vector = Host.findSelectedHosts(stringArray);
            for (String string : vector) {
                Host host = Host.findHost(string);
                if (this.filecount == 0) {
                    host.addLun(this.sd_name, pending_lun_parms.elementAt(i));
                    continue;
                }
                for (int j = 0; j < this.filecount; ++j) {
                    String string2 = SD_entry.createCountingName(this.sd_name, this.filestart, j);
                    String string3 = SD_entry.createCountingName(pending_lun_parms.get(i), this.filestart, j);
                    host.addLun(string2, string3);
                }
            }
        }
        pending_host_parms.removeAllElements();
        pending_lun_parms.removeAllElements();
    }

    public static void adjustReplay(Vector<SD_entry> vector) {
        for (SD_entry sD_entry : vector) {
            if (sD_entry.possible_replay_numbers != null && sD_entry.possible_replay_numbers.length > 0) {
                ReplayGroup replayGroup = new ReplayGroup(sD_entry.sd_name);
                replayGroup.addSD(sD_entry);
                for (int i = 0; i < sD_entry.possible_replay_numbers.length; ++i) {
                    replayGroup.addDevice((long)sD_entry.possible_replay_numbers[i]);
                    if (!ReplayInfo.duplicationNeeded()) continue;
                    ReplayDevice replayDevice = ReplayDevice.findExistingDevice((long)sD_entry.possible_replay_numbers[i]);
                    sD_entry.duplicate_number = replayDevice.duplicates_found;
                }
                continue;
            }
            if (sD_entry.possible_replay_groups.length <= 0) continue;
            if (ReplayInfo.duplicationNeeded()) {
                common.failure("Replay duplication not allowed when using Replay Groups");
            }
            for (int i = 0; i < sD_entry.possible_replay_groups.length; ++i) {
                ReplayGroup.addSDGroup(sD_entry, sD_entry.possible_replay_groups[i]);
            }
        }
    }

    private static void handleFileCount(Vector<SD_entry> vector) {
        SD_entry sD_entry;
        int n;
        SD_entry sD_entry2;
        int n2;
        boolean bl = false;
        do {
            bl = false;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                sD_entry2 = vector.elementAt(n2);
                for (n = 0; n < sD_entry2.filecount; ++n) {
                    sD_entry = (SD_entry)sD_entry2.clone();
                    bl = true;
                    sD_entry.sd_name = SD_entry.createCountingName(sD_entry2.sd_name, sD_entry2.filestart, n);
                    sD_entry.filecount = 0;
                    vector.add(sD_entry);
                    sD_entry.relative_sd_num = vector.size();
                    max_sd_name = Math.max(max_sd_name, sD_entry.sd_name.length());
                    sD_entry.lun = SD_entry.createCountingName(sD_entry2.lun, sD_entry2.filestart, n);
                    common.plog("Use of 'sd=%s,count=(%d,%d)' parameter added sd=%s,lun=%s", sD_entry2.sd_name, sD_entry2.filestart, sD_entry2.filecount, sD_entry.sd_name, sD_entry.lun);
                }
                if (sD_entry2.filecount <= 0) continue;
                vector.remove(sD_entry2);
            }
        } while (bl);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            sD_entry2 = vector.elementAt(n2);
            for (n = n2 + 1; n < vector.size(); ++n) {
                sD_entry = vector.elementAt(n);
                if (!sD_entry.sd_name.equals(sD_entry2.sd_name)) continue;
                common.failure("Duplicate SD names not allowed: " + sD_entry2.sd_name);
            }
        }
    }

    private static String createCountingName(String string, int n, int n2) {
        String string2 = null;
        try {
            string2 = string.contains("%") ? String.format(string, n + n2) : (string.contains("*") ? common.replace_string(string, "*", "" + (n + n2)) : string + (n + n2));
        }
        catch (Exception exception) {
            common.ptod("createCountingName: " + string);
            common.ptod("start:              " + n);
            common.ptod("index:              " + n2);
            common.ptod("Exception using 'printf' mask resulting from the use of the 'count=' parameter");
            common.failure(exception);
        }
        return string2;
    }

    public synchronized void scsi_reset() {
        long l;
        long l2 = Native.get_simple_tod();
        if (this.scsi_lun_tod == 0L) {
            this.scsi_lun_tod = (long)ownmath.uniform(0.0, this.scsi_lun_reset * 2L * 1000000L);
            this.scsi_lun_tod += l2;
        }
        if (this.scsi_bus_tod == 0L) {
            this.scsi_bus_tod = (long)ownmath.uniform(0.0, this.scsi_bus_reset * 2L * 1000000L);
            this.scsi_bus_tod += l2;
        }
        if (this.scsi_lun_reset > 0L && l2 > this.scsi_lun_tod) {
            common.ptod("+Lun reset issued for lun=" + this.lun);
            l = Native.writeFile(this.fhandle, 0L, 0L, -1L);
            if (l != 0L) {
                common.failure("Scsi lun reset failed: " + Errno.xlate_errno(l));
            }
            this.scsi_lun_tod = (long)ownmath.uniform(0.0, this.scsi_lun_reset * 2L * 1000000L);
            this.scsi_lun_tod += l2;
        }
        if (this.scsi_bus_reset > 0L && l2 > this.scsi_bus_tod) {
            common.ptod("+Bus reset issued for lun=" + this.lun);
            l = Native.writeFile(this.fhandle, 0L, 0L, -2L);
            if (l != 0L) {
                common.failure("Scsi bus reset failed: " + Errno.xlate_errno(l));
            }
            this.scsi_bus_tod = (long)ownmath.uniform(0.0, this.scsi_bus_reset * 2L * 1000000L);
            this.scsi_bus_tod += l2;
        }
    }

    public static SD_entry findSD(String string) {
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            if (!sD_entry.sd_name.equals(string)) continue;
            return sD_entry;
        }
        common.failure("findSD(): SD not found: " + string);
        return null;
    }

    public static SD_entry[] getActiveSds() {
        Vector<SD_entry> vector = new Vector<SD_entry>(8, 0);
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            if (!sD_entry.isActive()) continue;
            vector.add(sD_entry);
        }
        return vector.toArray(new SD_entry[0]);
    }

    public int getMaxSdXfersize() {
        if (this.max_xfersize == 0) {
            common.failure("getMaxSdXfersize(): max_xfersize still zero");
        }
        return this.max_xfersize;
    }

    public static int getAllSdMaxXfersize() {
        return all_max_xfersize;
    }

    public DV_map getDvMap() {
        return DV_map.findExistingMap(this.sd_name);
    }

    public Jnl_entry getJournal() {
        if (this.dv_map == null) {
            common.failure("SD=" + this.sd_name + " does not have a Journal instance.");
        }
        return this.dv_map.journal;
    }

    public static String[] getSdNames() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(64);
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            hashMap.put(sD_entry.sd_name, sD_entry);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    private static void checkForDuplicate(String string) {
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            if (sD_entry.sd_name.compareTo(string) != 0) continue;
            common.failure("Duplicate SD names not allowed: " + string);
        }
    }

    public boolean canWeUseBlockZero() {
        if (common.get_debug(common.ALLOW_BLOCK0_ACCESS)) {
            return true;
        }
        if (common.get_debug(common.NO_BLOCK0_ACCESS)) {
            return false;
        }
        if (Validate.sdConcatenation()) {
            return false;
        }
        boolean bl = false;
        if (common.onWindows() && !this.lun.startsWith("\\\\")) {
            bl = true;
        }
        if (!common.onWindows() && !this.lun.startsWith("/dev")) {
            bl = true;
        }
        return bl;
    }

    public void trackSdXfersizes(double[] dArray) {
        boolean bl = false;
        if (dArray.length == 3) {
            int n = (int)dArray[1];
            this.max_xfersize = Math.max(this.max_xfersize, n);
            SD_entry.trackAllSdXfersizes(n);
            Object var4_5 = this.xfersizes_map.put(new Integer(n), null);
            if (bl && var4_5 == null) {
                common.ptod("trackXfersizes() %s Added xfersize %d", this.sd_name, n);
            }
            if ((long)((int)dArray[2]) != this.align) {
                common.failure("The 'sd=%s,lun=%s,align=xxx' parameter must be set to the same alignment value used in 'xfersize=(min,max,align)' (%d)", this.sd_name, this.lun, (int)dArray[2]);
            }
            return;
        }
        for (int i = 0; i < dArray.length; i += 2) {
            int n = (int)dArray[i];
            this.max_xfersize = Math.max(this.max_xfersize, n);
            SD_entry.trackAllSdXfersizes(n);
            Object var5_7 = this.xfersizes_map.put(new Integer(n), null);
            if (!bl || var5_7 != null) continue;
            common.ptod("trackXfersizes() %s Added xfersize %d", this.sd_name, n);
        }
    }

    public static void trackAllSdXfersizes(int n) {
        all_max_xfersize = Math.max(all_max_xfersize, n);
    }

    public static void calculateKeyBlockSizes() {
        for (SD_entry sD_entry : SD_entry.getRealSds(Vdbmain.sd_list)) {
            sD_entry.calculateKeyBlockSize();
        }
    }

    private void calculateKeyBlockSize() {
        String string;
        String string2 = string = Validate.isRealValidate() ? "Data Validation" : "Dedup";
        if (Dedup.isDedup()) {
            double[] dArray = new double[1];
            SD_entry sD_entry = this;
            dArray[0] = sD_entry.dedup.getDedupUnit();
            this.trackSdXfersizes(dArray);
        }
        Object[] objectArray = this.xfersizes_map.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        if (objectArray.length == 0) {
            common.failure("No 'xfersize=' parameters found for sd=" + this.sd_name + ". Are you sure this SD is used?");
        }
        if (Validate.isValidateForDedup()) {
            SD_entry sD_entry = this;
            this.key_block_size = sD_entry.dedup.getDedupUnit();
            return;
        }
        if (Dedup.isDedup()) {
            SD_entry sD_entry = this;
            this.key_block_size = sD_entry.dedup.getDedupUnit();
        } else {
            this.key_block_size = (Integer)objectArray[0];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            int n = (Integer)objectArray[i];
            if (n % this.key_block_size == 0) continue;
            common.ptod("During " + string + " all data transfer sizes used for ");
            common.ptod("an SD must be a multiple of the lowest xfersize.");
            common.ptod("(A format run may have added a transfer size of 128k).");
            if (Dedup.isDedup()) {
                Object[] objectArray2 = new Object[1];
                SD_entry sD_entry = this;
                objectArray2[0] = sD_entry.dedup.getDedupUnit();
                common.ptod("(Dedup may have added dedupunit=%d)", objectArray2);
            }
            for (int j = 0; j < objectArray.length; ++j) {
                n = (Integer)objectArray[j];
                common.ptod("Xfersize used in parameter file: " + n);
            }
            common.failure("Xfersize error");
        }
    }

    public int getKeyBlockSize() {
        if (this.key_block_size == 0) {
            common.failure("getKeyBlockSize(): key_block_size still zero for sd=%s", this.sd_name);
        }
        return this.key_block_size;
    }

    private void storeReplayParms(Vdb_scan vdb_scan) {
        int n;
        int n2 = 0;
        for (n = 0; n < vdb_scan.alphas.length; ++n) {
            if (!common.isNumeric(vdb_scan.alphas[n])) continue;
            ++n2;
        }
        this.possible_replay_numbers = new double[n2];
        this.possible_replay_groups = new String[vdb_scan.alphas.length - n2];
        n = 0;
        int n3 = 0;
        for (int i = 0; i < vdb_scan.alphas.length; ++i) {
            if (common.isNumeric(vdb_scan.alphas[i])) {
                this.possible_replay_numbers[n++] = Double.parseDouble(vdb_scan.alphas[i]);
                continue;
            }
            this.possible_replay_groups[n3++] = vdb_scan.alphas[i];
        }
    }

    public static void main(String[] stringArray) {
        int n = 128;
        HashMap hashMap = new HashMap(16);
        hashMap.put("", null);
        hashMap.put("", null);
        for (int i = 2; i < n; ++i) {
            String string = "sd" + (n - 1 - i);
            hashMap.put(string, null);
        }
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(stringArray2, new SdSort());
        for (int i = 0; i < stringArray2.length; ++i) {
            common.ptod("sds2: " + stringArray2[i]);
        }
    }

    public void setOpenForWrite() {
        this.open_for_write = true;
        if (this.sds_in_concatenation != null) {
            for (int i = 0; i < this.sds_in_concatenation.size(); ++i) {
                this.sds_in_concatenation.get(i).setOpenForWrite();
            }
        }
    }

    public boolean isOpenForWrite() {
        return this.open_for_write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupReadWriteLog(SD_entry sD_entry) {
        if (!Validate.isRealValidate()) {
            common.failure("Requesting read/write log while not using Data Validation");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyy-HH:mm:ss.SSS zzz");
        String string = System.getProperty("java.io.tmpdir");
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            this.rw_log = open_rwlog_map.get(sD_entry.sd_name);
            if (this.rw_log != null) {
                this.rw_log.println("* This file was continued at " + simpleDateFormat.format(new Date()));
                return;
            }
            common.where();
            String string2 = new File(string, sD_entry.sd_name + ".log").getAbsolutePath();
            this.rw_log = new Fput(string2);
            open_rwlog_map.put(sD_entry.sd_name, this.rw_log);
            this.rw_log.println("* ");
            this.rw_log.println("* Column description:");
            this.rw_log.println("* ");
            this.rw_log.println("* sd=%s,lun=%s", sD_entry.sd_name, sD_entry.lun);
            this.rw_log.println("* ");
            this.rw_log.println("* Following data is per 'key block size', the smallest xfersize during a test.");
            this.rw_log.println("* ");
            this.rw_log.println("* Column 1: Timestamp: HH:mm:ss.SSS");
            this.rw_log.println("* ");
            this.rw_log.println("* Column 2: Read or write");
            this.rw_log.println("* ");
            this.rw_log.println("* Column 3: Data Validation key just read or written");
            this.rw_log.println("* ");
            this.rw_log.println("* Column 4: Logical byte address of 'key block'");
            this.rw_log.println("* ");
            this.rw_log.println("* ONLY when the file ends with 'Log properly closed' can we be assured this file is complete");
            this.rw_log.println("* and nothing has been left behind in either java buffers or file system cache.");
            this.rw_log.println("* There may be multiple occurrences of 'Log properly closed'.");
            this.rw_log.println("* ");
            this.rw_log.println("* This file was created at " + simpleDateFormat.format(new Date()));
            this.rw_log.println("* ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllLogs() {
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyy-HH:mm:ss.SSS zzz");
            for (String string : open_rwlog_map.keySet()) {
                Fput fput = open_rwlog_map.get(string);
                fput.println("* Log properly closed at " + simpleDateFormat.format(new Date()));
                fput.close();
            }
            open_rwlog_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAllLogs() {
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            for (Fput fput : open_rwlog_map.values()) {
                fput.flush();
            }
        }
    }

    public static SD_entry[] getRealSds(Vector<SD_entry> vector) {
        HashMap<SD_entry, SD_entry> hashMap = new HashMap<SD_entry, SD_entry>(8);
        for (SD_entry sD_entry : vector) {
            if (!sD_entry.concatenated_sd) {
                hashMap.put(sD_entry, sD_entry);
                continue;
            }
            for (SD_entry sD_entry2 : sD_entry.sds_in_concatenation) {
                hashMap.put(sD_entry2, sD_entry2);
            }
        }
        SD_entry[] sD_entryArray = hashMap.keySet().toArray(new SD_entry[0]);
        Arrays.sort(sD_entryArray, new SdSort());
        return sD_entryArray;
    }

    static {
        SD_entry.dflt.sd_name = "default";
        SD_FORMAT_NAME = "SD_format";
        open_rwlog_map = new HashMap(8);
    }
}

