/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.DedupBitMap;
import Vdb.SD_entry;
import Vdb.SdSort;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SdDedup
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String name = "SdDedup";
    int dedup_unit = 0;
    long rel_byte_start = 0L;
    long rel_byte_end = 0L;
    long rel_block_start = 0L;
    long rel_block_end = 0L;
    Dedup dedup = null;
    DedupBitMap uniques_bitmap = null;
    ArrayList<Integer> hot_blocks = new ArrayList(0);

    public SdDedup(String string) {
        this.name = string;
    }

    public long translateDuplicateBlockToSet(long l) {
        long l2;
        boolean bl = false;
        if (l < this.rel_block_start) {
            common.failure("Invalid call: block %,d for %s below relative start of %,d", l, this.name, this.rel_block_start);
        }
        if (l >= this.rel_block_end) {
            common.failure("Invalid call: block %,d for %s beyond relative end of %,d", l, this.name, this.rel_block_end);
        }
        if ((l2 = l - this.rel_block_start) >= (long)this.hot_blocks.size()) {
            long l3 = this.dedup.translateBlockToSet(l);
            if (bl) {
                common.ptod("nothot: %6d %6d %6d %s", this.rel_block_start, l, l3, this.name);
            }
            return l3;
        }
        long l4 = l - this.rel_block_start;
        long l5 = this.hot_blocks.get((int)l4).intValue();
        if (bl) {
            common.ptod("hotset: %6d %6d %6d %s", this.rel_block_start, l, l5, this.name);
        }
        return l5;
    }

    public static void adjustSdDedupValues() {
        int n = Validate.getDedupUnit();
        SD_entry[] sD_entryArray = Vdbmain.sd_list.toArray(new SD_entry[0]);
        Arrays.sort(sD_entryArray, new SdSort());
        HashMap<Dedup, Dedup> hashMap = new HashMap<Dedup, Dedup>(4);
        for (SD_entry sD_entry : sD_entryArray) {
            if (sD_entry.concatenated_sd) continue;
            hashMap.put(sD_entry.dedup, sD_entry.dedup);
        }
        for (Dedup dedup : hashMap.values()) {
            String[] stringArray;
            HashMap<String, SD_entry> hashMap2 = new HashMap<String, SD_entry>(8);
            for (SD_entry sD_entry : sD_entryArray) {
                if (sD_entry.dedup != dedup) continue;
                hashMap2.put(sD_entry.sd_name, sD_entry);
            }
            long l = 0L;
            for (String string : stringArray = hashMap2.keySet().toArray(new String[0])) {
                SD_entry sD_entry = (SD_entry)hashMap2.get(string);
                SdDedup sdDedup = sD_entry.sdd = new SdDedup(sD_entry.sd_name);
                sdDedup.dedup = dedup;
                sdDedup.rel_byte_start = l;
                sdDedup.rel_byte_end = l + sD_entry.end_lba;
                sdDedup.rel_block_start = l / (long)n;
                sdDedup.rel_block_end = (l + sD_entry.end_lba) / (long)n;
                l += sD_entry.end_lba;
            }
            dedup.total_size = l;
            dedup.adjustSdDedupValue();
        }
    }

    public void receiveHotset(int n) {
        this.hot_blocks.add(n);
    }
}

