/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.DvKeyBlock;
import Vdb.Native;
import Vdb.common;
import java.util.Date;
import java.util.Vector;

public class Sector {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    long lba_wanted;
    long lba_read;
    String sd_wanted;
    String sd_read;
    long ts;
    int key_wanted;
    int key_read;
    int checksum;
    int different_words_in_sector;
    int different_bits;
    int singlebit_words;
    Date tod_in_sector;
    int[] expected = new int[128];
    int[] was_read = new int[128];
    int[] lfsr_sector;
    int[] re_read;
    boolean lfsr_of_bad_lba_bad = false;

    public int countDifferences() {
        this.different_words_in_sector = 0;
        for (int i = 8; i < this.expected.length; ++i) {
            int n = this.expected[i];
            int n2 = this.was_read[i];
            if (i == 2 || i == 3) continue;
            if (i == 4) {
                n &= 0xFF00FFFF;
                n2 &= 0xFF00FFFF;
            }
            if ((i == 5 || i == 6) && !this.sd_wanted.equals(this.sd_read) || n == n2) continue;
            ++this.different_words_in_sector;
            int n3 = this.countBits(n, n2);
            this.different_bits += n3;
            if (n3 != 1) continue;
            ++this.singlebit_words;
        }
        return this.different_words_in_sector;
    }

    private int countBits(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        for (int i = 0; i < 32; ++i) {
            if ((n4 & 1) != (n5 & 1)) {
                ++n3;
            }
            n4 >>>= 1;
            n5 >>>= 1;
        }
        return n3;
    }

    public void getBadLbaData() {
        this.lfsr_sector = new int[128];
        if (this.sd_read.length() == 0) {
            common.failure("empty 'sd_read'");
        }
        Native.fillLfsrArray(this.lfsr_sector, this.lba_read, this.key_read, Sector.check8byteString(this.sd_read));
        int[] nArray = new int[128];
        System.arraycopy(this.lfsr_sector, 0, nArray, 8, 120);
        this.lfsr_sector = nArray;
        for (int i = 8; i < 128; ++i) {
            if (this.was_read[i] == this.lfsr_sector[i]) continue;
            this.lfsr_of_bad_lba_bad = true;
        }
    }

    public void reReadSector(DvKeyBlock dvKeyBlock) {
        Vector vector = new Vector(64);
        long l = Native.openFile(dvKeyBlock.lun);
        if (l < 0L) {
            common.failure("Can't open disk file");
        }
        long l2 = Native.allocBuffer(512);
        int[] nArray = new int[128];
        common.ptod("lba_wanted: " + this.lba_wanted);
        common.ptod("bkb.file_start_lba: " + dvKeyBlock.file_start_lba);
        long l3 = Native.readFile(l, this.lba_wanted - dvKeyBlock.file_start_lba, 512L, l2);
        if (l3 != 0L) {
            common.failure("Error reading block");
        }
        Native.closeFile(l);
        Native.buffer_to_array(nArray, l2, 512);
        Native.freeBuffer(512, l2);
        int[] nArray2 = new int[128];
        System.arraycopy(nArray, 0, nArray2, 8, nArray.length);
        this.re_read = nArray2;
    }

    public static String check8byteString(String string) {
        int n;
        String string2 = (string + "        ").substring(0, 8);
        String string3 = "";
        for (n = 0; n < string2.length(); ++n) {
            string3 = string3 + String.format("%02x", string2.charAt(n));
        }
        for (n = 0; n < string2.trim().length(); ++n) {
            char c = string2.charAt(n);
            if (Character.isLetterOrDigit(c)) continue;
            return "garbage ";
        }
        if (string2.trim().length() == 0) {
            return "garbageb ";
        }
        String string4 = (string2 + "        ").substring(0, 8);
        if (string2.trim().length() == 0) {
            string2 = "blanks  ";
        }
        return string4;
    }
}

