/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BoxPrint;
import Vdb.CpuStats;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwdStats;
import Vdb.Host;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.Report;
import Vdb.ReportData;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.SdSort;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WD_entry;
import Vdb.common;
import java.io.PrintWriter;
import java.util.Arrays;

public class SkewReport {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static int label_length = 0;
    private static String type_mask = null;
    private static boolean warning_done = false;

    private static void printRawHeaders(Object object) {
        String[] stringArray = SkewReport.getRawHeaders(object);
        SkewReport.ptodOrFile("", new Object[0]);
        SkewReport.ptodOrFile(stringArray[0], new Object[0]);
        SkewReport.ptodOrFile(stringArray[1], new Object[0]);
    }

    private static void printRawHeadersExtra(Object object, String string, String string2) {
        String[] stringArray = SkewReport.getRawHeaders(object);
        SkewReport.ptodOrFile("", new Object[0]);
        SkewReport.ptodOrFile(stringArray[0] + " " + string, new Object[0]);
        SkewReport.ptodOrFile(stringArray[1] + " " + string2, new Object[0]);
    }

    private static String[] getRawHeaders(Object object) {
        if (!warning_done) {
            SkewReport.ptodOrFile("", new Object[0]);
            SkewReport.ptodOrFile("Counts reported below are for non-warmup intervals.", new Object[0]);
            warning_done = true;
        }
        label_length = 0;
        label_length = Math.max(label_length, SD_entry.max_sd_name);
        label_length = Math.max(label_length, WD_entry.max_wd_name);
        label_length = Math.max(label_length, Slave.max_slave_name);
        label_length = Math.max(label_length, Host.max_host_name);
        String string = null;
        if (object instanceof SD_entry) {
            string = "SD:";
        } else if (object instanceof WD_entry) {
            string = "WD:";
        } else if (object instanceof Slave) {
            string = "Slave:";
        } else if (object instanceof Host) {
            string = "Host:";
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            common.failure("Unknown Object type: " + object);
        }
        type_mask = "%-" + label_length + "s ";
        String string2 = type_mask + "%10s %8s %7s %6s %8s %8s %8s %8s %8s %5s ";
        String string3 = String.format(string2, "", "i/o", "MB/sec", "bytes", "read", "resp", "read", "write", "resp", "resp", "queue");
        String string4 = String.format(string2, string, "rate", "1024**2", "i/o", "pct", "time", "resp", "resp", "max", "stddev", "depth");
        String[] stringArray = new String[]{string3, string4};
        return stringArray;
    }

    private static void printFileHeaders(String string) {
        SkewReport.ptodOrFile("", new Object[0]);
        SkewReport.ptodOrFile("%-12s %s", "", FwdStats.getShortHeader1());
        SkewReport.ptodOrFile("%-12s %s", string, FwdStats.getShortHeader2());
    }

    public static void reportRaw(Object object, SdStats sdStats) {
        SkewReport.ptodOrFile(SkewReport.createRawLine(object, sdStats), new Object[0]);
    }

    public static void reportExtra(Object object, SdStats sdStats, String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            SkewReport.ptodOrFile(SkewReport.createRawLine(object, sdStats) + " " + string, new Object[0]);
        } else {
            SkewReport.ptodOrFile(SkewReport.createRawLine(object, sdStats) + " " + String.format(string, objectArray), new Object[0]);
        }
    }

    private static String createRawLine(Object object, SdStats sdStats) {
        String string = null;
        if (object instanceof SD_entry) {
            string = ((SD_entry)object).sd_name;
        } else if (object instanceof WD_entry) {
            string = ((WD_entry)object).wd_name;
        } else if (object instanceof Slave) {
            string = ((Slave)object).getLabel();
        } else if (object instanceof Host) {
            string = ((Host)object).getLabel();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            common.failure("Unknown Object type: " + object);
        }
        String string2 = type_mask + "%10.2f %8.2f %7d %6.2f %8.3f %8.3f %8.3f %8.3f %8.3f %5.1f ";
        String string3 = String.format(string2, string, sdStats.rate(), sdStats.megabytes(), sdStats.bytes(), sdStats.readpct(), sdStats.respTime(), sdStats.readResp(), sdStats.writeResp(), sdStats.respMax(), sdStats.resptime_std(), sdStats.qdepth());
        return string3;
    }

    private static void printFileLine(Object object, FwdStats fwdStats) {
        String string = null;
        if (object instanceof FsdEntry) {
            string = ((FsdEntry)object).name;
        } else if (object instanceof WD_entry) {
            string = ((FwdEntry)object).fwd_name;
        } else if (object instanceof Slave) {
            string = ((Slave)object).getLabel();
        } else if (object instanceof Host) {
            string = ((Host)object).getLabel();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            common.failure("Unknown Object type: " + object);
        }
        String string2 = Report.getAvgLabel();
        String string3 = fwdStats.printShortLine(null, null, string2);
        SkewReport.ptodOrFile("%-12s %s", string, string3);
    }

    public static void endOfRawRunSkewCheck(RD_entry rD_entry) {
        long l = 0L;
        double d = 0.0;
        String string = null;
        int n = 0;
        boolean bl = false;
        for (WD_entry object2 : rD_entry.wds_for_rd) {
            l += object2.total_io_done;
            if (object2.wd_is_used) {
                ++n;
            }
            if (!(object2.wd_iorate > 0.0)) continue;
            bl = true;
        }
        if (n == 0) {
            return;
        }
        if (rD_entry.wds_for_rd.size() > 1) {
            SkewReport.ptodOrFile("", new Object[0]);
            SkewReport.ptodOrFile("Calculated versus requested workload skew. (Delta only shown if > 0.10% absolute)", new Object[0]);
            if (rD_entry.areWeSharingThreads()) {
                if (rD_entry.current_override.threads_before_override == 0.0) {
                    SkewReport.ptodOrFile("Number of shared threads: %d", (int)rD_entry.current_override.getThreads());
                } else {
                    SkewReport.ptodOrFile("Shared thread count overridden from %d to %d", (int)rD_entry.current_override.threads_before_override, (int)rD_entry.current_override.getThreads());
                }
            }
            SkewReport.ptodOrFile("Note that for an Uncontrolled MAX run workload skew is irrelevant.", new Object[0]);
            if (!rD_entry.use_waiter) {
                SkewReport.ptodOrFile("This was an Uncontrolled MAX run.", new Object[0]);
            }
            String string2 = String.format("%9s %8s %7s ", "skew", "skew", "skew");
            String string3 = String.format("%9s %8s %7s ", "requested", "observed", "delta");
            SkewReport.printRawHeadersExtra(new WD_entry(), string2, string3);
        }
        int n2 = Report.getInterval() - Reporter.first_elapsed_interval + 1;
        String string4 = String.format("wd=%%-%ds ", WD_entry.max_wd_name);
        double d2 = 0.0;
        if (l > 0L) {
            for (int d6 = 0; d6 < rD_entry.wds_for_rd.size(); ++d6) {
                WD_entry wD_entry = rD_entry.wds_for_rd.elementAt(d6);
                double d3 = (double)wD_entry.total_io_done * 100.0 / (double)l;
                double d4 = Math.abs((double)wD_entry.total_io_done * 100.0 / (double)l - wD_entry.getSkew());
                d2 += wD_entry.getSkew();
                if (rD_entry.wds_for_rd.size() > 1) {
                    SdStats sdStats = Report.getReport(wD_entry.wd_name).getData().getTotalSdStats();
                    double d5 = wD_entry.getSkew() - d3;
                    SkewReport.reportExtra(wD_entry, sdStats, "%8.2f%% %7.2f%% %s", wD_entry.getSkew(), d3, Math.abs(d5) < 0.1 ? "" : String.format("%6.2f%%", d5));
                }
                if (d4 > d) {
                    d = d4;
                    string = wD_entry.wd_name;
                }
                if (!rD_entry.doing_curve_max) continue;
                wD_entry.valid_skew_obs = false;
                if (rD_entry.use_waiter) continue;
                wD_entry.valid_skew_obs = true;
                wD_entry.skew_observed = d3;
            }
            if (rD_entry.wds_for_rd.size() > 1) {
                SdStats sdStats = Report.getSummaryReport().getData().getTotalSdStats();
                SkewReport.reportExtra("Total", sdStats, "%8.2f%% %7.2f%%", 100.0, d2);
            }
        }
        if (!ReplayInfo.isReplay() && d > 1.0 && rD_entry.use_waiter && !bl) {
            BoxPrint boxPrint = new BoxPrint();
            boxPrint.add("Observed Workload skew for wd=%s delta greater than 1%% (%.2f). See skew.html for details", string, d);
            boxPrint.printSumm();
            boxPrint.clear();
            boxPrint.add("Possible reasons for workload skew being out of sync:", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("- Elapsed time too short.  ", new Object[0]);
            boxPrint.add("  Each SD should have done at least 2000 i/o's. Adding 'warmup=nn' may help this.", new Object[0]);
            boxPrint.add("  For SD concatenation this is the ONLY acceptable reason. Contact me at the Oracle Vdbench Forum if the differences are too big.", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("- A mix of seekpct=seq and random workloads. ", new Object[0]);
            boxPrint.add("  Sequential workloads may run on only ONE slave, but random workloads", new Object[0]);
            boxPrint.add("  may run on multiple slaves. Workload skew depends on ALL workloads", new Object[0]);
            boxPrint.add("  running on all slaves. Force slave count to just one. (hd=default,jvms=1)", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("- Not enough threads available to guarantee that all workloads can run", new Object[0]);
            boxPrint.add("  on all slaves.", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("- There may be more, can't think (of any) right now. :-)", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("You may use 'abort_failed_skew=nn' for Vdbench to abort after skew failures. See documentation.", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.print();
        }
        double d6 = Validate.getSkewAbort();
        if (!ReplayInfo.isReplay() && d > d6) {
            common.failure("'abort_failed_skew=%.3f' parameter used. See file skew.html for more info.", d6);
        }
    }

    public static void reportRawEndOfRunSkew(RD_entry rD_entry) {
        try {
            long l = 0L;
            for (WD_entry cloneable2 : rD_entry.wds_for_rd) {
                l += cloneable2.total_io_done;
            }
            if (SlaveList.getSlaveCount() > 1) {
                for (Host host : Host.getDefinedHosts()) {
                    if (!host.anyWork()) continue;
                    SkewReport.printRawHeaders("Slave:");
                    for (Slave slave : host.getSlaves()) {
                        SkewReport.reportRaw(slave, slave.getSummaryReport().getData().getTotalSdStats());
                    }
                    SkewReport.reportRaw("Total", host.getSummaryReport().getData().getTotalSdStats());
                }
            }
            if (Host.getDefinedHosts().size() > 1) {
                if (CpuStats.isCpuReporting()) {
                    SkewReport.printRawHeadersExtra("Host:", "  cpu", "sys+u");
                } else {
                    SkewReport.printRawHeaders("Host:");
                }
                for (Host host : Host.getDefinedHosts()) {
                    if (!host.anyWork()) continue;
                    if (CpuStats.isCpuReporting()) {
                        SkewReport.reportExtra(host, host.getSummaryReport().getData().getTotalSdStats(), "%5.1f", host.getSummaryReport().getData().getTotalCpuStats().getBoth());
                        continue;
                    }
                    SkewReport.reportRaw(host, host.getSummaryReport().getData().getTotalSdStats());
                }
                if (CpuStats.isCpuReporting()) {
                    SkewReport.reportExtra("Total", Report.getSummaryReport().getData().getTotalSdStats(), "%5.1f", Report.getSummaryReport().getData().getTotalCpuStats().getBoth());
                } else {
                    SkewReport.reportRaw("Total", Report.getSummaryReport().getData().getTotalSdStats());
                }
            }
            int n = 0;
            SD_entry[] sD_entryArray = Vdbmain.sd_list.toArray(new SD_entry[0]);
            Arrays.sort(sD_entryArray, new SdSort());
            for (SD_entry sD_entry : sD_entryArray) {
                if (sD_entry.concatenated_sd) continue;
                ++n;
            }
            SkewReport.printRawHeaders("SD:");
            for (SD_entry sD_entry : sD_entryArray) {
                if (sD_entry.concatenated_sd || !sD_entry.sd_is_referenced) continue;
                SkewReport.reportRaw(sD_entry, Report.getReport(sD_entry.sd_name).getData().getTotalSdStats());
            }
            SkewReport.reportRaw("Total", Report.getSummaryReport().getData().getTotalSdStats());
        }
        catch (Exception exception) {
            common.ptod("Exception while doing skew reporting. Exception ignored, but please report it to me");
            common.ptod(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reportFileEndOfRunSkew(RD_entry rD_entry) {
        try {
            void var4_15;
            long l = 0L;
            for (FwdEntry cloneable : rD_entry.fwds_for_rd) {
                ReportData reportData = Report.getReport(cloneable.fwd_name).getData();
                l = (long)((double)l + reportData.getTotalFwdStats().getReqstdRate());
            }
            if (SlaveList.getSlaveCount() > 1) {
                for (Host host : Host.getDefinedHosts()) {
                    if (!host.anyWork()) continue;
                    SkewReport.printFileHeaders("Slave:");
                    for (Slave slave : host.getSlaves()) {
                        SkewReport.printFileLine(slave, slave.getSummaryReport().getData().getTotalFwdStats());
                    }
                    if (host.getSlaves().size() <= 1) continue;
                    SkewReport.printFileLine("Total", host.getSummaryReport().getData().getTotalFwdStats());
                }
            }
            SkewReport.printFileHeaders("Host:");
            for (Host host : Host.getDefinedHosts()) {
                if (!host.anyWork()) continue;
                SkewReport.printFileLine(host, host.getSummaryReport().getData().getTotalFwdStats());
            }
            if (Host.getDefinedHosts().size() > 1) {
                SkewReport.printFileLine("Total", Report.getSummaryReport().getData().getTotalFwdStats());
            }
            SkewReport.printFileHeaders("FSD:");
            for (FsdEntry fsdEntry : FsdEntry.getFsdList()) {
                if (!fsdEntry.in_use) continue;
                SkewReport.printFileLine(fsdEntry.name, Report.getReport(fsdEntry.name).getData().getTotalFwdStats());
            }
            if (FsdEntry.getFsdList().size() > 1) {
                SkewReport.printFileLine("Total", Report.getSummaryReport().getData().getTotalFwdStats());
            }
            if (!rD_entry.fwds_for_rd.get((int)0).fwd_name.equals("format")) {
                SkewReport.printFileHeaders("FWD:");
                for (FwdEntry fwdEntry : rD_entry.fwds_for_rd) {
                    SkewReport.printFileLine(fwdEntry.fwd_name, Report.getReport(fwdEntry.fwd_name).getData().getTotalFwdStats());
                }
                if (rD_entry.fwds_for_rd.size() > 1) {
                    SkewReport.printFileLine("Total", Report.getSummaryReport().getData().getTotalFwdStats());
                }
            }
            int n = 0;
            boolean bl = false;
            double d = 0.0;
            double d2 = 0.0;
            for (FwdEntry fwdEntry : rD_entry.fwds_for_rd) {
                d += fwdEntry.skew;
                if (fwdEntry.skew == 0.0) {
                    ++var4_15;
                    continue;
                }
                ++n;
            }
            d2 = (100.0 - d) / (double)var4_15;
            if (n == 0 || rD_entry.fwds_for_rd.get((int)0).fwd_name.equals("format")) {
                return;
            }
            if (rD_entry.fwds_for_rd.size() > 1) {
                double d3 = 0.0;
                FwdEntry fwdEntry = null;
                SkewReport.ptodOrFile("", new Object[0]);
                SkewReport.ptodOrFile("FWD skew requested vs. actual (Use 'abort_failed_skew=n.n' to abort when delta > n.n)", new Object[0]);
                SkewReport.ptodOrFile("%-12s %7s %10s %7s %7s", "FWD", "ops/sec", "requested", "actual", "delta");
                for (FwdEntry fwdEntry2 : rD_entry.fwds_for_rd) {
                    double d4;
                    double d5 = Report.getReport(fwdEntry2.fwd_name).getData().getTotalFwdStats().getReqstdRate();
                    double d6 = d5 * 100.0 / (double)l;
                    double d7 = d6 - (d4 = fwdEntry2.skew != 0.0 ? fwdEntry2.skew : d2);
                    if (Math.abs(d7) >= d3) {
                        fwdEntry = fwdEntry2;
                        d3 = Math.abs(d7);
                    }
                    SkewReport.ptodOrFile("%-12s %7.0f %9.2f%% %6.2f%% %+6.2f%%", fwdEntry2.fwd_name, d5, d4, d6, d7);
                }
                if (d3 > 1.0) {
                    BoxPrint boxPrint = new BoxPrint();
                    boxPrint.add("Observed Workload skew for fwd=%s delta greater than 1%% (%.2f). See skew.html for details", fwdEntry.fwd_name, d3);
                    boxPrint.printSumm();
                    boxPrint.clear();
                    boxPrint.add("Possible reasons for workload skew being out of sync:", new Object[0]);
                    boxPrint.add("", new Object[0]);
                    boxPrint.add("- Elapsed time too short.  ", new Object[0]);
                    boxPrint.add("  Each FSD should have done at least 2000 operations. Adding 'warmup=nn' may help this.", new Object[0]);
                    boxPrint.add("", new Object[0]);
                    boxPrint.add("- Not enough threads available to guarantee that all workloads can run on all slaves.", new Object[0]);
                    boxPrint.add("", new Object[0]);
                    boxPrint.add("- There may be more, can't think (of any) right now. :-)", new Object[0]);
                    boxPrint.add("  Contact me at the Oracle Vdbench Forum if the differences are out of line.", new Object[0]);
                    boxPrint.add("", new Object[0]);
                    boxPrint.add("You may use 'abort_failed_skew=nn' for Vdbench to abort after skew failures. See documentation.", new Object[0]);
                    boxPrint.add("", new Object[0]);
                    boxPrint.print();
                    double d8 = Validate.getSkewAbort();
                    if (d3 > d8) {
                        common.failure("'abort_failed_skew=%.3f' parameter used. See file skew.html for more info.", d8);
                    }
                }
            }
        }
        catch (Exception exception) {
            common.ptod("Exception while doing skew reporting. Exception ignored, but please report it to me");
            common.ptod(exception);
        }
    }

    public static void ptodOrFile(String string, Object ... objectArray) {
        String string2;
        PrintWriter printWriter = Report.getReport("skew").getWriter();
        String string3 = string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
        if (common.get_debug(common.SKEW_ON_CONSOLE)) {
            common.ptod(string2);
            common.ptod(string2, printWriter);
        } else {
            common.ptod(string2, printWriter);
        }
    }
}

