/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.FsdEntry;
import Vdb.FwgEntry;
import Vdb.Host;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.SlaveList;
import Vdb.SlaveSocket;
import Vdb.SlaveStarter;
import Vdb.Status;
import Vdb.ThreadMonData;
import Vdb.ThreadMonList;
import Vdb.ThreadMonitor;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.Work;
import Vdb.common;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class Slave {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private int slave_jvmno;
    private String slave_name;
    private String slave_label;
    private int slave_number;
    private Host host;
    private SlaveSocket slave_socket = null;
    private SlaveStarter slave_starter;
    private HashMap<String, String> anchors_used = new HashMap(16);
    private HashMap<String, String> fsds_used = new HashMap(16);
    private boolean seqwork_done = false;
    private boolean connected = false;
    private boolean work_done = false;
    private boolean ready_for_more = false;
    private boolean shut_down = false;
    private boolean aborted = false;
    private boolean ready_to_go = false;
    private boolean structure_pending = false;
    private boolean slave_shutdown_requested = false;
    private boolean slave_has_terminated = false;
    private Report console_log = null;
    private ArrayList<WG_entry> wgs_for_slave = new ArrayList(16);
    private Work current_work = null;
    private HashMap sd_report_map = new HashMap(8);
    private Report summary_report = null;
    public long reads = 0L;
    public long writes = 0L;
    public String abort_msg = null;
    public int threads_given_to_slave = 0;
    private ThreadMonList threadmon_totals = new ThreadMonList();
    private static boolean any_slave_aborted = false;
    public static int max_slave_name = 0;

    public Slave(Host host, int n) {
        this.host = host;
        this.slave_jvmno = n;
        this.slave_label = this.host.getLabel() + "-" + n;
        max_slave_name = Math.max(max_slave_name, this.slave_label.length());
        this.slave_number = SlaveList.getSlaveCount();
        this.slave_name = this.host.getIP() + "-" + (this.slave_number + 10) + "-" + Vdbmain.getRunTime();
        SlaveList.addSlave(this);
        this.host.addSlave(this);
    }

    public void createSummaryFile() {
        Report report = new Report(this.getLabel(), "Slave summary report for slave=" + this.getLabel());
        this.setSummaryReport(report);
        this.createConsoleLog();
        String string = "";
        string = string + Format.f("%-32s", "Link to slave summary report:");
        string = string + " <A HREF=\"" + report.getFileName() + ".html\">" + this.getLabel() + " summary</A>";
        string = string + "  ";
        string = string + " <A HREF=\"" + this.console_log.getFileName() + ".html\">" + this.getLabel() + " stdout</A>";
        this.host.getSummaryReport().println(string);
    }

    public void createConsoleLog() {
        String string = this.getLabel() + ".stdout";
        this.console_log = new Report(string, "stdout/stderr for slave=" + this.getLabel());
        String string2 = "Console log";
        this.getSummaryReport().printHtmlLink(string2, this.console_log.getFileName(), "Slave stdout/stderr");
    }

    public boolean isLocalHost() {
        if (this.host.getIP().equals("localhost")) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            String string2 = InetAddress.getByName(this.host.getIP()).getHostAddress();
            return string.equals(string2);
        }
        catch (UnknownHostException unknownHostException) {
            common.ptod("UnknownHostException: hd=%s,system=%s", this.host.getLabel(), this.host.getIP());
            return false;
        }
    }

    public String getLabel() {
        return this.slave_label;
    }

    public String getName() {
        return this.slave_name;
    }

    public String getSlaveIP() {
        return this.host.getIP();
    }

    public SlaveSocket getSocket() {
        return this.slave_socket;
    }

    public Host getHost() {
        return this.host;
    }

    public void setReadyToGo(boolean bl) {
        this.ready_to_go = bl;
    }

    public boolean isReadyToGo() {
        return this.ready_to_go;
    }

    public void setSlaveSocket(SlaveSocket slaveSocket) {
        this.slave_socket = slaveSocket;
    }

    public void addReport(String string, Report report) {
        this.sd_report_map.put(string, report);
    }

    public Report getReport(String string) {
        Report report = (Report)this.sd_report_map.get(string);
        if (report == null) {
            String[] stringArray = this.sd_report_map.keySet().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                common.ptod("Host reps: " + stringArray[i]);
            }
            common.failure("Requesting an unknown report file: " + string + " for slave=" + this.getLabel());
        }
        return report;
    }

    public Report getConsoleLog() {
        return this.console_log;
    }

    public void set_may_terminate() {
        this.slave_shutdown_requested = true;
    }

    public boolean may_terminate() {
        return this.slave_shutdown_requested;
    }

    public void setTerminated() {
        this.slave_has_terminated = true;
    }

    public boolean hasTerminated() {
        return this.slave_has_terminated;
    }

    public void setCurrentWork(Work work) {
        this.current_work = work;
    }

    public Work getCurrentWork() {
        return this.current_work;
    }

    public int getCurrentFwgWorkSize() {
        if (this.current_work == null) {
            return 0;
        }
        return this.current_work.fwgs_for_slave.size();
    }

    public void setSummaryReport(Report report) {
        this.summary_report = report;
    }

    public Report getSummaryReport() {
        return this.summary_report;
    }

    public boolean isSdReported(String string) {
        return this.sd_report_map.get(string) != null;
    }

    public int getSlaveNumber() {
        return this.slave_number;
    }

    public void setSlaveStarter(SlaveStarter slaveStarter) {
        this.slave_starter = slaveStarter;
    }

    public SlaveStarter getSlaveStarter() {
        return this.slave_starter;
    }

    public void setConnected(String string) {
        this.connected = true;
        common.plog("Slave %s (pid %6s) connected to master %s", this.slave_label, string, common.getProcessIdString());
        Status.printStatus("Slave %s (pid %6s) connected to master %s", this.slave_label, string, common.getProcessIdString());
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isWorkDone() {
        return this.work_done;
    }

    public void setWorkDone(boolean bl) {
        this.work_done = bl;
    }

    public boolean isReadyForMore() {
        return this.ready_for_more;
    }

    public void setReadyForMore(boolean bl) {
        this.ready_for_more = bl;
    }

    public boolean isShutdown() {
        return this.shut_down;
    }

    public void setShutdown(boolean bl) {
        this.shut_down = bl;
    }

    public void setSequentialDone(boolean bl) {
        this.seqwork_done = bl;
    }

    public boolean isSequentialDone() {
        return this.seqwork_done;
    }

    public void setAborted(String string) {
        this.aborted = true;
        any_slave_aborted = true;
        this.abort_msg = string;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public static boolean anyAborted() {
        return any_slave_aborted;
    }

    public boolean isUsingSd(SD_entry sD_entry) {
        for (int i = 0; i < this.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry = this.wgs_for_slave.get(i);
            if (wG_entry.sd_used != sD_entry) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingFsd(FsdEntry fsdEntry) {
        if (this.current_work == null) {
            return false;
        }
        for (FwgEntry fwgEntry : this.current_work.fwgs_for_slave) {
            if (!fwgEntry.fsd_name.equals(fsdEntry.name)) continue;
            return true;
        }
        return false;
    }

    public void addFsdName(String string) {
        this.fsds_used.put(string, string);
    }

    public void addAnchorName(String string) {
        this.anchors_used.put(string, string);
    }

    public String[] getFsdsUsed() {
        return this.fsds_used.keySet().toArray(new String[0]);
    }

    public String[] getAnchorsUsed() {
        return this.anchors_used.keySet().toArray(new String[0]);
    }

    public String toString() {
        return "Slave instance: " + this.getLabel();
    }

    public void setStructurePending(boolean bl) {
        this.structure_pending = bl;
    }

    public boolean getStructurePending() {
        return this.structure_pending;
    }

    public void clearWorkloads() {
        this.wgs_for_slave.clear();
        this.anchors_used.clear();
        this.fsds_used.clear();
    }

    public void addWorkload(WG_entry wG_entry, RD_entry rD_entry) {
        this.wgs_for_slave.add(wG_entry);
    }

    public ArrayList<WG_entry> getWorkloads() {
        WG_entry.sortWorkloads(this.wgs_for_slave, "sd");
        return this.wgs_for_slave;
    }

    public int removeWorkload(WG_entry wG_entry, RD_entry rD_entry) {
        int n = 0;
        for (int i = 0; i < this.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry2 = this.wgs_for_slave.get(i);
            if (!wG_entry2.wd_name.equals(wG_entry.wd_name) || wG_entry2.sd_used != wG_entry.sd_used) continue;
            this.wgs_for_slave.set(i, null);
            ++n;
            RD_entry.printWgInfo("Removed wd=%s,sd=%s from slave=%s", wG_entry2.wd_name, wG_entry2.sd_used.sd_name, this.getLabel());
        }
        while (this.wgs_for_slave.remove(null)) {
        }
        return n;
    }

    public int sequentialFilesOnSlave() {
        int n = 0;
        for (WG_entry wG_entry : this.wgs_for_slave) {
            wG_entry.seq_eof = false;
            if (!(wG_entry.seekpct < 0.0)) continue;
            ++n;
        }
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    public void accumMonData(ThreadMonList threadMonList) {
        if (!Reporter.isWarmupDone()) {
            return;
        }
        for (ThreadMonData threadMonData : threadMonList.list) {
            ThreadMonData threadMonData2 = this.threadmon_totals.map.get(threadMonData.label);
            if (threadMonData2 == null) {
                this.threadmon_totals.map.put(threadMonData.label, threadMonData);
                continue;
            }
            threadMonData2.accum(threadMonData);
        }
        this.threadmon_totals.elapsed += threadMonList.elapsed;
    }

    public ThreadMonList reportThreadMonSlaveTotals() {
        this.threadmon_totals.list = new ArrayList<ThreadMonData>(this.threadmon_totals.map.values());
        ThreadMonitor.reportTotals(this.getLabel(), this.threadmon_totals);
        this.threadmon_totals.map.clear();
        this.threadmon_totals.list.clear();
        return this.threadmon_totals;
    }
}

