/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Vdb.BucketRanges;
import Vdb.ControlFile;
import Vdb.FileAnchor;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwgEntry;
import Vdb.Host;
import Vdb.MiscParms;
import Vdb.Native;
import Vdb.Operations;
import Vdb.Patterns;
import Vdb.RD_entry;
import Vdb.Signal;
import Vdb.Slave;
import Vdb.SlaveSocket;
import Vdb.SlaveStarter;
import Vdb.SocketMessage;
import Vdb.Status;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WhereWhatWork;
import Vdb.Work;
import Vdb.common;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class SlaveList {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static Vector<Slave> slave_list = new Vector(64, 0);
    public static boolean shutdown_requested = false;
    private static int max_label_length = 0;
    private static String label_mask = "%s";

    public static void addSlave(Slave slave) {
        slave_list.add(slave);
        max_label_length = Math.max(max_label_length, slave.getLabel().length());
        label_mask = "%-" + max_label_length + "s";
    }

    public static String getLabelMask() {
        return label_mask;
    }

    public static Slave findSlaveName(String string) {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (!slave.getName().equals(string)) continue;
            return slave;
        }
        return null;
    }

    public static Slave findSlaveLabel(String string) {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (!slave.getLabel().equals(string)) continue;
            return slave;
        }
        common.failure("findSlave() Unable to find slave: " + string);
        return null;
    }

    public static int getSlaveCount() {
        return slave_list.size();
    }

    public static Vector<Slave> getSlaveList() {
        return slave_list;
    }

    public static String[] getSlaveNames() {
        HashMap<String, Slave> hashMap = new HashMap<String, Slave>(64);
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            hashMap.put(slave.getLabel(), slave);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public static void closeAllSlaveSockets() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            SlaveSocket slaveSocket = slave.getSocket();
            common.plog("close socket to " + slave.getLabel());
            slaveSocket.close();
        }
    }

    public static void shutdownAllSlaves() {
        Status.printStatus("Shutting down slaves", new Object[0]);
        shutdown_requested = true;
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            SlaveSocket slaveSocket = slave.getSocket();
            slave.set_may_terminate();
            if (slaveSocket == null) continue;
            slaveSocket.setShutdown(true);
            SocketMessage socketMessage = new SocketMessage(SocketMessage.CLEAN_SHUTDOWN_SLAVE);
            slaveSocket.putMessage(socketMessage);
        }
    }

    public static void sendWorkloadDone() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.getCurrentWork() == null) continue;
            SlaveSocket slaveSocket = slave.getSocket();
            SocketMessage socketMessage = new SocketMessage(SocketMessage.WORKLOAD_DONE);
            slaveSocket.putMessage(socketMessage);
        }
    }

    public static boolean allSequentialDone() {
        boolean bl = false;
        for (Slave slave : slave_list) {
            if (slave.sequentialFilesOnSlave() <= 0) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        for (Slave slave : slave_list) {
            if (slave.sequentialFilesOnSlave() <= 0 || slave.isSequentialDone()) continue;
            return false;
        }
        return true;
    }

    public static void killSlaves() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.isAborted()) continue;
            common.ptod("Slave " + slave.getLabel() + " killed by master");
            slave.setAborted("Killed by master");
            SlaveSocket slaveSocket = slave.getSocket();
            if (slaveSocket != null) {
                SocketMessage socketMessage = new SocketMessage(SocketMessage.MASTER_ABORTING);
                slaveSocket.putMessage(socketMessage);
                slave.set_may_terminate();
                slaveSocket.setShutdown(true);
                continue;
            }
            slave.set_may_terminate();
        }
    }

    public static void allDead() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (!slave.hasTerminated()) {
                return;
            }
            if (slave.isAborted()) continue;
            return;
        }
        common.failure("All slaves have aborted. Run cancelled");
    }

    public static void waitForSlaveWorkCompletion() {
        boolean bl;
        Slave slave = null;
        Signal signal = new Signal(30);
        Signal signal2 = new Signal(360);
        do {
            bl = false;
            for (int i = 0; i < slave_list.size(); ++i) {
                slave = slave_list.elementAt(i);
                if (slave.getCurrentWork() == null || slave.isReadyForMore()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            if (signal2.go()) {
                common.failure("SlaveList.waitForSlaveWorkCompletion(). Giving up after %d seconds ", signal2.getDuration());
            }
            common.sleep_some(100L);
            if (!signal.go()) continue;
            common.ptod("SlaveList.waitForSlaveWorkCompletion(): " + slave.getLabel());
        } while (bl);
    }

    public static boolean allSlaveWorkDone() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.getCurrentWork() == null || slave.isWorkDone()) continue;
            return false;
        }
        return true;
    }

    public static void waitForAllSlavesShutdown() {
        boolean bl;
        Signal signal = new Signal(300);
        Signal signal2 = new Signal(5);
        do {
            bl = false;
            for (int i = 0; i < slave_list.size(); ++i) {
                Slave slave = slave_list.elementAt(i);
                if (slave.isShutdown()) continue;
                bl = true;
                common.sleep_some(100L);
                if (signal2.go()) {
                    common.ptod("Waiting for slave shutdown: " + slave.getLabel());
                }
                if (!signal.go()) continue;
                common.failure("Waited %d seconds for all slaves to shut down. Giving up.", signal.getDuration());
            }
        } while (bl);
    }

    public static void startSlaves() {
        Object[] objectArray = SlaveList.getSlaveNames();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            Slave slave = SlaveList.findSlaveLabel((String)object);
            SlaveStarter slaveStarter = new SlaveStarter();
            slave.setSlaveStarter(slaveStarter);
            slaveStarter.setSlave(slave);
            slaveStarter.start();
            common.sleep_some(20L);
        }
        Status.printStatus("Starting slaves", new Object[0]);
    }

    public static void stopSlaveStarters() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            SlaveStarter slaveStarter = slave.getSlaveStarter();
            common.interruptThread(slaveStarter);
        }
    }

    public static boolean waitForConnections() {
        boolean bl = false;
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.isConnected()) continue;
            bl = true;
        }
        if (bl) {
            return false;
        }
        common.ptod("All slaves are now connected");
        return true;
    }

    public static void displayConnectWait() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.isConnected()) continue;
            common.ptod("Waiting for slave connection: " + slave.getLabel());
        }
    }

    public static void AddFwgsToSlave(Slave slave, Vector vector, RD_entry rD_entry, boolean bl) {
        Work work = slave.getCurrentWork();
        if (work == null) {
            work = new Work();
            slave.setCurrentWork(work);
            work.fwd_rate = rD_entry.fwd_rate;
            work.format_run = rD_entry.isThisFormatRun();
            work.format_flags = rD_entry.format;
            work.force_fsd_cleanup = Vdbmain.force_fsd_cleanup;
            work.maximum_xfersize = FileAnchor.getLargestXfersize();
            work.validate_options = Validate.getOptions();
            work.pattern_options = Patterns.getOptions();
            Validate.setCompressionRatio(rD_entry.compression_ratio_to_use);
            work.distribution = rD_entry.distribution;
            work.fwgs_for_slave = new Vector(8, 0);
            work.rd_start_command = rD_entry.start_cmd;
            work.rd_end_command = rD_entry.end_cmd;
            work.work_rd_name = rD_entry.rd_name + " " + rD_entry.current_override.getText();
            work.rd_mount = rD_entry.rd_mount;
            work.bucket_types = BucketRanges.getBucketTypes();
            work.miscellaneous = MiscParms.getMiscellaneous();
            work.nw_monitor_needed = Operations.isOperationUsed(Operations.PUT) || Operations.isOperationUsed(Operations.GET);
            work.nw_monitor_now = rD_entry.getOrPutUsed();
        }
        String string = "slv=%-" + Slave.max_slave_name + "s ";
        String string2 = "fwd=%-" + FwdEntry.max_fwd_name + "s ";
        String string3 = "fsd=%-" + FsdEntry.max_fsd_name + "s ";
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = (FwgEntry)vector.elementAt(i);
            if (!fwgEntry.host_name.equals(slave.getHost().getLabel())) continue;
            work.fwgs_for_slave.add(fwgEntry);
            slave.addFsdName(fwgEntry.fsd_name);
            if (!bl) continue;
            common.plog(string + string2 + string3 + "anchor=%s threads=%2d skew=%5.2f operation=%s ", slave.getLabel(), fwgEntry.fwd_used.fwd_name, fwgEntry.fsd_name, fwgEntry.anchor.getAnchorName(), fwgEntry.threads, fwgEntry.skew, Operations.getOperationText(fwgEntry.getOperation()));
        }
        if (work.nw_monitor_needed && (slave.getHost().getSlaves().size() > 1 || Host.getHostNames().length > 1)) {
            common.failure("'cloud' currently only allowed for ONE host, ONE slave, ONE Fsd, ONE Fwd");
        }
        if (work != null) {
            work.keep_controlfile = work.format_run ? false : ControlFile.keepControlFile(work.fwgs_for_slave);
        }
        if (slave.equals(slave.getHost().getFirstSlave()) && slave.getHost().getHostInfo().isSolaris()) {
            work.instance_pointers = slave.getHost().getHostInfo().getInstancePointers();
        }
    }

    public static void adjustSkew() {
        Slave slave;
        int n;
        int n2 = 0;
        for (n = 0; n < slave_list.size(); ++n) {
            slave = slave_list.elementAt(n);
            if (slave.getCurrentWork() == null) continue;
            ++n2;
        }
        for (n = 0; n < slave_list.size(); ++n) {
            slave = slave_list.elementAt(n);
            if (slave.getCurrentWork() == null) continue;
            slave.getCurrentWork().fwd_rate /= (double)n2;
        }
    }

    public static String hostsMustmatch(FileAnchor fileAnchor, Vector vector) {
        FwgEntry fwgEntry = (FwgEntry)vector.firstElement();
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry2 = (FwgEntry)vector.elementAt(i);
            if (fwgEntry.host_name.equals(fwgEntry2.host_name)) continue;
            common.ptod("fwg0.host_name: " + fwgEntry.host_name);
            common.ptod("fwg0.host_name: " + fwgEntry.host_name);
            common.ptod("fwg0:           " + fwgEntry.getName());
            common.ptod("fwg:            " + fwgEntry2.getName());
            common.failure("All fwd= workloads using anchor=" + fileAnchor.getAnchorName() + " must target the same host");
        }
        return fwgEntry.host_name;
    }

    public static void sendWorkToSlaves(RD_entry rD_entry) {
        WhereWhatWork.checkWorkForSlave0(rD_entry);
        WhereWhatWork.paranoiaDvCheck();
        WhereWhatWork.rememberWhereDvWent();
        int n = 0;
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.getCurrentWork() == null) continue;
            Work work = slave.getCurrentWork();
            work.slave_count = slave_list.size();
            work.slave_number = slave.getSlaveNumber();
            SocketMessage socketMessage = new SocketMessage(SocketMessage.WORK_TO_SLAVE, work);
            slave.setWorkDone(false);
            slave.setReadyToGo(false);
            slave.setReadyForMore(false);
            slave.getSocket().putMessage(socketMessage);
            ++n;
        }
        if (n == 0) {
            common.failure("sendWorkToSlaves(): no work sent to any slave for rd=" + rD_entry.rd_name);
        }
    }

    public static int countSlavesWithWork(RD_entry rD_entry) {
        int n = 0;
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.getCurrentWork() == null) continue;
            ++n;
        }
        return n;
    }

    public static void waitForSlavesReadyToGo() {
        int n = common.get_debug(common.FAST_SYNCTIME) ? 1 : 30;
        Signal signal = new Signal(n);
        while (true) {
            boolean bl = signal.go();
            boolean bl2 = false;
            for (int i = 0; i < slave_list.size(); ++i) {
                Slave slave = slave_list.elementAt(i);
                if (slave.getCurrentWork() == null || slave.isReadyToGo()) continue;
                bl2 = true;
                if (!bl) continue;
                String string = "Waiting for slave synchronization: " + slave.getLabel();
                if (slave.getStructurePending()) {
                    string = string + ". Building and validating file structure(s).";
                }
                common.ptod(string);
            }
            if (!bl2) {
                return;
            }
            common.sleep_some(100L);
        }
    }

    public static void tellSlavesToGo() {
        for (int i = 0; i < slave_list.size(); ++i) {
            Slave slave = slave_list.elementAt(i);
            if (slave.getCurrentWork() == null) continue;
            slave.getSocket().putMessage(new SocketMessage(SocketMessage.SLAVE_GO));
        }
    }

    public static void stopAllWork() {
        for (Slave slave : slave_list) {
            if (slave.getCurrentWork() == null) continue;
            slave.getSocket().putMessage(new SocketMessage(SocketMessage.STOP_NEW_IO));
        }
    }

    public static void externalSynchronize() {
        String string = "external_synch.";
        String string2 = "external_synch.txt";
        if (common.get_debug(common.EXTERNAL_SYNCH)) {
            Fput fput = new Fput(string + Native.getSolarisPids());
            fput.close();
            common.pboth("Waiting for external synchronization.", new Object[0]);
            Signal signal = new Signal(900);
            while (true) {
                if (signal.go()) {
                    common.failure("Someone left Vdbench out to dry when using the 'EXTERNAL_SYNCH' option, which has a timeout of %d seconds", signal.getDuration());
                }
                if (new File(string2).exists()) {
                    common.pboth("External synchronization complete.", new Object[0]);
                    break;
                }
                common.sleep_some(100L);
            }
        }
    }
}

