/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.AnchorReport;
import Vdb.BoxPrint;
import Vdb.CollectSlaveStats;
import Vdb.ErrorLog;
import Vdb.Host;
import Vdb.InfoFromHost;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.SlaveSocket;
import Vdb.SlaveStats;
import Vdb.SocketMessage;
import Vdb.Status;
import Vdb.ThreadControl;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.Vector;

public class SlaveOnMaster
extends ThreadControl {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private SlaveSocket socket_to_slave;
    private Slave slave;

    public void setSocket(SlaveSocket slaveSocket) {
        this.socket_to_slave = slaveSocket;
    }

    @Override
    public void run() {
        this.setName("SlaveOnMaster");
        try {
            Thread.currentThread().setPriority(10);
            this.processSlave();
            if (this.slave == null) {
                common.plog("SlaveOnMaster terminating. No proper slave identification.");
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSlave() {
        this.setIndependent();
        try {
            String string = this.signonSlave();
            if (string == null) {
                this.socket_to_slave.close();
                return;
            }
            this.slave.setConnected(string);
            block5: while (true) {
                Object object;
                if (this.slave.isAborted()) {
                    SlaveList.killSlaves();
                    break;
                }
                SlaveSocket slaveSocket = this.slave.getSocket();
                SocketMessage socketMessage = slaveSocket.getMessage();
                if (socketMessage == null) break;
                int n = socketMessage.getMessageNum();
                if (n == SocketMessage.WORK_TO_SLAVE) continue;
                if (n == SocketMessage.SLAVE_STATISTICS) {
                    CollectSlaveStats.receiveStats(this.slave, (SlaveStats)socketMessage.getData());
                    continue;
                }
                if (n == SocketMessage.SLAVE_ABORTING) {
                    object = (String)socketMessage.getData();
                    BoxPrint.printOne("Slave " + this.slave.getLabel() + " aborting: " + (String)object, new Object[0]);
                    this.slave.setAborted((String)object);
                    SlaveList.killSlaves();
                    break;
                }
                if (n == SocketMessage.SLAVE_WORK_COMPLETED) {
                    this.slave.setWorkDone(true);
                    if (!SlaveList.allSlaveWorkDone()) continue;
                    Vdbmain.setWorkloadDone(true);
                    continue;
                }
                if (n == SocketMessage.READY_FOR_MORE_WORK) {
                    this.slave.setReadyForMore(true);
                    continue;
                }
                if (n == SocketMessage.SLAVE_REACHED_EOF) {
                    this.slave.setSequentialDone(true);
                    if (!SlaveList.allSequentialDone()) continue;
                    common.ptod("All sequential workloads on all slaves are done.");
                    common.ptod("This triggers end of run inspite of possibly some non-sequential workloads that are still running.");
                    continue;
                }
                if (n == SocketMessage.GET_LUN_INFO_FROM_SLAVE) {
                    ((InfoFromHost)socketMessage.getData()).receiveInfoFromHost();
                    continue;
                }
                if (n == SocketMessage.SLAVE_READY_TO_GO) {
                    this.slave.setReadyToGo(true);
                    continue;
                }
                if (n == SocketMessage.ERROR_MESSAGE) {
                    if (socketMessage.getData() instanceof String) {
                        ErrorLog.ptod(this.slave.getLabel() + ": " + (String)socketMessage.getData(), new Object[0]);
                        continue;
                    }
                    ErrorLog.ptodSlave(this.slave, (Vector)socketMessage.getData());
                    continue;
                }
                if (n == SocketMessage.ONE_TIME_STATUS) {
                    Status.printOne((String)socketMessage.getData());
                    continue;
                }
                if (n == SocketMessage.ERROR_LOG_MESSAGE) {
                    if (socketMessage.getData() instanceof String) {
                        ErrorLog.plog(this.slave.getLabel() + ": " + (String)socketMessage.getData(), new Object[0]);
                        continue;
                    }
                    common.failure("ERROR_LOG_MESSAGE tbd");
                    continue;
                }
                if (n == SocketMessage.CONSOLE_MESSAGE) {
                    if (socketMessage.getData() instanceof String) {
                        common.ptod(this.slave.getLabel() + ": " + (String)socketMessage.getData());
                        continue;
                    }
                    object = common.ptod_lock;
                    synchronized (object) {
                        Vector vector = (Vector)socketMessage.getData();
                        common.ptod("");
                        common.ptod("Message from slave " + this.slave.getLabel() + ": ");
                        for (int i = 0; i < vector.size(); ++i) {
                            common.ptod(vector.elementAt(i));
                        }
                    }
                }
                if (n == SocketMessage.SUMMARY_MESSAGE) {
                    common.psum(this.slave.getLabel() + ": " + (String)socketMessage.getData());
                    common.ptod(this.slave.getLabel() + ": " + (String)socketMessage.getData());
                    continue;
                }
                if (n == SocketMessage.ADM_MESSAGES) {
                    object = (Vector)socketMessage.getData();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= ((Vector)object).size()) continue block5;
                        this.slave.getHost().writeAdmMessagesFile((String)((Vector)object).elementAt(n2));
                        ++n2;
                    }
                }
                if (n == SocketMessage.COUNT_ERRORS) {
                    ErrorLog.countErrorsOnMaster(this.slave.getLabel(), (Integer)socketMessage.getData());
                    continue;
                }
                if (n == SocketMessage.HEARTBEAT_MESSAGE) continue;
                if (n == SocketMessage.CLEAN_SHUTDOWN_COMPLETE) {
                    this.slave.setShutdown(true);
                    break;
                }
                if (n == SocketMessage.STARTING_FILE_STRUCTURE) {
                    this.slave.setStructurePending(true);
                    continue;
                }
                if (n == SocketMessage.ENDING_FILE_STRUCTURE) {
                    this.slave.setStructurePending(false);
                    continue;
                }
                if (n == SocketMessage.ANCHOR_SIZES) {
                    ((AnchorReport)socketMessage.getData()).printNumbers();
                    continue;
                }
                if (n == SocketMessage.STOP_NEW_IO) {
                    SlaveList.stopAllWork();
                    continue;
                }
                common.failure("unexpected message from slave: " + socketMessage.getMessageText());
            }
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.failure(exception);
        }
        this.removeIndependent();
    }

    public String signonSlave() {
        SocketMessage socketMessage = new SocketMessage(SocketMessage.SEND_SIGNON_INFO_TO_MASTER);
        socketMessage.setData(new Integer(common.getProcessId()));
        this.socket_to_slave.putMessage(socketMessage);
        socketMessage = this.socket_to_slave.getMessage();
        if (socketMessage.getMessageNum() != SocketMessage.SEND_SIGNON_INFO_TO_MASTER) {
            common.ptod("Killing Slave; wrong message received: " + socketMessage.getMessageNum());
            this.killSlaveSignonError();
            return null;
        }
        if (!(socketMessage.getData() instanceof String[])) {
            common.ptod("Killing Slave; no String[] array received");
            this.killSlaveSignonError();
            return null;
        }
        String[] stringArray = (String[])socketMessage.getData();
        if (stringArray.length != SocketMessage.SIGNON_INFO_SIZE) {
            common.ptod("Killing Slave; Only String[] array of " + stringArray.length + " received");
            this.killSlaveSignonError();
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        this.slave = SlaveList.findSlaveName(string2);
        if (this.slave == null) {
            common.ptod("Killing slave: invalid slave name: " + string2);
            this.killSlaveSignonError();
            return null;
        }
        this.socket_to_slave.setSlaveLabel(this.slave.getLabel());
        long l = Math.abs(System.currentTimeMillis() - Long.parseLong(string6)) + 1L;
        if (l >= 30000L) {
            common.ptod("Clock synchronization warning: slave %s is %d seconds out of sync. This can lead to heartbeat issues.", this.slave.getLabel(), l / 1000L);
        }
        Host host = this.slave.getHost();
        host.setOS(string3, string4);
        if (!string.equals("localhost")) {
            if (host.master_ip == null) {
                if (!string.equals(common.getCurrentIP())) {
                    common.ptod("Killing slave: invalid master IP address: " + string + "; expecting: " + common.getCurrentIP());
                    this.killSlaveSignonError();
                    return null;
                }
            } else if (!string.equals(host.master_ip)) {
                common.ptod("Killing slave: invalid master IP address: " + string + "; expecting: " + host.master_ip);
                this.killSlaveSignonError();
                return null;
            }
        }
        socketMessage = new SocketMessage(SocketMessage.SEND_SIGNON_SUCCESSFUL, common.getProcessId());
        this.socket_to_slave.putMessage(socketMessage);
        socketMessage = this.socket_to_slave.getMessage();
        if (socketMessage.getMessageNum() != SocketMessage.SEND_SIGNON_SUCCESSFUL) {
            common.ptod("Successful signon confirmation failed: " + socketMessage.getMessageNum());
            this.killSlaveSignonError();
            return null;
        }
        this.slave.setSlaveSocket(this.socket_to_slave);
        return string5;
    }

    private void killSlaveSignonError() {
        SocketMessage socketMessage = new SocketMessage(SocketMessage.KILL_SLAVE_SIGNON_ERROR);
        this.socket_to_slave.putMessage(socketMessage);
        common.ptod("Killed slave");
    }
}

