/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.CompressObject;
import Vdb.Ctrl_c;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SocketMessage;
import Vdb.common;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SlaveSocket
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String slave_name = "signon";
    private String slave_label = "signon";
    private ObjectInputStream istream;
    private ObjectOutputStream ostream;
    private Socket socket;
    private boolean shutdown_in_progress = false;
    private boolean try_recovery = true;
    private long last_heartbeat_received = System.currentTimeMillis();
    private static Object bytes_lock = new Object();
    private static long bytes_raw = 0L;
    private static long bytes_zip = 0L;
    private static int remote_port = 5560;
    private static int master_port = 5570;
    private static HashMap<String, Long> shortest_map = new HashMap(32);
    private static boolean dont_zip = common.get_debug(common.DONT_ZIP_SOCKET_MSGS);

    public SlaveSocket(String string, int n) throws UnknownHostException, IOException {
        this.socket = new Socket(string, n);
        this.socket.setSoTimeout(120000);
        this.setBufferSize();
        this.socket.setTcpNoDelay(true);
        this.ostream = new ObjectOutputStream(this.socket.getOutputStream());
        this.istream = new ObjectInputStream(this.socket.getInputStream());
    }

    public SlaveSocket(ServerSocket serverSocket) throws IOException {
        this.socket = serverSocket.accept();
        this.ostream = new ObjectOutputStream(this.socket.getOutputStream());
        this.istream = new ObjectInputStream(this.socket.getInputStream());
        this.socket.setSoTimeout(120000);
        this.socket.setTcpNoDelay(true);
        this.setBufferSize();
    }

    public void setSlaveLabel(String string) {
        this.slave_label = string;
    }

    public void setSlaveName(String string) {
        this.slave_name = string;
    }

    public static void setRemotePort(int n) {
        remote_port = n;
    }

    public static int getRemotePort() {
        return remote_port;
    }

    public static void setMasterPort(int n) {
        master_port = n;
    }

    public static int getMasterPort() {
        return master_port;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setRecovery(boolean bl) {
        this.try_recovery = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketMessage getMessage() {
        SocketMessage socketMessage = null;
        while (true) {
            try {
                socketMessage = (SocketMessage)this.istream.readObject();
                socketMessage.receive_time = System.currentTimeMillis();
                if (!dont_zip) {
                    socketMessage.setData(this.unCompressObj((byte[])socketMessage.getData()));
                }
                this.storeShortest(socketMessage);
                if (!common.get_debug(common.REPORT_MESSAGE_SIZE)) break;
                int n = CompressObject.sizeof(socketMessage);
                int n2 = this.compressObj(socketMessage).length;
                double d = (double)n / (double)n2;
                Object object = bytes_lock;
                synchronized (object) {
                    double d2 = (double)(bytes_raw += (long)n) / (double)(bytes_zip += (long)n2);
                    common.ptod("getMessage length: " + SlaveList.getLabelMask() + " %6d %6d %6.2f:1 %,12d %,12d %6.2f:1 %s ", this.slave_label, n, n2, d, bytes_raw, bytes_zip, d2, socketMessage.getMessageText());
                }
            }
            catch (EOFException eOFException) {
                if (this.shutdown_in_progress) {
                    return null;
                }
                if (Ctrl_c.active()) {
                    return null;
                }
                if (this.slave_label.equals("RshDeamon")) {
                    this.shutdown_in_progress = true;
                    return null;
                }
                Vector<String> vector = new Vector<String>(16);
                vector.add("");
                if (!SlaveJvm.isThisSlave()) {
                    vector.add("Receiving unexpected EOFException from slave: " + this.slave_label);
                    vector.add("This means that this slave terminated prematurely.");
                } else {
                    vector.add("Receiving unexpected EOFException from the master");
                    vector.add("This means that the master terminated prematurely.");
                }
                vector.add("This thread will go to sleep for 5 seconds to allow ");
                vector.add("slave termination to be properly recognized.");
                vector.add("");
                common.ptod(vector);
                common.sleep_some(5000L);
                common.failure(eOFException);
            }
            catch (SocketException socketException) {
                if (this.shutdown_in_progress) {
                    return null;
                }
                Slave slave = SlaveList.findSlaveLabel(this.slave_label);
                Vector<String> vector = new Vector<String>(8);
                vector.add("");
                vector.add("SocketException from slave: " + this.slave_label);
                vector.add("Slave " + this.slave_label + " terminated unexpectedly.");
                vector.add("Look at file " + slave.getConsoleLog().getFileName() + ".html for more information.");
                vector.add("");
                common.plog("HTML link: <A HREF=\"" + slave.getConsoleLog().getFileName() + ".html\">" + slave.getConsoleLog().getFileName() + ".html</A>");
                common.ptod(vector);
                common.failure(socketException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                common.plog("SocketTimeoutException; continuing " + this.slave_label);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                common.ptod("ClassNotFoundException from slave: " + this.slave_label);
                common.failure(classNotFoundException);
            }
            catch (IOException iOException) {
                common.ptod("IOException from slave: " + this.slave_label);
                common.failure(iOException);
            }
            break;
        }
        long l = socketMessage.receive_time - socketMessage.send_time - this.getShortest(socketMessage);
        if (common.get_debug(common.SHOW_SOCKET_MESSAGES) || common.get_debug(common.SOCKET_TRAFFIC)) {
            if (common.get_debug(common.SOCKET_TRAFFIC)) {
                common.ptod("getMessage: %-12s %3d %5d %s", this.slave_label, socketMessage.getSeqno(), l, socketMessage.getMessageText());
            } else {
                common.plog("getMessage: %-12s %3d %5d %s", this.slave_label, socketMessage.getSeqno(), l, socketMessage.getMessageText());
            }
        }
        if (l > 5000L) {
            common.plog("Slow getMessage: %-12s %3d %5d %s", this.slave_label, socketMessage.getSeqno(), l, socketMessage.getMessageText());
        }
        if (socketMessage.getMessageNum() == SocketMessage.HEARTBEAT_MESSAGE) {
            this.last_heartbeat_received = System.currentTimeMillis();
        }
        return socketMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessage(SocketMessage socketMessage) {
        IOException iOException = null;
        if (socketMessage.getMessageNum() == SocketMessage.CONSOLE_MESSAGE && socketMessage.getData() instanceof String) {
            common.plog("Message to master: " + (String)socketMessage.getData());
        }
        Object object = this;
        synchronized (object) {
            block17: {
                socketMessage.setSeqno();
                if (common.get_debug(common.SHOW_SOCKET_MESSAGES) || common.get_debug(common.SOCKET_TRAFFIC)) {
                    if (common.get_debug(common.SOCKET_TRAFFIC)) {
                        common.ptod("putMessage: %-12s %3d       %s", this.slave_label, socketMessage.getSeqno(), socketMessage.getMessageText());
                    } else {
                        common.plog("putMessage: %-12s %3d       %s", this.slave_label, socketMessage.getSeqno(), socketMessage.getMessageText());
                    }
                }
                try {
                    if (!dont_zip) {
                        socketMessage.setData(this.compressObj(socketMessage.getData()));
                    }
                    socketMessage.send_time = System.currentTimeMillis();
                    this.ostream.reset();
                    this.ostream.writeObject(socketMessage);
                    this.ostream.flush();
                    long l = System.currentTimeMillis();
                }
                catch (SocketException socketException) {
                    Slave slave;
                    if (this.slave_label.equals("RshDeamon")) {
                        if (!this.shutdown_in_progress) {
                            common.ptod("Shutting down socket to rsh user");
                        }
                        this.shutdown_in_progress = true;
                        return false;
                    }
                    if (!SlaveJvm.isThisSlave() && (slave = SlaveList.findSlaveLabel(this.slave_label)).isAborted()) break block17;
                    if (!this.try_recovery) {
                        common.ptod("SocketException during putMessage(sm). Continuing");
                        return false;
                    }
                    iOException = socketException;
                }
                catch (IOException iOException2) {
                    if (!this.try_recovery) {
                        common.ptod("IOException during putMessage(sm). Continuing");
                        return false;
                    }
                    iOException = iOException2;
                }
                if (iOException == null) {
                    return true;
                }
            }
        }
        if (!SlaveJvm.isThisSlave() && ((Slave)(object = SlaveList.findSlaveLabel(this.slave_label))).isAborted()) {
            common.plog("SocketException from aborting slave. That's OK.");
            return false;
        }
        common.ptod("Exception from slave: " + this.slave_label);
        Thread.currentThread();
        Thread.dumpStack();
        common.failure(iOException);
        return false;
    }

    public long getlastHeartBeat() {
        return this.last_heartbeat_received;
    }

    public void setlastHeartBeat() {
        this.last_heartbeat_received = System.currentTimeMillis();
    }

    public void setShutdown(boolean bl) {
        this.shutdown_in_progress = bl;
    }

    public boolean isShutdown() {
        return this.shutdown_in_progress;
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    private void setBufferSize() {
        try {
            int n = 49152;
            if (this.socket.getSendBufferSize() < n) {
                this.socket.setSendBufferSize(n);
            }
            if (this.socket.getReceiveBufferSize() < n) {
                this.socket.setReceiveBufferSize(n);
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    private byte[] compressObj(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(object);
            gZIPOutputStream.finish();
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    private Object unCompressObj(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            Object object = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                common.failure(classNotFoundException);
            }
            return object;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    private void storeShortest(SocketMessage socketMessage) {
        long l = socketMessage.receive_time - socketMessage.send_time;
        Long l2 = shortest_map.get(this.slave_name);
        if (l2 == null) {
            l2 = new Long(Long.MAX_VALUE);
        }
        if (l < l2) {
            shortest_map.put(this.slave_name, l);
        }
    }

    private long getShortest(SocketMessage socketMessage) {
        Long l = shortest_map.get(this.slave_name);
        if (l == null) {
            return 0L;
        }
        long l2 = l;
        return l2;
    }
}

