/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.CommandOutput;
import Utils.OS_cmd;
import Vdb.Host;
import Vdb.Rsh;
import Vdb.Slave;
import Vdb.SlaveSocket;
import Vdb.ThreadControl;
import Vdb.common;

class SlaveStarter
extends ThreadControl {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Slave slave;
    private boolean abort_pending = false;

    SlaveStarter() {
    }

    public void setSlave(Slave slave) {
        this.slave = slave;
    }

    @Override
    public void run() {
        this.setName("SlaveStarter " + this.slave.getName());
        try {
            this.setIndependent();
            this.startSlave();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        this.removeIndependent();
    }

    public void startSlave() {
        try {
            Host host = this.slave.getHost();
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.setWaitForJvm();
            oS_cmd.setOutputMethod(new CommandOutput(){

                @Override
                public boolean newLine(String string, String string2, boolean bl) {
                    String string3 = String.format("%-12s: ", SlaveStarter.this.slave.getLabel()) + string;
                    SlaveStarter.this.slave.getConsoleLog().println(common.tod() + " " + string);
                    if (!SlaveStarter.this.slave.isConnected() && string3.endsWith("Command not found")) {
                        common.failure("Receiving 'command not found' from slave " + SlaveStarter.this.slave.getLabel() + ": " + string3);
                    }
                    if (string3.indexOf("common.failure()") != -1) {
                        SlaveStarter.this.abort_pending = true;
                    }
                    if (common.get_debug(common.SLAVE_LOG_ON_CONSOLE) || SlaveStarter.this.abort_pending) {
                        common.ptod(string3);
                    }
                    return true;
                }
            });
            if (!this.slave.isLocalHost() && !host.getShell().equals("vdbench")) {
                oS_cmd.addText(host.getShell());
                oS_cmd.addText(this.slave.getSlaveIP());
                oS_cmd.addText("-l");
                oS_cmd.addText(host.getUser());
            }
            if (!common.get_debug(common.USE_TVDBENCH)) {
                oS_cmd.addQuot(host.getVdbench() + "vdbench");
            } else {
                oS_cmd.addQuot(host.getVdbench() + "tvdbench");
            }
            oS_cmd.addText("SlaveJvm");
            oS_cmd.addText("-m");
            if (host.getLabel().equals("localhost")) {
                oS_cmd.addText("localhost");
            } else {
                String string = common.getCurrentIP();
                if (string.equals("127.0.0.1")) {
                    common.failure("Current system IP address is '%s'. Invalid network definition for multi-host processing.", string);
                }
                if (host.master_ip != null) {
                    string = host.master_ip;
                }
                oS_cmd.addText(string);
            }
            oS_cmd.addText("-n");
            oS_cmd.addText(this.slave.getName());
            oS_cmd.addText("-l");
            oS_cmd.addText(this.slave.getLabel());
            oS_cmd.addText("-p");
            oS_cmd.addText(SlaveSocket.getMasterPort());
            oS_cmd.addText(common.get_debug_string());
            this.startJvm(oS_cmd, host);
            common.sleep_some(500L);
            if (!this.slave.may_terminate()) {
                common.sleep_some(500L);
                common.ptod("");
                common.ptod("Slave " + this.slave.getLabel() + " prematurely terminated. ");
                if (this.slave.abort_msg != null) {
                    common.ptod("");
                    common.ptod("Slave aborted. Abort message received: ");
                    common.ptod(this.slave.abort_msg);
                    common.ptod("");
                }
                common.ptod("Look at file " + this.slave.getConsoleLog().getFileName() + ".html for more information.");
                common.plog("HTML link: <A HREF=\"" + this.slave.getConsoleLog().getFileName() + ".html\">" + this.slave.getConsoleLog().getFileName() + ".html</A>");
                common.failure("Slave " + this.slave.getLabel() + " prematurely terminated. ");
            }
            this.slave.setTerminated();
        }
        catch (Exception exception) {
            common.where();
            common.failure(exception);
        }
    }

    private void startJvm(OS_cmd oS_cmd, Host host) {
        common.ptod("Starting slave: " + oS_cmd.getCmd());
        if (this.slave.isLocalHost() && !common.get_debug(common.FAKE_RSH)) {
            oS_cmd.execute(false);
        } else if (host.getShell().equals("vdbench") || common.get_debug(common.FAKE_RSH)) {
            if (common.get_debug(common.SLAVE_LOG_ON_CONSOLE)) {
                common.failure("'-d44' option does not work with vdbench=rsh");
            }
            String string = oS_cmd.getCmd().substring(oS_cmd.getCmd().indexOf("SlaveJvm") + 8);
            Rsh.issueCommand(this.slave, string);
        } else {
            oS_cmd.execute(false);
        }
    }
}

