/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.GcTracker;
import Vdb.Native;
import Vdb.SlaveJvm;
import Vdb.common;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Task_num {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    static Vector<Task_num> task_list = new Vector(32, 0);
    static int task_next = 1;
    String task_name;
    int task_number;
    int task_status;
    static final int INIT = 0;
    static final int ST_PENDING = 1;
    static final int ST_COMP = 2;
    static final int GO_RUN = 3;
    static final int RUNNING = 4;
    static final int TERM = 5;
    double task_return;
    Thread task_thread;

    Task_num(String string) {
        this.task_get(string);
    }

    public Task_num(Object object) {
        this.task_get(object.getClass().getName());
    }

    public static synchronized void task_list_clear() {
        task_list.removeAllElements();
        task_next = 1;
    }

    public synchronized void task_get(String string) {
        this.task_name = string;
        this.task_number = task_next++;
        this.task_status = 0;
        this.task_thread = null;
        task_list.add(this);
    }

    public synchronized void task_set_start_pending() {
        if (this.task_status != 0) {
            common.failure("task status out of sync: " + this.task_name + " " + this.task_status + "/" + 1);
        } else {
            this.task_status = 1;
        }
    }

    public synchronized void task_set_start_complete() {
        this.task_thread = Thread.currentThread();
        if (this.task_status != 1) {
            common.failure("task status out of sync: " + this.task_name + " " + this.task_status + "/" + 2);
        } else {
            this.task_status = 2;
        }
    }

    public synchronized void waitForMasterGo() {
        while (this.task_status != 3) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                common.plog("catch (InterruptedException) tasknum " + this.task_name);
            }
        }
        this.task_status = 4;
    }

    public synchronized void task_set_terminating(double d) {
        if (this.task_status != 4) {
            common.failure("task status out of sync: " + this.task_name + " " + this.task_status + "/" + 5);
        } else {
            this.task_status = 5;
        }
        this.task_return = d;
        this.task_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void task_run_all() {
        for (int i = 0; i < task_list.size(); ++i) {
            Task_num task_num;
            Task_num task_num2 = task_num = task_list.elementAt(i);
            synchronized (task_num2) {
                if (task_num.task_status != 2) {
                    common.failure("task status out of sync: " + task_num.task_name + " " + task_num.task_status + "/" + 3);
                } else {
                    task_num.task_status = 3;
                }
                continue;
            }
        }
        common.plog(Format.f("task_run_all(): %d tasks", task_list.size()));
    }

    public static void task_wait_start_complete() {
        long l = 0L;
        common.plog("Waiting for task synchronization");
        while (true) {
            Task_num task_num;
            int n;
            for (n = 0; n < task_list.size(); ++n) {
                task_num = task_list.elementAt(n);
                if (task_num.task_status == 2) continue;
                common.plog("task_wait_start_complete: " + task_num.task_name + " " + task_num.task_status);
                break;
            }
            if (n == task_list.size()) break;
            if ((l = common.signal_caller(l, 10000L)) == 0L) {
                common.ptod("Waiting in task_wait_start_complete() ");
                int n2 = 0;
                for (n = 0; n < task_list.size(); ++n) {
                    task_num = task_list.elementAt(n);
                    if (task_num.task_status == 2) continue;
                    common.ptod("for " + task_num.task_name + " to start. Status " + task_num.task_status + " " + n);
                    if (n2++ <= 10) continue;
                    common.ptod("Maximum 10 tasks are reported each 10 seconds");
                    break;
                }
            }
            common.sleep_some(200L);
        }
        GcTracker.gc();
        common.plog("task_wait_start_complete() end");
    }

    public static int task_wait_all() {
        long l = 0L;
        long l2 = Native.get_simple_tod();
        while (true) {
            int n;
            int n2;
            for (n2 = 0; n2 < task_list.size(); ++n2) {
                Task_num task_num = task_list.elementAt(n2);
                if (task_num.task_status != 5) break;
            }
            if (n2 == task_list.size()) break;
            if ((l = common.signal_caller(l, 15000L)) == 0L) {
                Task_num.reportWaiters(l2);
            }
            int n3 = n = common.get_debug(common.LONG_SHUTDOWN) ? 900 : 300;
            if (Native.get_simple_tod() - l2 > (long)(n * 1000 * 1000)) {
                return n;
            }
            common.sleep_some(99L);
        }
        if (common.get_debug(common.FORCE_SHUTDOWN)) {
            return 999;
        }
        return 0;
    }

    private static void reportWaiters(long l) {
        Object object;
        Vector<String> vector = new Vector<String>(8, 0);
        long l2 = Native.get_simple_tod();
        vector.add("task_wait_all(): Waiting " + (l2 - l) / 1000000L + " seconds for active threads to complete: ");
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(64);
        for (int i = 0; i < task_list.size(); ++i) {
            Task_num task_num = task_list.elementAt(i);
            if (task_num.task_status == 5) continue;
            object = task_num.task_name + " " + task_num.task_status;
            Integer n = (Integer)hashMap.get(object);
            if (n == null) {
                n = new Integer(0);
            }
            hashMap.put(object, new Integer(n + 1));
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            object = (Integer)hashMap.get(objectArray[i]);
            vector.add((String)objectArray[i] + ": " + (Integer)object + " threads");
        }
        SlaveJvm.sendMessageToConsole(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void interrupt_tasks(String string) {
        long l = Native.get_simple_tod();
        long l2 = 0L;
        int n = 0;
        if (string.startsWith("FwgThread")) {
            common.failure("No interrupt may be requested for FwgThread.");
        }
        while (true) {
            int n2;
            if (Native.get_simple_tod() - l > 180000000L) {
                for (n2 = 0; n2 < task_list.size(); ++n2) {
                    Task_num task_num = task_list.elementAt(n2);
                    if (!task_num.task_name.startsWith(string) || task_num.task_thread == null) continue;
                    common.failure(Format.f("Task %s stopped after 3 minutes of trying to get it to terminate itself. Unpredictable results may occur.", string));
                }
                return;
            }
            n2 = 0;
            int n3 = 0;
            for (int i = 0; i < task_list.size(); ++i) {
                Task_num task_num;
                Task_num task_num2 = task_num = task_list.elementAt(i);
                synchronized (task_num2) {
                    if (task_num.task_name.startsWith(string)) {
                        ++n3;
                        if (task_num.task_thread != null) {
                            common.interruptThread(task_num.task_thread);
                            ++n2;
                            ++n;
                        }
                    }
                    continue;
                }
            }
            if (n2 == 0) {
                if (n <= n3) break;
                common.plog("Interrupts issued for tasks " + string + ": " + n);
                break;
            }
            if ((l2 = common.signal_caller(l2, 10000L)) == 0L) {
                common.plog("Trying to terminate tasks: " + string);
                common.plog("Interrupts issued for tasks " + string + ": " + n);
            }
            common.sleep_some(100L);
        }
    }

    public static synchronized int countTasks(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < task_list.size(); ++i) {
            Task_num task_num = task_list.elementAt(i);
            common.ptod("countTasks: " + string + " " + task_num.task_name + " " + task_num.task_status);
            if (task_num.task_status != n || !task_num.task_name.startsWith(string)) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean checkAllInTermination() {
        int n = 0;
        int n2 = 0;
        Iterator<Task_num> iterator = task_list.iterator();
        while (iterator.hasNext()) {
            Task_num task_num;
            Task_num task_num2 = task_num = iterator.next();
            synchronized (task_num2) {
                if (task_num.task_name.startsWith("FwgThread")) {
                    ++n;
                    if (task_num.task_status == 5) {
                        ++n2;
                    }
                }
            }
        }
        return n == n2;
    }

    public static synchronized void printTasks() {
        common.ptod("task_list: " + task_list.size());
        for (int i = 0; i < task_list.size(); ++i) {
            Task_num task_num = task_list.elementAt(i);
            common.ptod("tn.task_name: " + task_num.task_name);
        }
    }
}

