/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ThreadMonitor;
import java.io.Serializable;
import java.lang.management.ThreadInfo;

class ThreadMonData
implements Comparable,
Serializable {
    public String label;
    public long cputime;
    public long usertime;
    public long blockedtime;
    public long waitedtime;
    public long blockedcount;
    public long counter1;
    public long counter2;
    public long counter3;

    public ThreadMonData(String string) {
        this.label = string;
    }

    public void getThreadData(long l) {
        ThreadInfo threadInfo = ThreadMonitor.threadMXBean.getThreadInfo(l, 8);
        if (threadInfo == null) {
            this.blockedcount = 0L;
            this.blockedtime = 0L;
            this.waitedtime = 0L;
            this.cputime = 0L;
            this.usertime = 0L;
            return;
        }
        this.blockedcount = threadInfo.getBlockedCount();
        this.blockedtime = threadInfo.getBlockedTime();
        this.waitedtime = threadInfo.getWaitedTime();
        this.cputime = ThreadMonitor.threadMXBean.getThreadCpuTime(l);
        this.usertime = ThreadMonitor.threadMXBean.getThreadUserTime(l);
    }

    public String toString() {
        return String.format("cpu: %6d user: %6d wait: %6d %s", this.cputime / 1000000L, this.usertime / 1000000L, this.waitedtime / 1000000L, this.label);
    }

    public void calcDelta(ThreadMonData threadMonData, ThreadMonData threadMonData2) {
        this.blockedcount = threadMonData2.blockedcount - threadMonData.blockedcount;
        this.blockedtime = threadMonData2.blockedtime - threadMonData.blockedtime;
        this.waitedtime = threadMonData2.waitedtime - threadMonData.waitedtime;
        this.cputime = threadMonData2.cputime - threadMonData.cputime;
        this.usertime = threadMonData2.usertime - threadMonData.usertime;
        this.counter1 = threadMonData2.counter1 - threadMonData.counter1;
        this.counter2 = threadMonData2.counter2 - threadMonData.counter2;
        this.counter3 = threadMonData2.counter3 - threadMonData.counter3;
    }

    public void copyData(ThreadMonData threadMonData) {
        this.blockedcount = threadMonData.blockedcount;
        this.blockedtime = threadMonData.blockedtime;
        this.waitedtime = threadMonData.waitedtime;
        this.cputime = threadMonData.cputime;
        this.usertime = threadMonData.usertime;
        this.counter1 = threadMonData.counter1;
        this.counter2 = threadMonData.counter2;
        this.counter3 = threadMonData.counter3;
    }

    public void accum(ThreadMonData threadMonData) {
        this.blockedcount += threadMonData.blockedcount;
        this.blockedtime += threadMonData.blockedtime;
        this.waitedtime += threadMonData.waitedtime;
        this.cputime += threadMonData.cputime;
        this.usertime += threadMonData.usertime;
        this.counter1 += threadMonData.counter1;
        this.counter2 += threadMonData.counter2;
        this.counter3 += threadMonData.counter3;
    }

    public int compareTo(Object object) {
        ThreadMonData threadMonData = (ThreadMonData)object;
        long l = threadMonData.cputime - this.cputime;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        l = threadMonData.blockedtime - this.blockedtime;
        if (l == 0L) {
            return 0;
        }
        if (l < 0L) {
            return -1;
        }
        return 1;
    }
}

