/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ThreadMonData;
import Vdb.ThreadMonList;
import Vdb.common;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Vector;

public class ThreadMonitor {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String label;
    private long thread_id = -1L;
    private ThreadMonData latest;
    private ThreadMonData previous;
    private ThreadMonData delta;
    private long counter1 = 0L;
    private long counter2 = 0L;
    private long counter3 = 0L;
    private static long last_get_tod = 0L;
    protected static int processors = 0;
    private static boolean monitor_all = false;
    private static boolean monitor_top10 = false;
    private static boolean monitor_console = false;
    private static boolean monitor = false;
    protected static ThreadMXBean threadMXBean = ThreadMonitor.init();
    private static ThreadMonList all_deltas = new ThreadMonList();
    private static Vector<ThreadMonitor> monitor_list = new Vector(64);

    public ThreadMonitor(String string, String string2, String string3) {
        this.label = string;
        if (string2 != null) {
            this.label = this.label + "," + string2;
        }
        if (string3 != null) {
            this.label = this.label + "," + string3;
        }
        if (threadMXBean == null) {
            return;
        }
        this.thread_id = Thread.currentThread().getId();
        if (this.thread_id < 0L) {
            return;
        }
        monitor_list.add(this);
        this.latest = new ThreadMonData(this.label);
        this.previous = new ThreadMonData(this.label);
        this.delta = new ThreadMonData(this.label);
    }

    public static boolean active() {
        return monitor;
    }

    private static ThreadMXBean init() {
        monitor_all = common.get_debug(common.THREAD_MONITOR_ALL);
        monitor_top10 = common.get_debug(common.THREAD_MONITOR_TOP10);
        monitor_console = common.get_debug(common.THREAD_MONITOR_CONSOLE);
        boolean bl = monitor = monitor_all || monitor_top10 || monitor_console;
        if (!monitor) {
            return null;
        }
        try {
            threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                threadMXBean.setThreadContentionMonitoringEnabled(true);
            } else {
                common.ptod("ThreadContentionMonitoring not supported");
            }
            if (threadMXBean.isThreadCpuTimeSupported()) {
                threadMXBean.setThreadCpuTimeEnabled(true);
            } else {
                common.ptod("ThreadCpuTime not supported");
            }
            processors = Runtime.getRuntime().availableProcessors();
            return threadMXBean;
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Thread monitoring disabled");
            return null;
        }
    }

    public static void clear() {
        monitor_list.clear();
    }

    public void addCount(int n) {
        if (monitor) {
            this.counter1 += (long)n;
        }
    }

    public void add1() {
        if (monitor) {
            ++this.counter1;
        }
    }

    public void add2() {
        if (monitor) {
            ++this.counter2;
        }
    }

    public void add3() {
        if (monitor) {
            ++this.counter3;
        }
    }

    public void getLatestData() {
        this.latest.getThreadData(this.thread_id);
        this.latest.counter1 = this.counter1;
        this.latest.counter2 = this.counter2;
        this.latest.counter3 = this.counter3;
    }

    public static ThreadMonList getAllData() {
        long l = System.nanoTime();
        ThreadMonitor.all_deltas.elapsed = l - last_get_tod;
        last_get_tod = l;
        ThreadMonitor.all_deltas.list.clear();
        for (ThreadMonitor threadMonitor : monitor_list) {
            threadMonitor.getLatestData();
            threadMonitor.delta.calcDelta(threadMonitor.previous, threadMonitor.latest);
            ThreadMonitor.all_deltas.list.add(threadMonitor.delta);
        }
        return all_deltas;
    }

    public static ThreadMonList getAllDeltas() {
        return all_deltas;
    }

    public static void saveAllPrevious() {
        for (ThreadMonitor threadMonitor : monitor_list) {
            threadMonitor.previous.copyData(threadMonitor.latest);
        }
    }

    public static void reportAllDetail(ThreadMonList threadMonList) {
        if (threadMXBean == null) {
            return;
        }
        Collections.sort(threadMonList.list);
        common.ptod("");
        int n = 0;
        int n2 = 0;
        for (ThreadMonData threadMonData : threadMonList.list) {
            if (threadMonData.label.contains("IO_task") && ++n > 10 && common.get_debug(common.THREAD_MONITOR_TOP10) || threadMonData.label.contains("WG_task") && ++n2 > 10 && common.get_debug(common.THREAD_MONITOR_TOP10)) continue;
            common.ptod("ThreadMonitor cpu %6.2f%% user %6.2f%%  blkd %6.2f%% %6d wait %6.2f%% %8d %8d %s", (double)threadMonData.cputime * 100.0 / (double)threadMonList.elapsed, (double)threadMonData.usertime * 100.0 / (double)threadMonList.elapsed, (double)threadMonData.blockedtime * 100.0 * 1000000.0 / (double)threadMonList.elapsed, threadMonData.blockedcount, (double)threadMonData.waitedtime * 100.0 * 1000000.0 / (double)threadMonList.elapsed, threadMonData.counter1, threadMonData.counter2, threadMonData.label);
        }
    }

    public static void reportTotals(String string, ThreadMonList threadMonList) {
        if (threadMonList.list.size() == 0) {
            return;
        }
        long l = threadMonList.elapsed;
        long l2 = threadMonList.processors;
        Collections.sort(threadMonList.list);
        if (common.get_debug(common.THREAD_MONITOR_CONSOLE)) {
            common.ptod("");
        } else {
            common.plog("");
        }
        int n = 0;
        int n2 = 0;
        for (ThreadMonData threadMonData : threadMonList.list) {
            if (threadMonData.label.contains("IO_task") && ++n > 10 && common.get_debug(common.THREAD_MONITOR_TOP10) || threadMonData.label.contains("WG_task") && ++n2 > 10 && common.get_debug(common.THREAD_MONITOR_TOP10)) continue;
            String string2 = String.format("%-12s cpu %6.2f%% user %6.2f%%  blkd %6.2f%% wait %6.2f%% %8d %8d %s", string, (double)threadMonData.cputime * 100.0 / (double)(l * l2), (double)threadMonData.usertime * 100.0 / (double)(l * l2), (double)threadMonData.blockedtime * 100.0 * 1000000.0 / (double)(l * l2), (double)threadMonData.waitedtime * 100.0 * 1000000.0 / (double)(l * l2), threadMonData.counter1 * 1000000000L / l, threadMonData.counter2 * 1000000000L / l, threadMonData.label);
            if (common.get_debug(common.THREAD_MONITOR_CONSOLE)) {
                common.ptod(string2);
                continue;
            }
            common.plog(string2);
        }
    }
}

