/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.ErrorLog;
import Vdb.FsdEntry;
import Vdb.Host;
import Vdb.ReportData;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.Status;
import Vdb.Vdbmain;
import Vdb.common;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Timeout {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static long timeout_secs = 0L;
    private static long timeout_msecs = 0L;
    private static long timeout_max = 0L;
    private static String timeout_script = null;
    private static long report_secs = 0L;
    private static long last_notification = 0L;
    private static OS_cmd ocmd = null;
    private static Object timeout_lock = new Object();
    private static ArrayList<String> messages = new ArrayList(16);
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss-zzz");

    public static void reportLazyBums() {
        if (timeout_secs == 0L && report_secs == 0L) {
            return;
        }
        if (Vdbmain.isWdWorkload()) {
            for (SD_entry sD_entry : Vdbmain.sd_list) {
                for (Slave slave : SlaveList.getSlaveList()) {
                    if (!slave.isUsingSd(sD_entry) || sD_entry.concatenated_sd) continue;
                    ReportData reportData = slave.getReport(sD_entry.sd_name).getData();
                    if (reportData.longest_idle / 1000L > report_secs) {
                        common.plog("Longest idle period for sd=%s from slave=%-12s %3d seconds between %s and %s", sD_entry.sd_name, slave.getLabel(), reportData.longest_idle / 1000L, df.format(new Date(reportData.longest_end.getTime() - reportData.longest_idle)), df.format(reportData.longest_end));
                    }
                    reportData.longest_idle = 0L;
                    reportData.last_real_work = 0L;
                }
            }
        } else {
            for (Host host : Host.getDefinedHosts()) {
                for (Slave slave : host.getSlaves()) {
                    for (String string : slave.getFsdsUsed()) {
                        ReportData reportData = slave.getReport(string).getData();
                        if (reportData.longest_idle / 1000L > report_secs) {
                            common.plog("Longest idle period for fsd=%s from slave=%-12s %3d seconds between %s and %s", string, slave.getLabel(), reportData.longest_idle / 1000L, df.format(new Date(reportData.longest_end.getTime() - reportData.longest_idle)), df.format(reportData.longest_end));
                        }
                        reportData.longest_idle = 0L;
                        reportData.last_real_work = 0L;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lookForTimeouts() {
        if (timeout_secs == 0L && report_secs == 0L) {
            return;
        }
        Object object = timeout_lock;
        synchronized (object) {
            if (ocmd != null && !ocmd.stillRunning()) {
                String[] stringArray = ocmd.getStdout();
                if (stringArray.length > 0 && stringArray[0].trim().startsWith("abort")) {
                    Timeout.reportLazyBums();
                    ErrorLog.plog("Timeout: abort requested by 'timeout=(%d,%s)'", timeout_msecs / 1000L, timeout_script);
                    common.failure("Timeout: abort requested by 'timeout=(%d,%s)'", timeout_msecs / 1000L, timeout_script);
                }
                ocmd.removeKillAtEnd();
                ocmd = null;
            }
        }
        long l = 0L;
        messages.clear();
        long l2 = 0L;
        for (SD_entry object2 : Vdbmain.sd_list) {
            for (Slave slave : SlaveList.getSlaveList()) {
                if (!slave.isUsingSd(object2) || object2.concatenated_sd || object2.work_done) continue;
                ReportData reportData = slave.getReport(object2.sd_name).getData();
                if (reportData.last_real_work == 0L) {
                    reportData.last_real_work = Reporter.run_start_time.getTime();
                }
                long l3 = System.currentTimeMillis() - reportData.last_real_work;
                l = Math.max(l, l3);
                if (l3 <= timeout_msecs) continue;
                if (l3 > reportData.longest_idle) {
                    reportData.longest_idle = l3;
                    reportData.longest_end = new Date();
                }
                if (timeout_secs > 0L) {
                    messages.add(String.format("timeout=%d value exceeded for sd=%s on slave=%s for %3d seconds.", timeout_msecs / 1000L, object2.sd_name, slave.getLabel(), l3 / 1000L));
                }
                l2 = Math.max(l3, l2);
            }
        }
        for (Host host : Host.getDefinedHosts()) {
            for (Slave slave : host.getSlaves()) {
                for (String string : slave.getFsdsUsed()) {
                    FsdEntry fsdEntry = FsdEntry.findFsd(string);
                    if (!fsdEntry.in_use || fsdEntry.work_done) continue;
                    ReportData reportData = slave.getReport(string).getData();
                    if (reportData.last_real_work == 0L) {
                        reportData.last_real_work = Reporter.run_start_time.getTime();
                    }
                    long l4 = System.currentTimeMillis() - reportData.last_real_work;
                    l = Math.max(l, l4);
                    if (l4 <= timeout_msecs) continue;
                    if (l4 > reportData.longest_idle) {
                        reportData.longest_idle = l4;
                        reportData.longest_end = new Date();
                    }
                    if (timeout_secs > 0L) {
                        messages.add(String.format("timeout=%d value exceeded for fsd=%s on slave=%s for %3d seconds.", timeout_msecs / 1000L, string, slave.getLabel(), l4 / 1000L));
                    }
                    l2 = Math.max(l4, l2);
                }
            }
        }
        if (timeout_secs == 0L) {
            return;
        }
        if (messages.size() > 0) {
            Status.printOne(String.format("timeout=%d value exceeded. See errorlog.html", timeout_msecs / 1000L));
            if (timeout_script != null && timeout_script.equals("abort")) {
                for (String string : messages) {
                    ErrorLog.plog(string, new Object[0]);
                }
                ErrorLog.plog("'timeout=(%d,abort)' requested", timeout_msecs / 1000L);
                common.failure("'timeout=(%d,abort)' requested", timeout_msecs / 1000L);
            }
            if (System.currentTimeMillis() > last_notification + timeout_msecs) {
                last_notification = System.currentTimeMillis();
                for (String string : messages) {
                    ErrorLog.plog(string, new Object[0]);
                }
                if (timeout_script != null) {
                    Timeout.callUserScript(l);
                }
                common.ptod("timeout=%d value exceeded. See errorlog.html", timeout_msecs / 1000L);
            }
        }
        if (timeout_max > 0L && l2 > timeout_max) {
            ErrorLog.plog("Maximum timeout=(%d,%d) has been reached. ", timeout_msecs / 1000L, timeout_max / 1000L);
            common.failure("Maximum timeout=(%d,%d) has been reached. ", timeout_msecs / 1000L, timeout_max / 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callUserScript(long l) {
        if (ocmd != null) {
            return;
        }
        Object object = timeout_lock;
        synchronized (object) {
            ocmd = new OS_cmd();
            ocmd.addText(common.replace(timeout_script, "$output", Vdbmain.output_dir));
            ocmd.addText(String.format("maxlate %d", l / 1000L));
            ocmd.addText("&");
            ocmd.execute(false);
        }
    }

    public static void callScriptForShutdown() {
        if (timeout_script == null) {
            return;
        }
        ocmd = new OS_cmd();
        ocmd.addText(common.replace(timeout_script, "$output", Vdbmain.output_dir));
        ocmd.execute(false);
        common.plog("callScriptForShutdown: " + ocmd.getCmd());
        for (String string : ocmd.getStderr()) {
            common.plog("callScriptForShutdown stderr: " + string);
        }
        for (String string : ocmd.getStdout()) {
            common.plog("callScriptForShutdown: " + string);
        }
    }

    public static void scanTimeoutParameter(ArrayList<String> arrayList) {
        if (arrayList.get(0).equals("report")) {
            report_secs = 1L;
            if (arrayList.size() == 2) {
                report_secs = Integer.parseInt(arrayList.get(1));
            } else if (arrayList.size() != 1) {
                common.failure("timeout=(report,nn) has more values than expected: %d", arrayList.size());
            }
            return;
        }
        String string = arrayList.get(0);
        if (!common.isNumeric(string)) {
            common.failure("The first timeout= parameter must be numeric");
        }
        timeout_secs = Integer.parseInt(string);
        timeout_msecs = timeout_secs * 1000L;
        if (arrayList.size() == 1) {
            return;
        }
        if (arrayList.size() > 2) {
            common.failure("The timeout= parameter may contain only two values");
        }
        if (common.isNumeric(string = arrayList.get(1))) {
            timeout_max = Integer.parseInt(string) * 1000;
        } else {
            timeout_script = string;
        }
    }
}

