/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;

public class Timers {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private long tod_before;
    private long tod_total = 0L;
    private long tod_counts = 0L;
    private long first_tod;
    private long last_tod;
    private String label;
    private static final boolean active = common.get_debug(common.TIMERS);

    public Timers(String string) {
        this.label = string;
    }

    public long simpleTime() {
        long l = System.nanoTime();
        if (l == 0L) {
            common.failure("Timers(): zero nanoTime");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before() {
        if (active) {
            Timers timers = this;
            synchronized (timers) {
                if (this.tod_counts == 0L) {
                    this.first_tod = this.simpleTime();
                }
                this.tod_before = this.simpleTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after() {
        if (active) {
            Timers timers = this;
            synchronized (timers) {
                if (this.tod_before == 0L) {
                    common.failure("Timers.after(): previous tod equals zero");
                }
                this.last_tod = this.simpleTime();
                this.tod_total += this.last_tod - this.tod_before;
                this.tod_before = 0L;
                ++this.tod_counts;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xadd(long l) {
        if (active) {
            Timers timers = this;
            synchronized (timers) {
                if (this.tod_counts == 0L) {
                    this.first_tod = this.simpleTime();
                }
                this.last_tod = this.simpleTime();
                this.tod_total += l;
                ++this.tod_counts;
            }
        }
    }

    public void print() {
        if (!active) {
            return;
        }
        try {
            common.ptod("+Timers: %-20s calls: %8d elapsed%%: %6.2f; avg time per set: %10d ns; %10d us", this.label, this.tod_counts, this.tod_counts == 0L ? 0.0 : (double)this.tod_total * 100.0 / (double)(this.last_tod - this.first_tod), this.tod_counts == 0L ? 0L : this.tod_total / this.tod_counts, this.tod_counts == 0L ? 0L : this.tod_total / this.tod_counts / 1000L);
        }
        catch (Exception exception) {
            common.ptod("Exception in Timers.print(): " + exception.toString());
        }
    }
}

