/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Validate;
import Vdb.common;

public class Timestamp {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private long[] timestamps = null;
    private int[] write_xfers = null;
    private int entries = 0;
    private static int MAX_SIZE = Integer.MAX_VALUE;
    private static long TIME_MASK = 0xFFFFFFFFFFFFL;
    private static long OPERATION_MASK = -72057594037927936L;
    private static long KEY_MASK = 0xFF000000000000L;
    public static long READ_ONLY = 0x1000000000000000L;
    public static long PRE_READ = 0x2000000000000000L;
    public static long READ_IMMED = 0x3000000000000000L;
    public static long WRITE = 0x4000000000000000L;
    public static long PENDING_READ = 0x5000000000000000L;
    public static long PENDING_REREAD = 0x6000000000000000L;

    public Timestamp(long l) {
        common.ptod("Data Validation. Allocating timestamp map requiring 8 * %,d = %.3fMB of java heap space.", l, (double)l * 8.0 / 1024.0 / 1024.0);
        if (l > (long)MAX_SIZE) {
            common.failure("Timestamp map only supports %,d entries", MAX_SIZE);
        }
        this.entries = (int)l;
        this.timestamps = new long[this.entries];
        if (Validate.isXferHistory()) {
            this.write_xfers = new int[this.entries];
        }
    }

    public static void main(String[] stringArray) {
        long l = common.parseSize(stringArray[0]);
        Timestamp timestamp = new Timestamp(l);
    }

    public void storeTime(long l, long l2, long l3, long l4) {
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        this.timestamps[(int)l] = l3 | l2 | l4 << 48;
    }

    public void storeWriteXfer(long l, int n) {
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        this.write_xfers[(int)l] = n;
    }

    public long getLastTime(long l) {
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        long l2 = this.timestamps[(int)l];
        return l2 & TIME_MASK;
    }

    public int getLastXfersize(long l) {
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        return this.write_xfers[(int)l];
    }

    public String getLastOperation(long l) {
        long l2;
        long l3;
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        if ((l3 = (l2 = this.timestamps[(int)l]) & OPERATION_MASK) == READ_ONLY) {
            return "read";
        }
        if (l3 == PRE_READ) {
            return "pre_read";
        }
        if (l3 == READ_IMMED) {
            return "read_after_write";
        }
        if (l3 == WRITE) {
            return "written";
        }
        if (l3 == PENDING_READ) {
            return "journal pending read";
        }
        return "unkown_operation";
    }

    public int getLastKey(long l) {
        if (l > (long)this.entries) {
            common.failure("Timestamp: requesting block %,d which is larger than the current size of %,d", l, this.entries);
        }
        long l2 = this.timestamps[(int)l];
        long l3 = l2 & KEY_MASK;
        return (int)(l3 >>= 48);
    }
}

