/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;

public class Validate
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private boolean journal_active = false;
    private boolean journal_flush = true;
    private boolean journal_recovery = false;
    private boolean journal_rec_only = false;
    private boolean journal_maponly = false;
    private boolean journal_recovered = false;
    private boolean validate = false;
    private boolean for_dedup = false;
    private boolean validate_immed = false;
    private boolean validate_nopreread = false;
    private boolean validate_time = false;
    private boolean validate_xfer = false;
    private boolean continue_old_map = false;
    private boolean ignore_zero_reads = false;
    private boolean skip_data_read = false;
    private boolean report_dedupsets = false;
    private boolean ignore_pending = false;
    private int maximum_dv_wait = 0;
    private int maximum_dv_errors = 50;
    private String dv_error_cmd = null;
    private int dv_error_sleep = 0;
    private String output_dir = null;
    private double compression = 1.0;
    private boolean compression_used = false;
    private long compression_seed = 0L;
    private int[] psrset = new int[0];
    private boolean sd_concatenation = false;
    private double abort_failed_skew = Double.MAX_VALUE;
    private boolean dedup = false;
    private int dedup_unit = 0;
    private boolean showlba = false;
    private int patt_mb = 1;
    public static int FLAG_VALIDATE = 1;
    public static int FLAG_DEDUP = 2;
    public static int FLAG_COMPRESSION = 4;
    public static int FLAG_SPARE = 8;
    public static int FLAG_VALIDATE_NORMAL = 16;
    public static int FLAG_VALIDATE_DEDUP = 32;
    public static int FLAG_VALIDATE_COMP = 64;
    public static int FLAG_USE_PATTERN_BUF = 128;
    public static int FLAG_NORMAL_READ = 256;
    public static int FLAG_PRE_READ = 512;
    public static int FLAG_READ_IMMEDIATE = 1024;
    public static int FLAG_PENDING_READ = 2048;
    public static int FLAG_PENDING_REREAD = 4096;
    public static int FLAG_FAIL_WRITE = 65536;
    public static String REMOVE_DEVICE_OPTION = "remove_device";
    private static Validate options = new Validate();
    private long journal_max = Long.MAX_VALUE;

    public static void storeOptions(Validate validate) {
        options = validate;
    }

    public static Validate getOptions() {
        return options;
    }

    public static void setDedup() {
        Validate.options.dedup = true;
    }

    public static boolean isDedup() {
        return Validate.options.dedup;
    }

    public static void setDedupUnit(int n) {
        Validate.options.dedup_unit = n;
    }

    public static int getDedupUnit() {
        return Validate.options.dedup_unit;
    }

    public static void setValidateOptionsForDedup() {
        if (!Validate.isValidate()) {
            Validate.setValidate();
            Validate.setValidateForDedup();
            Validate.setNoPreRead();
            Validate.options.ignore_zero_reads = true;
        }
    }

    public static void setJournaling() {
        Validate.options.journal_active = true;
    }

    public static void setNoJournalFlush() {
        Validate.options.journal_flush = false;
    }

    public static void setJournalRecovery() {
        Validate.options.journal_recovery = true;
    }

    public static void setRecoveryOnly() {
        Validate.options.journal_rec_only = true;
    }

    public static void setJournalMax(long l) {
        Validate.options.journal_max = l;
    }

    public static long getMaxJournal() {
        return Validate.options.journal_max;
    }

    public static void setSkipRead() {
        Validate.options.skip_data_read = true;
    }

    public static boolean skipRead() {
        return Validate.options.skip_data_read;
    }

    public static void setIgnorePending() {
        Validate.options.ignore_pending = true;
    }

    public static boolean ignorePending() {
        return Validate.options.ignore_pending;
    }

    public static void setJournalRecovered(boolean bl) {
        Validate.options.journal_recovered = bl;
    }

    public static void setValidate() {
        if (Vdbmain.loop_all_runs && Validate.isJournalRecovery()) {
            common.failure("The '-l nnn' (loop) parameter is not allowed together with journal recovery.");
        }
        Validate.options.validate = true;
    }

    public static void setValidateForDedup() {
        Validate.options.for_dedup = true;
    }

    public static boolean isValidateForDedup() {
        return Validate.options.for_dedup;
    }

    public static boolean isRealValidate() {
        return Validate.isValidate() && !Validate.isValidateForDedup();
    }

    public static void setImmediateRead() {
        Validate.options.validate_immed = true;
    }

    public static void setXferHistory() {
        Validate.options.validate_xfer = true;
    }

    public static boolean isXferHistory() {
        return Validate.options.validate_xfer;
    }

    public static void setNoPreRead() {
        Validate.options.validate_nopreread = true;
    }

    public static boolean isNoPreRead() {
        return Validate.options.validate_nopreread;
    }

    public static void setStoreTime() {
        Validate.options.validate_time = true;
    }

    public static boolean isStoreTime() {
        return Validate.options.validate_time;
    }

    public static void setMapOnly() {
        Validate.options.journal_maponly = true;
    }

    public static boolean isMapOnly() {
        return Validate.options.journal_maponly;
    }

    public static void setContinueOldMap() {
        Validate.options.continue_old_map = true;
    }

    public static boolean isJournaling() {
        return Validate.options.journal_active;
    }

    public static boolean isJournalFlush() {
        return Validate.options.journal_flush;
    }

    public static boolean isJournalRecoveryActive() {
        return Validate.options.journal_recovery && !Validate.options.journal_recovered;
    }

    public static boolean isJournalRecovery() {
        return Validate.options.journal_recovery;
    }

    public static boolean isRecoveryOnly() {
        return Validate.options.journal_rec_only;
    }

    public static boolean isJournalRecovered() {
        return Validate.options.journal_recovered;
    }

    public static boolean isValidate() {
        return Validate.options.validate;
    }

    public static boolean isImmediateRead() {
        return Validate.options.validate_immed;
    }

    public static boolean isContinueOldMap() {
        return Validate.options.continue_old_map;
    }

    public static int getMaxErrorWait() {
        return Validate.options.maximum_dv_wait;
    }

    public static String getErrorCommand() {
        if (Validate.options.dv_error_cmd == null) {
            return null;
        }
        if (Validate.options.dv_error_cmd.equals(REMOVE_DEVICE_OPTION)) {
            return null;
        }
        return Validate.options.dv_error_cmd;
    }

    public static boolean removeAfterError() {
        if (Validate.options.dv_error_cmd == null) {
            return false;
        }
        return Validate.options.dv_error_cmd.equals(REMOVE_DEVICE_OPTION);
    }

    public static int getMaxErrorCount() {
        return Validate.options.maximum_dv_errors;
    }

    public static int getErrorSleep() {
        return Validate.options.dv_error_sleep;
    }

    public static void setOutput(String string) {
        Validate.options.output_dir = string;
    }

    public static String getOutput() {
        return Validate.options.output_dir;
    }

    public static void setCompressionRatio(double d) {
        Validate.options.compression = d;
        Validate.options.compression_used = true;
    }

    public static void setCompSeed(long l) {
        Validate.options.compression_seed = l;
    }

    public static double getCompressionRatio() {
        return Validate.options.compression;
    }

    public static boolean isCompressionRequested() {
        return Validate.options.compression_used;
    }

    public static boolean isCompression() {
        boolean bl;
        boolean bl2 = bl = Validate.options.compression != -1.0;
        if (!bl) {
            common.failure("Compression should ALWAYS be on");
        }
        return Validate.options.compression != -1.0;
    }

    public static boolean ignoreZeroReads() {
        return Validate.options.ignore_zero_reads;
    }

    public static long getCompSeed() {
        return Validate.options.compression_seed;
    }

    public static void setPatternMB(int n) {
        Validate.options.patt_mb = n;
        if (n <= 0) {
            common.failure("Invalid 'pattern_buffer=%d' size, must be MB. ", n);
        }
    }

    public static int getPatternMB() {
        return Validate.options.patt_mb;
    }

    public static void parseJournalOptions(Vdb_scan vdb_scan) {
        String[] stringArray = vdb_scan.alphas;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("no")) {
                Validate.options.journal_active = false;
                return;
            }
            Validate.setValidate();
            Validate.setJournaling();
            if ("yes".startsWith(string)) {
                Validate.setJournaling();
                continue;
            }
            if ("recover".startsWith(string)) {
                Validate.setJournalRecovery();
                continue;
            }
            if ("noflush".startsWith(string)) {
                Validate.setNoJournalFlush();
                continue;
            }
            if ("maponly".compareTo(string) == 0) {
                Validate.setMapOnly();
                continue;
            }
            if ("only".compareTo(string) == 0) {
                Validate.setRecoveryOnly();
                continue;
            }
            if ("skip_read_all".startsWith(string)) {
                Validate.setSkipRead();
                continue;
            }
            if ("ignore_pending".startsWith(string)) {
                Validate.setIgnorePending();
                continue;
            }
            if (string.startsWith("max=")) {
                Validate.setJournalMax(common.parseSize(string.substring(4)));
                continue;
            }
            common.failure("Unknown keyword value for 'journal=': " + string);
        }
    }

    public static void parseValidateOptions(Vdb_scan vdb_scan) {
        String[] stringArray = vdb_scan.alphas;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("no".startsWith(string)) {
                Validate.options.validate = false;
                return;
            }
            if ("continue_old_map".startsWith(string)) {
                common.failure("'validate=continue' no longer supported");
                Validate.setContinueOldMap();
                return;
            }
            Validate.setValidate();
            if ("yes".startsWith(string)) {
                Validate.setValidate();
                continue;
            }
            if ("read_after_write".startsWith(string)) {
                Validate.setImmediateRead();
                continue;
            }
            if ("xfersize".startsWith(string)) {
                Validate.setStoreTime();
                Validate.setXferHistory();
                continue;
            }
            if ("no_preread".startsWith(string)) {
                Validate.setNoPreRead();
                continue;
            }
            if ("time".compareTo(string) == 0) {
                Validate.setStoreTime();
                continue;
            }
            if ("ignore_zero_reads".startsWith(string)) {
                Validate.options.ignore_zero_reads = true;
                continue;
            }
            if ("reportdedupsets".startsWith(string)) {
                Validate.options.report_dedupsets = true;
                Validate.setStoreTime();
                continue;
            }
            common.failure("Unknown keyword value for 'validate=': " + string);
        }
    }

    public static void parseDataErrors(Vdb_scan vdb_scan) {
        if (vdb_scan.getNumCount() > 0) {
            Validate.options.maximum_dv_errors = (int)vdb_scan.numerics[0];
            if (vdb_scan.getNumCount() > 1) {
                Validate.options.maximum_dv_wait = (int)vdb_scan.numerics[1];
            }
        } else {
            Validate.options.maximum_dv_errors = 0;
            Validate.options.dv_error_cmd = vdb_scan.alphas[0];
            if (Validate.options.dv_error_cmd.startsWith("remove")) {
                String[] stringArray = vdb_scan.alphas[0].split("=");
                if (stringArray.length > 1) {
                    Validate.options.dv_error_sleep = Integer.parseInt(stringArray[1]);
                }
                Validate.options.dv_error_cmd = REMOVE_DEVICE_OPTION;
                Validate.options.maximum_dv_errors = 10000;
                common.ptod("'data_errors=%s' option requested. Max error count set to %d", REMOVE_DEVICE_OPTION, Validate.options.maximum_dv_errors);
            }
        }
    }

    public static int createDataFlag() {
        int n = 0;
        String string = "";
        if (Validate.isValidate()) {
            n |= FLAG_VALIDATE;
            string = string + "FLAG_VALIDATE ";
            if (Dedup.isDedup()) {
                n |= FLAG_VALIDATE_DEDUP;
                string = string + "FLAG_VALIDATE_DEDUP ";
            } else if (Validate.isCompression()) {
                n |= FLAG_VALIDATE_COMP;
                string = string + "FLAG_VALIDATE_COMP ";
            } else {
                n |= FLAG_VALIDATE_NORMAL;
                string = string + "FLAG_VALIDATE_NORMAL ";
            }
        }
        if (Dedup.isDedup()) {
            n |= FLAG_DEDUP;
            string = string + "FLAG_DEDUP ";
        } else if (Validate.isCompression()) {
            n |= FLAG_COMPRESSION;
            string = string + "FLAG_COMPRESSION ";
        }
        return n;
    }

    public static void setSdConcatenation() {
        Validate.options.sd_concatenation = true;
    }

    public static boolean sdConcatenation() {
        return Validate.options.sd_concatenation;
    }

    public static void setPsrset(int[] nArray) {
        Validate.options.psrset = nArray;
    }

    public static int[] getPsrset() {
        return Validate.options.psrset;
    }

    public static void setSkewAbort(double d) {
        Validate.options.abort_failed_skew = d;
    }

    public static double getSkewAbort() {
        return Validate.options.abort_failed_skew;
    }

    public static void setShowLba(boolean bl) {
        Validate.options.showlba = bl;
    }

    public static boolean showLba() {
        return Validate.options.showlba;
    }

    public static boolean reportDedupsets() {
        return Validate.options.report_dedupsets;
    }
}

