/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Vdb.InsertHosts;
import Vdb.RD_entry;
import Vdb.Var_parms;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class Vdb_scan {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String keyword;
    public String[] alphas = new String[512];
    public double[] numerics = new double[10240];
    public ArrayList<String> raw_values = new ArrayList(4);
    public String raw_value = null;
    public int alpha_count;
    public int num_count;
    static BufferedReader br;
    static String line;
    static StringTokenizer st;
    static PrintWriter parm_html;
    static String[] list_of_parameters;
    static int parms_read;
    static int parms_used;
    static boolean external_parms_used;
    static boolean sd_found;
    static boolean wd_found;
    static boolean rd_found;
    static boolean first;

    private static void parm_error(String string) {
        common.ptod("");
        common.ptod("Parameterscan error. See also output file 'parmscan.html' for details.");
        common.ptod(string, Vdbmain.parms_report);
        Vdbmain.usage();
        common.failure(string);
    }

    static void Vdb_scan_read(Vector vector, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            File file = new File(string);
            if (!file.exists()) {
                Vdb_scan.parm_error("Requested parameter file does not exist: " + string);
            }
            if (bl) {
                parm_html.println("\n* Contents of parameter file: " + file.getAbsolutePath() + "\n");
            } else {
                parm_html.println("\n* WD parameter read from file: " + file.getAbsolutePath() + "\n");
            }
            try {
                String string2;
                Fget fget = new Fget(file);
                while ((string2 = fget.get()) != null) {
                    String string3 = string2;
                    string2 = InsertHosts.substituteLine(string3);
                    if (common.get_debug(common.IGNORE_PARM_COMMENT) && string2.startsWith("*d ")) {
                        string2 = string2.substring(3).trim() + " /* '*d ' accepted */";
                    }
                    if (string2.equals(string3)) {
                        parm_html.println(string2.replace('[', ' '));
                    } else {
                        external_parms_used = true;
                        parm_html.println(string3.replace('[', ' '));
                        parm_html.println("    variable substitution: " + string2.replace('[', ' '));
                    }
                    string2 = string2.trim();
                    if (string2.startsWith("eof")) break;
                    if (string2.startsWith("/") || string2.startsWith("#") || string2.startsWith("*") || string2.length() == 0) continue;
                    if (string2.startsWith("include=")) {
                        Vdb_scan.readIncludeFile(string2, string);
                        continue;
                    }
                    Vdb_scan.list_of_parameters[Vdb_scan.parms_read++] = string2;
                }
                fget.close();
                continue;
            }
            catch (Exception exception) {
                Vdbmain.usage();
                common.failure(exception);
            }
        }
    }

    private static void readIncludeFile(String string, String string2) {
        external_parms_used = true;
        try {
            String string3;
            Object object;
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) {
                common.failure("'include=' parameter mustChange have only one subparameter: " + string);
            }
            String string4 = stringArray[1];
            String string5 = new File(string2).getCanonicalFile().getParentFile().getParent();
            if (string4.indexOf(File.separator) == -1) {
                string4 = string5 + File.separator + string4;
            }
            if (!Fget.file_exists(string4 = new File(string4).getAbsolutePath())) {
                object = string4;
                string4 = new File(stringArray[1]).getAbsolutePath();
                if (!Fget.file_exists(string4)) {
                    common.ptod("Attempted to find include file '%s'", string4);
                    common.ptod("Attempted to find include file '%s'", object);
                    common.failure("include=%s file not found", stringArray[1]);
                }
            }
            parm_html.println("\n* Contents of include file: " + string4 + "\n");
            object = new Fget(string4);
            while ((string3 = ((Fget)object).get()) != null) {
                parm_html.println(string3.replace('[', ' '));
                string3 = string3.trim();
                if (string3.startsWith("eof")) break;
                if (string3.startsWith("include=")) {
                    common.failure("Using the 'include=' parameter recusrively is not allowed: " + string3);
                }
                if (string3.startsWith("/") || string3.startsWith("#") || string3.startsWith("*") || string3.length() == 0) continue;
                string3 = InsertHosts.substituteLine(string3);
                Vdb_scan.list_of_parameters[Vdb_scan.parms_read++] = string3;
            }
            ((Fget)object).close();
            parm_html.println("\n* Continuing with original file: " + string2 + "\n");
        }
        catch (Exception exception) {
            Vdbmain.usage();
            common.failure(exception);
        }
    }

    static void xlate_command_line(String[] stringArray, int n) {
        common.ptod("Entering workload parameters from the command line, e.g. ");
        common.ptod("./vdbench - sd=sd1,lun=xxxx,.....");
        common.ptod("is no longer supported. Use of a parameter file is now required");
        common.failure("Use of parameter file is now required.");
    }

    public static void obsolete_parms_print(String string) {
    }

    public int getNumCount() {
        return this.num_count;
    }

    public int getAlphaCount() {
        return this.alpha_count;
    }

    public void mustBeNumeric() {
        if (this.num_count == 0) {
            common.failure("Numeric parameter required for '%s='.", this.keyword);
        }
    }

    public static String parms_get() {
        if (line == null) {
            Object object;
            if (parms_used == parms_read) {
                return null;
            }
            line = list_of_parameters[parms_used++];
            common.ptod("line: " + line, Vdbmain.parms_report);
            if (line.trim().startsWith("rd") && !line.trim().endsWith(",") && Vdbmain.rd_parm_extras.length() != 0) {
                object = line.trim().split(" +");
                line = object[0] + "," + Vdbmain.rd_parm_extras;
                common.ptod("Adding ',%s' to each one-line RD parameter.", Vdbmain.rd_parm_extras);
                common.ptod("Added: " + Vdbmain.rd_parm_extras, Vdbmain.parms_report);
                common.ptod("Extra: " + line, Vdbmain.parms_report);
            }
            line = Vdb_scan.specialize(line);
            while (line.endsWith(",") && parms_used != parms_read) {
                object = list_of_parameters[parms_used++];
                line = line + Vdb_scan.specialize((String)object);
            }
            st = new StringTokenizer(line, ",= ()", true);
        }
        String string = "";
        boolean bl = false;
        int n = 0;
        while (st.hasMoreTokens()) {
            String string2 = st.nextToken();
            if (string2 == null) {
                line = null;
                return string;
            }
            if (string2.equals("(")) {
                bl = true;
                ++n;
                string = string + string2;
                continue;
            }
            if (string2.equals(")") && n > 0) {
                bl = false;
                --n;
                string = string + string2;
                continue;
            }
            if (string2.equals(")") && n == 0) {
                Vdb_scan.parm_error("Unmatched Parenthesis ");
            }
            if (string2.equals(",") && n > 0) {
                string = string + string2;
                continue;
            }
            if (string2.equals(",")) {
                if (!st.hasMoreTokens()) {
                    line = null;
                }
                return string;
            }
            if (string2.equals(" ")) {
                line = null;
                return string;
            }
            if (string2.equals("?")) continue;
            string = string + string2;
        }
        line = null;
        return string;
    }

    public static String completedHostRepeat() {
        line = null;
        --parms_used;
        parms_read = list_of_parameters.length;
        parm_html.println(" ");
        parm_html.println("*");
        parm_html.println("* Parameters after $host and #host values were replaced:");
        parm_html.println("*");
        parm_html.println(" ");
        for (int i = 0; i < list_of_parameters.length; ++i) {
            parm_html.println(list_of_parameters[i]);
        }
        return Vdb_scan.parms_get();
    }

    private static String specialize(String string) {
        block0: for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            string = string.substring(0, i) + string.substring(i + 1);
            for (int j = i + 1; j < string.length(); ++j) {
                if (string.charAt(j) == '\"') {
                    string = string.substring(0, j) + string.substring(j + 1);
                    continue block0;
                }
                if (string.charAt(j) == ' ') {
                    string = string.substring(0, j) + "[" + string.substring(j + 1);
                }
                if (string.charAt(j) == ',') {
                    string = string.substring(0, j) + "^" + string.substring(j + 1);
                }
                if (string.charAt(j) == '=') {
                    string = string.substring(0, j) + "{" + string.substring(j + 1);
                }
                if (string.charAt(j) != '-') continue;
                string = string.substring(0, j) + "}" + string.substring(j + 1);
            }
        }
        if (string.indexOf(" ") != -1) {
            string = string.substring(0, string.indexOf(" "));
        }
        return string;
    }

    public long getLong() {
        return (long)this.numerics[0];
    }

    public int getInt() {
        return (int)this.numerics[0];
    }

    public int[] getIntArray() {
        int[] nArray = new int[this.numerics.length];
        for (int i = 0; i < this.numerics.length; ++i) {
            nArray[i] = (int)this.numerics[i];
        }
        return nArray;
    }

    public double getDouble() {
        return this.numerics[0];
    }

    public String getString() {
        return this.alphas[0];
    }

    public void parms_alfa_or_num(String string, int n) {
        string = string.replace('[', ' ');
        string = string.replace('^', ',');
        string = string.replace('{', '=');
        string = string.replace('}', '-');
        common.ptod("parm: " + string, Vdbmain.parms_report);
        if (this.keyword.equals("replay") || this.keyword.equals("histogram") || this.keyword.startsWith("misc")) {
            this.not_numeric(string, n);
            return;
        }
        if (this.keyword.equals("iorate") && string.equals("max")) {
            string = "" + RD_entry.MAX_RATE;
        }
        try {
            this.numerics[n] = Double.parseDouble(string);
            ++this.num_count;
        }
        catch (NumberFormatException numberFormatException) {
            this.not_numeric(string, n);
        }
    }

    private void not_numeric(String string, int n) {
        String string2;
        double d = 1.0;
        double d2 = 1024.0;
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        double d5 = d4 * d2;
        if (this.keyword.startsWith("el")) {
            d3 = 60.0;
        } else if (this.keyword.startsWith("in")) {
            d3 = 60.0;
        } else if (this.keyword.startsWith("pa")) {
            d3 = 60.0;
        } else if (this.keyword.startsWith("wa")) {
            d3 = 60.0;
        } else if (this.keyword.startsWith("reset")) {
            d3 = 60.0;
        }
        String string3 = string.substring(string.length() - 1).toLowerCase();
        if (string3.equals("b") && string.length() > 2) {
            string3 = string.substring(string.length() - 2, string.length() - 1).toLowerCase();
            string2 = string.substring(0, string.length() - 2).toLowerCase();
        } else {
            string2 = string.substring(0, string.length() - 1).toLowerCase();
        }
        if (this.keyword.equalsIgnoreCase("histogram") || this.keyword.equalsIgnoreCase("host") || this.keyword.equalsIgnoreCase("hd") || this.keyword.equalsIgnoreCase("system")) {
            this.alphas[n] = string;
            ++this.alpha_count;
            return;
        }
        if (string3.compareTo("k") == 0) {
            d = d2;
        } else if (string3.compareTo("m") == 0) {
            d = d3;
        } else if (string3.compareTo("g") == 0) {
            d = d4;
        } else if (string3.compareTo("t") == 0) {
            d = d5;
        } else if (string3.compareTo("h") == 0) {
            d = 3600.0;
        } else if (string3.compareTo("%") == 0) {
            d = -1.0;
        } else {
            this.alphas[n] = string;
            ++this.alpha_count;
            if (this.alpha_count != 0 && this.num_count != 0) {
                Vdb_scan.parm_error("Mix of alpha and numeric values not allowed: (" + this.keyword + ") " + string);
            }
            return;
        }
        try {
            Double d6 = Double.valueOf(string2);
            this.numerics[n] = d6 * d;
            ++this.num_count;
        }
        catch (NumberFormatException numberFormatException) {
            this.alphas[n] = string;
            ++this.alpha_count;
        }
    }

    void parms_array_resize() {
        String[] stringArray = new String[this.alpha_count];
        System.arraycopy(this.alphas, 0, stringArray, 0, this.alpha_count);
        this.alphas = stringArray;
        double[] dArray = new double[this.num_count];
        System.arraycopy(this.numerics, 0, dArray, 0, this.num_count);
        this.numerics = dArray;
    }

    public static Vdb_scan parms_split(String string) {
        String string2;
        Vdb_scan vdb_scan = new Vdb_scan();
        int n = 0;
        boolean bl = false;
        if (string == null) {
            common.failure("Unexpected EOF in parameter file.");
        }
        common.ptod("keyw: " + string, Vdbmain.parms_report);
        String[] stringArray = string.split("=");
        if (stringArray.length == 1) {
            Vdb_scan.parm_error("Expecting 'keyword=' in parameter: " + string);
        }
        vdb_scan.keyword = stringArray[0].toLowerCase();
        if (vdb_scan.keyword.equals("dedup")) {
            vdb_scan.raw_value = string;
            return vdb_scan;
        }
        if (vdb_scan.keyword.length() < 2) {
            Vdb_scan.parm_error("Keyword must contain a minimum of 2 characters: " + string);
        }
        if (!(string2 = string.substring(vdb_scan.keyword.length() + 1)).startsWith("(")) {
            vdb_scan.addRawValue(string2);
            vdb_scan.parms_alfa_or_num(string2, n);
            vdb_scan.parms_array_resize();
            return vdb_scan;
        }
        StringTokenizer stringTokenizer = vdb_scan.keyword.equalsIgnoreCase("host") || vdb_scan.keyword.equalsIgnoreCase("hd") || vdb_scan.keyword.startsWith("misc") || vdb_scan.keyword.equalsIgnoreCase("replay") ? new StringTokenizer(string2, ",()", true) : new StringTokenizer(string2, ",()-", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.compareTo("(") == 0 || string3.compareTo(")") == 0 || string3.compareTo(",") == 0) continue;
            if (vdb_scan.keyword.equals("fileselect") || "seekpct".startsWith(vdb_scan.keyword) || "timeout".startsWith(vdb_scan.keyword)) {
                vdb_scan.addRawValue(string3);
                continue;
            }
            if (string3.compareTo("-") == 0) {
                if (vdb_scan.getNumCount() > 0) {
                    vdb_scan.numerics[n++] = -101.0;
                    ++vdb_scan.num_count;
                } else {
                    vdb_scan.alphas[n++] = "-101a";
                    ++vdb_scan.alpha_count;
                }
                bl = true;
                continue;
            }
            if (bl && string3.compareTo("d") == 0) {
                vdb_scan.parms_alfa_or_num("-102", n++);
                bl = false;
                continue;
            }
            vdb_scan.parms_alfa_or_num(string3, n++);
        }
        Var_parms.handle_var(vdb_scan);
        vdb_scan.parms_array_resize();
        return vdb_scan;
    }

    public String toString() {
        int n;
        String string = "Vdb_scan:";
        string = string + " keyword: " + this.keyword;
        string = string + " alpha: " + this.alpha_count;
        for (n = 0; n < this.alpha_count; ++n) {
            string = string + " " + this.alphas[n];
        }
        string = string + " num: " + this.num_count;
        for (n = 0; n < this.num_count; ++n) {
            string = string + " " + this.numerics[n];
        }
        return string;
    }

    private void addRawValue(String string) {
        string = string.replace('[', ' ');
        string = string.replace('^', ',');
        string = string.replace('{', '=');
        string = string.replace('}', '-');
        this.raw_values.add(string);
    }

    public static long extractLong(String string) {
        try {
            long l = string.endsWith("k") ? Long.parseLong(string.substring(0, string.length() - 1)) * 1024L : (string.endsWith("m") ? Long.parseLong(string.substring(0, string.length() - 1)) * 1024L * 1024L : (string.endsWith("g") ? Long.parseLong(string.substring(0, string.length() - 1)) * 1024L * 1024L * 1024L : (string.endsWith("t") ? Long.parseLong(string.substring(0, string.length() - 1)) * 1024L * 1024L * 1024L * 1024L : Long.parseLong(string))));
            return l;
        }
        catch (Exception exception) {
            common.ptod("Unable to extract numeric value from '%s'", string);
            common.failure(exception);
            return 0L;
        }
    }

    public static double[] extractDoubles(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            string = string.substring(1, string.length() - 1);
        }
        String[] stringArray = string.split(",+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Vdb_scan.extractDouble(stringArray[i]);
        }
        return dArray;
    }

    public static double extractDouble(String string) {
        try {
            double d = string.endsWith("k") ? Double.parseDouble(string.substring(0, string.length() - 1)) * 1024.0 : (string.endsWith("m") ? Double.parseDouble(string.substring(0, string.length() - 1)) * 1024.0 * 1024.0 : (string.endsWith("g") ? Double.parseDouble(string.substring(0, string.length() - 1)) * 1024.0 * 1024.0 * 1024.0 : (string.endsWith("t") ? Double.parseDouble(string.substring(0, string.length() - 1)) * 1024.0 * 1024.0 * 1024.0 * 1024.0 : Double.parseDouble(string))));
            return d;
        }
        catch (Exception exception) {
            common.ptod("Unable to extract double value from '%s'", string);
            common.failure(exception);
            return 0.0;
        }
    }

    public static int extractInt(String string) {
        long l = Vdb_scan.extractLong(string);
        if (l > Integer.MAX_VALUE) {
            common.failure("Expecting integer value, receiving something larger: " + l);
        }
        return (int)l;
    }

    public static String extractpair(String string) {
        String[] stringArray = string.trim().split("=+");
        if (stringArray.length != 2) {
            common.failure("Vdbench parameter scan: expecting a pair of variables in the form of keyword=xxx: '%s'", string);
        }
        return stringArray[1];
    }

    public static ArrayList<String> splitRawParms(String string) {
        boolean bl = false;
        String string2 = null;
        if (bl) {
            common.ptod("");
            common.ptod("raw_in: " + string);
        }
        String string3 = string;
        ArrayList<String> arrayList = new ArrayList<String>(8);
        if (!string3.contains("=")) {
            common.failure("splitRawParms: expecting '=': " + string3);
        }
        String[] stringArray = string3.split("=", 2);
        for (String string42 : stringArray) {
            if (!bl) continue;
            common.ptod("split: " + string42);
        }
        if (stringArray.length != 2) {
            common.failure("splitRawParms: invalid data: " + string3);
        }
        string3 = stringArray[1];
        if (bl) {
            common.ptod("raw: " + string3);
        }
        if (string3.startsWith("(") && string3.endsWith(")")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        while (string3.length() > 0) {
            Object object;
            String string42;
            if (bl) {
                common.ptod("");
            }
            if (bl) {
                common.ptod("raw1: " + string3);
            }
            stringArray = string3.split("=", 2);
            string2 = stringArray[0];
            string3 = stringArray[1];
            if (bl) {
                common.ptod("keyword: " + string2);
            }
            if (bl) {
                common.ptod("raw2: " + string3);
            }
            int n = string3.indexOf(",");
            int n2 = string3.indexOf("(");
            if (bl) {
                common.ptod("comma: " + n);
            }
            if (bl) {
                common.ptod("paren: " + n2);
            }
            if (n == -1 && n2 == -1) {
                String string5 = string2 + "=" + stringArray[1];
                if (bl) {
                    common.ptod("tmp1: " + string5);
                }
                arrayList.add(string5);
                break;
            }
            if (n2 == 0) {
                if (!stringArray[1].contains(")")) {
                    common.failure("splitRawParms: Missing closing paren: " + string3);
                }
                object = stringArray[1].substring(0, stringArray[1].indexOf(")"));
                if (bl) {
                    common.ptod("value: " + (String)object);
                }
                string3 = string3.substring(string3.indexOf((String)object) + ((String)object).length() + 1);
                if (bl) {
                    common.ptod("raw3: " + string3);
                }
                string42 = string2 + "=" + (String)object + ")";
                if (bl) {
                    common.ptod("tmp4: " + string42);
                }
                arrayList.add(string42);
                continue;
            }
            if (n < n2) {
                object = stringArray[1].substring(0, n);
                string42 = string2 + "=" + (String)object;
                if (bl) {
                    common.ptod("tmp2: " + string42);
                }
                arrayList.add(string42);
                string3 = string3.substring(n + 1);
                continue;
            }
            if (n2 < n) {
                object = stringArray[1].substring(0, n);
                string42 = string2 + "=" + (String)object;
                if (bl) {
                    common.ptod("tmp3: " + string42);
                }
                arrayList.add(string42);
                string3 = string3.substring(n + 1);
                continue;
            }
            for (String string42 : arrayList) {
                common.ptod("dat: " + string42);
            }
            common.failure("splitRawParms:unknown state parsing: " + string);
        }
        for (String string6 : arrayList) {
            if (!bl) continue;
            common.ptod("dat: " + string6);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        double d = Double.parseDouble(stringArray[0]);
        common.ptod("tmp: " + d);
    }

    static {
        line = null;
        parm_html = null;
        list_of_parameters = new String[32768];
        parms_read = 0;
        parms_used = 0;
        external_parms_used = false;
        sd_found = false;
        wd_found = false;
        rd_found = false;
        first = true;
    }
}

