/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.Editor;
import Utils.Fget;
import Utils.Format;
import Utils.Fput;
import Utils.OS_cmd;
import Utils.Semaphore;
import Utils.Util;
import Vdb.Adm_msgs;
import Vdb.CollectSlaveStats;
import Vdb.ConcatMarkers;
import Vdb.ConcatSds;
import Vdb.ConnectSlaves;
import Vdb.CreateSdFile;
import Vdb.Ctrl_c;
import Vdb.DVPost;
import Vdb.Dedup;
import Vdb.Dist;
import Vdb.ErrorLog;
import Vdb.Flat;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwdStats;
import Vdb.HeartBeat;
import Vdb.Host;
import Vdb.HostParms;
import Vdb.InfoFromHost;
import Vdb.InsertHosts;
import Vdb.JVMCheck;
import Vdb.Jmap;
import Vdb.Jnl_entry;
import Vdb.Jstack;
import Vdb.MiscParms;
import Vdb.ParseFlat;
import Vdb.PdmStart;
import Vdb.PrintBlock;
import Vdb.PrintJournal;
import Vdb.RD_entry;
import Vdb.ReplayGroup;
import Vdb.ReplayInfo;
import Vdb.ReplayRun;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.RshDeamon;
import Vdb.SD_entry;
import Vdb.ShowLba;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SlaveSocket;
import Vdb.Status;
import Vdb.ThreadControl;
import Vdb.Tnfe_data;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.VdbenchKill;
import Vdb.WD_entry;
import Vdb.common;
import Vdb.csim;
import Vdb.dsim;
import Vdb.reporting;
import VdbComp.SdBuild;
import VdbComp.WlComp;
import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class Vdbmain {
    private static final String c = "Copyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.";
    static Vector<SD_entry> sd_list = new Vector(64, 0);
    static Vector<SD_entry> csd_list = new Vector(8);
    static Vector<WD_entry> wd_list = new Vector(64, 0);
    static Vector<RD_entry> rd_list = new Vector(64, 0);
    private static boolean workload_done;
    private static Semaphore workload_done_semaphore;
    static boolean fwd_workload;
    static boolean simulate;
    static String pdm_output;
    static String output_dir;
    static PrintWriter parms_report;
    static boolean slaves_started;
    static double observed_iorate;
    static double observed_resp;
    static double last_curve_max;
    static int elapsed;
    static int warmup;
    static int interval;
    public static String rd_parm_extras;
    static boolean force_fsd_cleanup;
    static boolean force_format_only;
    static boolean force_format_no;
    static boolean force_format_yes;
    static boolean loop_all_runs;
    static long loop_duration;
    static long loop_count;
    static long loops_done;
    static boolean checking_for_errors;
    private static Vector parm_files;
    public static volatile boolean vdbench_ended;
    static boolean kstat_console;
    private static String run_time;
    public static Reporter reporter;

    public static String getRunTime() {
        return run_time;
    }

    public static boolean isWorkloadDone() {
        return workload_done;
    }

    public static void setWorkloadDone(boolean bl) {
        workload_done = bl;
        if (workload_done) {
            workload_done_semaphore.release();
        }
    }

    public static void waitWorkloadDone() {
        try {
            workload_done_semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void print_property(String string) {
        common.plog(Format.f("%-30s", string) + System.getProperty(string));
    }

    public static void print_system() {
        File[] fileArray;
        Vdbmain.print_property("java.vendor");
        Vdbmain.print_property("java.home");
        Vdbmain.print_property("java.vm.specification.version");
        Vdbmain.print_property("java.vm.version");
        Vdbmain.print_property("java.vm.vendor");
        Vdbmain.print_property("java.specification.version");
        Vdbmain.print_property("java.class.version");
        Vdbmain.print_property("user.name");
        Vdbmain.print_property("user.dir");
        Vdbmain.print_property("java.io.tmpdir");
        Vdbmain.print_property("java.class.path");
        Vdbmain.print_property("os.name");
        Vdbmain.print_property("os.arch");
        Vdbmain.print_property("os.version");
        Vdbmain.print_property("sun.arch.data.model");
        if (!Dist.version.equals("Henk's personal development library") && (fileArray = new File(ClassPath.classPath("classes")).listFiles()) != null) {
            for (File file : fileArray) {
                File[] fileArray2 = new File(file.getAbsolutePath()).listFiles();
                if (fileArray2 == null) continue;
                for (File file2 : fileArray2) {
                    common.plog("Fixes: %s/%s %d", file.getName(), file2.getName(), file2.length());
                }
            }
        }
    }

    public static void open_print_files() {
        Report report = Report.getSummaryReport();
        ErrorLog.create();
        report.printHtmlLink("Link to errorlog", "errorlog", "errorlog");
        report.printHtmlLink("Link to flatfile", "flatfile", "flatfile");
        if (Vdbmain.isFwdWorkload()) {
            report.printHtmlLink("Link to anchor status", "anchors", "anchors");
            FwdStats.defineNamedData(output_dir);
        }
    }

    private static void check_args(String[] stringArray) {
        String[] stringArray2 = new String[1024];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("+")) {
                Vdbmain.saveRdExtras(stringArray, i);
                break;
            }
            if (i == 0 || stringArray[i].startsWith("-") || bl || bl2 || !stringArray2[n - 1].startsWith("-") || stringArray2[n - 1].startsWith("-f") && stringArray2[n - 1].length() != 2 || stringArray2[n - 1].startsWith("-o") && stringArray2[n - 1].length() != 2) {
                if (stringArray[i].compareTo("-") == 0) {
                    bl2 = true;
                }
                stringArray2[n++] = stringArray[i];
                bl = false;
                continue;
            }
            if (stringArray[i].indexOf("=") != -1) {
                stringArray2[n++] = stringArray[i];
                continue;
            }
            stringArray2[n - 1] = stringArray2[n - 1] + stringArray[i];
            bl = true;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i].startsWith("-o")) {
                output_dir = stringArray3[i].substring(2);
                continue;
            }
            if (stringArray3[i].compareTo("-s") != 0) continue;
            simulate = true;
        }
        if (pdm_output != null) {
            output_dir = pdm_output;
        }
        output_dir = reporting.rep_mkdir(output_dir);
        PdmStart.setOutputDir(output_dir);
        Validate.setOutput(output_dir);
        common.log_html = Report.createHmtlFile("logfile");
        Report.setLogReport(new Report(common.log_html, "logfile", "common.log_html"));
        Utils.common.setPlog(common.log_html);
        String string = "Copyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.\nVdbench summary report, created ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss MMM dd yyyy zzz");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss MMM dd yyyy zzz");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        common.summ_html = Report.createHmtlFile("summary.html", string + simpleDateFormat.format(new Date()) + " (" + simpleDateFormat2.format(new Date()) + ")");
        Report.setSummaryReport(new Report(common.summ_html, "summary", "common.summ_html"));
        Report.getSummaryReport().printHtmlLink("Link to logfile", "logfile", "logfile");
        Vdbmain.displayBetaWarning();
        Report.setTotalReport(new Report("totals", "Run totals"));
        Report.getSummaryReport().printHtmlLink("Run totals", "totals", "totals");
        new Status();
        Vdb_scan.parm_html = Report.createHmtlFile("parmfile.html");
        Vdbmain.scan_args(stringArray3);
        Vdbmain.print_system();
    }

    public static void scan_args(String[] stringArray) {
        String string;
        int n;
        String string2;
        int n2;
        parm_files = new Vector(8, 0);
        for (n2 = 0; n2 < stringArray.length && (string2 = stringArray[n2]) != null; ++n2) {
            if (!string2.startsWith("-o") && string2.compareTo("-s") != 0) continue;
        }
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("-t")) {
                stringArray[n] = "-f" + Vdbmain.createQuickTest(stringArray[n]);
            }
            if (!stringArray[n].startsWith("-d")) continue;
            common.set_debug(Integer.valueOf(stringArray[n].substring(2)));
        }
        for (n = 0; n < stringArray.length && (string = stringArray[n]) != null; ++n) {
            common.ptod("input argument scanned: '" + string + "'");
            if (string.indexOf("=") != -1) {
                InsertHosts.addSubstitute(string);
                n2 = 1;
                continue;
            }
            if (string.startsWith("-f")) {
                parm_files.add(string.substring(2));
                n2 = 1;
                continue;
            }
            if (n2 != 0 && !string.startsWith("-")) {
                parm_files.add(string);
                continue;
            }
            n2 = 0;
            if (string.startsWith("-o")) continue;
            if (string.startsWith("-j")) {
                Validate.setValidate();
                Validate.setJournaling();
                if (string.contains("r")) {
                    Validate.setJournalRecovery();
                }
                if (string.contains("n")) {
                    Validate.setNoJournalFlush();
                }
                if (string.contains("m")) {
                    Validate.setMapOnly();
                }
                if (string.contains("o")) {
                    Validate.setRecoveryOnly();
                }
                if (string.contains("2")) {
                    Validate.setImmediateRead();
                }
                if (string.contains("t")) {
                    Validate.setStoreTime();
                }
                if (string.contains("i")) {
                    Validate.setIgnorePending();
                }
                if (!string.contains("s")) continue;
                Validate.setSkipRead();
                continue;
            }
            if (string.startsWith("-d")) {
                common.set_debug(Integer.valueOf(string.substring(2)));
                continue;
            }
            if (string.startsWith("-v")) {
                Validate.setValidate();
                if (string.contains("r")) {
                    Validate.setImmediateRead();
                }
                if (string.contains("2")) {
                    Validate.setImmediateRead();
                }
                if (string.contains("w")) {
                    Validate.setNoPreRead();
                }
                if (string.contains("t")) {
                    Validate.setStoreTime();
                }
                if (!string.contains("c")) continue;
                common.failure("'validate=continue' no longer supported");
                Validate.setContinueOldMap();
                return;
            }
            if (string.startsWith("-c")) {
                if (string.indexOf("o") != -1) {
                    force_format_only = true;
                    continue;
                }
                if (string.indexOf("y") != -1) {
                    force_format_yes = true;
                    continue;
                }
                if (string.indexOf("n") != -1) {
                    force_format_no = true;
                    continue;
                }
                force_fsd_cleanup = true;
                continue;
            }
            if (string.startsWith("-l")) {
                Vdbmain.scanLoopParameter(string);
                continue;
            }
            if (string.compareTo("-s") == 0) {
                simulate = true;
                continue;
            }
            if (string.startsWith("-e")) {
                elapsed = Integer.valueOf(string.substring(2));
                continue;
            }
            if (string.startsWith("-w")) {
                warmup = Integer.valueOf(string.substring(2));
                continue;
            }
            if (string.startsWith("-i")) {
                interval = Integer.valueOf(string.substring(2));
                continue;
            }
            if (string.startsWith("-p")) {
                SlaveSocket.setMasterPort(Integer.valueOf(string.substring(2)));
                continue;
            }
            if (string.startsWith("-mb")) {
                Report.setDecimal();
                continue;
            }
            if (string.startsWith("-m")) {
                Host.jvmcount_override = Integer.parseInt(string.substring(2));
                continue;
            }
            if (string.compareTo("-k") == 0) {
                kstat_console = true;
                continue;
            }
            if (string.compareTo("-") == 0) {
                Vdb_scan.xlate_command_line(stringArray, n);
                continue;
            }
            if (string.startsWith("-r")) {
                RD_entry.parseRestart(string.substring(2));
                continue;
            }
            common.ptod("");
            common.ptod("Invalid execution parameter: '" + string + "'");
            Vdbmain.usage();
            common.failure("Invalid execution parameter: '" + string + "'");
        }
        if (parm_files.size() == 0) {
            Vdbmain.usage();
            common.ptod("No input parameters specified: ");
        }
    }

    public static void usage() {
        common.ptod("");
        common.ptod(" usage: ");
        common.ptod(" ./vdbench [compare] [-f xxx] [-o xxx] [-e nn] [-i nn] [-j] [-jr] [-v] [-vq] [-s] [-k] [- \"parmfile parameters\"]");
        common.ptod(" ");
        common.ptod(" '-f xxx': Workload parameter file name(s). Default 'parmfile' in current directory");
        common.ptod(" '-o xxx': Output directory for reporting. Default 'output' in current directory");
        common.ptod(" '-e nn':  Override elapsed=seconds. ");
        common.ptod(" '-i nn':  Override interval=seconds. ");
        common.ptod(" '-v':     Activate Data validation. ");
        common.ptod(" '-vq':    Activate Data validation, validate lba and data key (saves cpu) ");
        common.ptod(" '-j':     Activate Data validation with Journaling. ");
        common.ptod(" '-jr':    Recover existing Journal, Validate data and run workload ");
        common.ptod(" '-s':     Simulate execution. Do everything but I/O. ");
        common.ptod(" '-k':     Solaris only: Report kstat statistics on console. ");
        common.ptod(" ");
        common.ptod(" ");
        common.ptod("                                                                                   ");
        common.ptod("*example 1 parameter file contents, execute 'vdbench -f example1'                  ");
        common.ptod("*Single raw disk, 100% random read of 4k records at i/o rate of 100 for 10 seconds ");
        common.ptod("                                                                                   ");
        common.ptod("*SD:    Storage Definition                                                         ");
        common.ptod("*WD:    Workload Definition                                                        ");
        common.ptod("*RD:    Run Definition                                                             ");
        common.ptod("*                                                                                  ");
        common.ptod("sd=sd1,lun=/dev/rdsk/cxt0d0s0                                                      ");
        common.ptod("wd=wd1,sd=sd1,xfersize=4096,readpct=100                                            ");
        common.ptod("rd=run1,wd=wd1,iorate=100,elapsed=10,interval=1                                    ");
        common.ptod("                                                                                   ");
        common.ptod("                                                                                   ");
        common.ptod("                                                                                   ");
        common.ptod("*example 2 parameter file contents, execute 'vdbench -f example2'                  ");
        common.ptod("*Two raw disks:                                                      ");
        common.ptod("*sd1 does 80 i/o's per second, read-to-write ratio 4:1, 4k records.  ");
        common.ptod("*sd2 does 120 i/o's per second, 100% write at 8k records.            ");
        common.ptod("                                                                     ");
        common.ptod("sd=sd1,lun=/dev/rdsk/cxt0d0s0                                        ");
        common.ptod("sd=sd2,lun=/dev/rdsk/cxt0d1s0                                        ");
        common.ptod("wd=wd1,sd=sd1,xfersize=4k,readpct=80,skew=40                         ");
        common.ptod("wd=wd2,sd=sd2,xfersize=8k,readpct=0                                  ");
        common.ptod("rd=run1,wd=wd*,iorate=200,elapsed=10,interval=1                      ");
        common.ptod("                                                                     ");
        common.ptod("                                                                     ");
        common.ptod("For documentation, browse file 'vdbench.pdf' ");
    }

    public static void main(String[] stringArray) {
        if (Vdbmain.onlyOutput(stringArray)) {
            return;
        }
        String[] stringArray2 = stringArray;
        Thread.currentThread().setName("Vdbmain");
        if (Util.checkUtil(stringArray)) {
            return;
        }
        if (stringArray.length == 0) {
            Vdbmain.usage();
            common.failure("No input parameters specified");
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("SlaveJvm")) continue;
                SlaveJvm.main(stringArray);
                return;
            }
            if (stringArray.length > 0 && Vdbmain.anySpecialTricks(stringArray)) {
                return;
            }
            Ctrl_c.activateShutdownHook();
            common.stdout = new PrintWriter(System.out, true);
            System.out.println("\n\nCopyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.");
            System.out.printf("Vdbench distribution: %s %s\n", Dist.version, Dist.compiled);
            System.out.println("For documentation, see 'vdbench.pdf'.");
            System.out.println();
            pdm_output = PdmStart.lookForOutputDir(stringArray);
            Vdbmain.check_args(stringArray);
            RshDeamon.readPortNumbers();
            parms_report = Report.createHmtlFile("parmscan.html");
            Report.getSummaryReport().printHtmlLink("Copy of input parameter files", "parmfile", "parmfile");
            Report.getSummaryReport().printHtmlLink("Copy of parameter scan detail", "parmscan", "parmscan");
            Report.flushAllReports();
            Vdb_scan.Vdb_scan_read(parm_files, true);
            Vdbmain.parseParameterLines();
            if (RD_entry.getExtraWDs().size() > 0) {
                Vdb_scan.Vdb_scan_read(RD_entry.getExtraWDs(), false);
                Vdbmain.parseParameterLines();
            }
            RD_entry.parserCleanup(rd_list);
            PdmStart.setup();
            if (Dedup.isDedup()) {
                Validate.setValidateOptionsForDedup();
            }
            Flat.createFlatFile();
            Flat.define_column_headers();
            Vdbmain.masterRun();
            if (simulate) {
                RD_entry.displaySimulatedRuns();
                common.ptod("Vdbench simulation completed successfully. Output directory: %s \n", output_dir);
                common.ptod("Vdbench simulation completed successfully", common.summ_html);
            } else if (Reporter.monitor_kill) {
                common.ptod("Vdbench execution killed by user. Output directory: %s \n", output_dir);
                common.ptod("Vdbench execution killed by user", common.summ_html);
                Status.printStatus("Vdbench killed", new Object[0]);
            } else {
                common.ptod("Vdbench execution completed successfully. Output directory: %s \n", output_dir);
                common.ptod("Vdbench execution completed successfully", common.summ_html);
                Status.printStatus("Vdbench complete", new Object[0]);
            }
            Adm_msgs.terminate();
            System.out.flush();
            Tnfe_data.close();
            Host.closeAdmMessagesFiles();
            vdbench_ended = true;
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
        Ctrl_c.removeShutdownHook();
        ThreadControl.waitForShutdownAll();
        ThreadControl.printActiveThreads();
        OS_cmd.killAll();
        common.memory_usage();
        Report.closeAllReports();
    }

    private static void parseParameterLines() {
        String string = MiscParms.readParms();
        string = HostParms.readParms(string);
        String[] stringArray = Vdb_scan.list_of_parameters;
        Vdb_scan.list_of_parameters = InsertHosts.replaceNumberOfHosts(stringArray);
        if (InsertHosts.anyChangesMade(stringArray, Vdb_scan.list_of_parameters = InsertHosts.repeatParameters(Vdb_scan.list_of_parameters))) {
            Vdb_scan.external_parms_used = true;
            string = Vdb_scan.completedHostRepeat();
        }
        InsertHosts.lookForMissingSubstitutes(Vdb_scan.list_of_parameters);
        string = ReplayRun.readParms(string);
        string = FsdEntry.readParms(string);
        string = SD_entry.readParms(sd_list, string);
        string = WD_entry.readParms(wd_list, string);
        if (string == null) {
            return;
        }
        string = FwdEntry.readParms(string);
        string = RD_entry.readParms(rd_list, string);
        if (Validate.sdConcatenation()) {
            ConcatSds.createConcatSds(wd_list, rd_list);
        }
        if (Validate.isJournalRecovery()) {
            if (Vdbmain.isWdWorkload()) {
                Jnl_entry.setupSDJournalRecoveryRun();
            } else {
                Jnl_entry.setupFsdJournalRecoveryRun();
            }
        }
        Host.checkDuplicates();
        Report.setupAuxReporting();
    }

    private static void masterRun() {
        Host.createSlaves();
        if (Vdbmain.isFwdWorkload()) {
            rd_list = RD_entry.buildNewRdListForFwd();
        } else {
            RD_entry.buildNewRdListForWd();
            RD_entry.printWgInfo("Begin second pass....", new Object[0]);
            rd_list = RD_entry.buildNewRdListForWd();
            RD_entry.printWgInfo("End second pass....", new Object[0]);
            RD_entry.printWgInfo("", new Object[0]);
        }
        if (simulate) {
            return;
        }
        Vdbmain.open_print_files();
        Report.createHostSummaryFiles();
        Report.createSlaveSummaryFiles();
        Report.createSummaryHistogramFile();
        Report.createSkewFile();
        Report.chModAllReports();
        ConnectSlaves.createSocketToSlaves();
        SlaveList.startSlaves();
        ConnectSlaves.connectToSlaves();
        slaves_started = true;
        new HeartBeat(true).start();
        if (ReplayInfo.isReplay()) {
            SD_entry.adjustReplay(sd_list);
        }
        if (Validate.sdConcatenation()) {
            ConcatMarkers.writeMarkers();
        }
        InfoFromHost.askHostsForStuff();
        if (Vdbmain.isWdWorkload() && !MiscParms.do_not_format_sds && CreateSdFile.insertFormatsIfNeeded()) {
            RD_entry.createWgListForOneRd(rd_list.firstElement(), true);
        }
        if (Validate.isRealValidate() || Validate.isValidateForDedup()) {
            SD_entry.calculateKeyBlockSizes();
        }
        if (ReplayInfo.isReplay()) {
            ReplayGroup.calculateGroupSDSizes(sd_list);
        }
        if (Vdbmain.isWdWorkload()) {
            RD_entry.finalizeWgEntries();
        }
        Report.createOtherReportFiles();
        InfoFromHost.checkCpuReporting();
        common.run_config_scripts();
        if (ReplayInfo.isReplay()) {
            ReplayRun.setupTraceRun();
        }
        if (simulate) {
            SlaveList.shutdownAllSlaves();
            ThreadControl.shutdownAll("Vdb.HeartBeat");
            SlaveList.waitForAllSlavesShutdown();
            return;
        }
        reporter = new Reporter();
        CollectSlaveStats collectSlaveStats = new CollectSlaveStats(reporter);
        reporter.start();
        collectSlaveStats.start();
        while (reporter.isAlive()) {
            common.sleep_some(1000L);
        }
        if (!simulate) {
            SlaveList.shutdownAllSlaves();
        }
        ThreadControl.shutdownAll("Vdb.HeartBeat");
        SlaveList.waitForAllSlavesShutdown();
    }

    public static void setFwdWorkload() {
        fwd_workload = true;
    }

    public static boolean isFwdWorkload() {
        if (SlaveJvm.isThisSlave()) {
            common.failure("'isFwdWorkload' for Vdbmain requested on slave");
        }
        return fwd_workload;
    }

    public static boolean isWdWorkload() {
        if (SlaveJvm.isThisSlave()) {
            common.failure("'isWdWorkload' for Vdbmain requested on slave");
        }
        return !fwd_workload;
    }

    private static void displayBetaWarning() {
        Object object;
        common.log_html.println(c);
        common.log_html.println("Vdbench distribution: " + Dist.version + "\n");
        if (Fget.file_exists(ClassPath.classPath("Owner.txt"))) {
            object = new Fget(ClassPath.classPath("Owner.txt"));
            common.plog("Owner string: " + ((Fget)object).get());
            ((Fget)object).close();
        }
        try {
            object = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            if (Dist.compiled == null || Dist.compiled == null) {
                return;
            }
            if (Dist.version.indexOf("rc") != -1 || Dist.version.indexOf("beta") != -1) {
                Date date = ((DateFormat)object).parse(Dist.compiled);
                Date date2 = new Date();
                if (date2.getTime() - date.getTime() > 7776000000L) {
                    common.ptod("*");
                    common.ptod("* This beta version '" + Dist.version + "' was built on " + Dist.compiled + ".");
                    common.ptod("* which is more than 90 days ago.");
                    common.ptod("* It is recommended that you look for a newer beta or possibly");
                    common.ptod("* a newer GA version.");
                    common.ptod("* Of course, it is preferred you download a newer beta version");
                    common.ptod("* if available to help test the latest code.");
                    common.ptod("*");
                    common.psum("*");
                    common.psum("* This beta version '" + Dist.version + "' was built on " + Dist.compiled + ".");
                    common.psum("* which is more than 90 days ago.");
                    common.psum("* It is recommended that you look for a newer beta or possibly");
                    common.psum("* a newer GA version.");
                    common.psum("* Of course, it is preferred you download a newer beta version");
                    common.psum("* if available to help test the latest code.");
                    common.psum("*");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("No valid compile date present: " + Dist.version + "/" + Dist.compiled);
        }
    }

    private static void checkJavaVersion() {
        if (common.get_debug(common.USE_ANY_JAVA)) {
            return;
        }
        if (!JVMCheck.isJREValid(System.getProperty("java.version"), 1, 7, 0)) {
            System.out.print("*\n*\n*\n");
            System.out.println("* Minimum required Java version for Vdbench is 1.7.0; \n* You are currently running " + System.getProperty("java.version") + "\n* Vdbench terminated.");
            System.out.println("*\n*\n*\n");
            System.exit(-99);
        }
    }

    private static boolean anySpecialTricks(String[] stringArray) {
        try {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            if (stringArray[0].equalsIgnoreCase("compare")) {
                WlComp.main(stringArray);
            } else if (stringArray[0].toLowerCase().startsWith("parse")) {
                ParseFlat.main(stringArray);
            } else if (stringArray[0].equals("jstack")) {
                Jstack.main(stringArray);
            } else if (stringArray[0].equals("jmap")) {
                Jmap.main(stringArray);
                common.exit(0);
            } else if (stringArray[0].equalsIgnoreCase("sds")) {
                SdBuild.main(stringArray);
            } else if (stringArray[0].equalsIgnoreCase("showlba")) {
                ShowLba.main(stringArray);
            } else if (stringArray[0].equalsIgnoreCase("rsh")) {
                RshDeamon.main(stringArray);
            } else if (stringArray.length > 0 && (stringArray[0].equalsIgnoreCase("print") || stringArray[0].equalsIgnoreCase("-print"))) {
                PrintBlock.print(stringArray);
            } else if (stringArray[0].equalsIgnoreCase("dvpost")) {
                common.failure("DvPost no longer exists in the current verion. That decision possibly needs to be re-evaluated");
                DVPost.main(stringArray);
            } else if (stringArray[0].equalsIgnoreCase("edit")) {
                Editor.main(stringArray2);
            } else if (stringArray[0].equalsIgnoreCase("csim")) {
                csim.main(stringArray2);
            } else if (stringArray[0].equalsIgnoreCase("dsim")) {
                dsim.main(stringArray2);
            } else if (stringArray[0].equalsIgnoreCase("printjournal")) {
                PrintJournal.main(stringArray2);
            } else if (stringArray[0].equalsIgnoreCase("kill")) {
                VdbenchKill.main(stringArray2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            common.failure(exception);
            return false;
        }
    }

    private static String createQuickTest(String string) {
        try {
            String string2 = Fput.getTmpDir();
            Fput fput = new Fput(string2, "parmfile");
            String string3 = "";
            if (string.equals("-td")) {
                new File(string2, "quick_vdbench_test").delete();
            }
            if (string.equals("-t1")) {
                if (common.onSolaris()) {
                    string3 = ",openflags=o_sync";
                }
                if (common.onWindows()) {
                    string3 = ",openflags=directio";
                }
                if (common.onLinux()) {
                    string3 = ",openflags=o_sync";
                }
                fput.println("*");
                fput.println("* This sample parameter file first creates a temporary file");
                fput.println("* if this is the first time the file is referenced.");
                fput.println("* It then does a five second 1k 50% read, 50% write test.");
                fput.println("*");
                fput.println("sd=sd1,lun=" + string2 + "quick_vdbench_test,size=40m" + string3);
                fput.println("wd=wd1,sd=sd1,xf=1k,rdpct=50");
                fput.println("rd=rd1,wd=wd1,iorate=100,elapsed=5,interval=1");
            } else if (string.equals("-t2")) {
                fput.println("*");
                fput.println("* This sample parameter file first creates a temporary file");
                fput.println("* if this is the first time the file is referenced.");
                fput.println("* It then does a five second 1k 50% read, 50% write test.");
                fput.println("*");
                fput.println("sd=sd1,lun=" + string2 + "quick_vdbench_test,size=40m");
                fput.println("wd=wd1,sd=sd1,xf=1k,rdpct=0");
                fput.println("rd=rd1,wd=wd1,iorate=max,elapsed=5,interval=1");
            } else if (string.equals("-tf")) {
                fput.println("");
                fput.println("                                                                             ");
                fput.println("* Random read and write of randomly selected files.                          ");
                fput.println("*                                                                            ");
                fput.println("* 'format=yes' first creates (depth*width*files) 100 128k files.             ");
                fput.println("* Test then will have eight threads each randomly select a file and do random");
                fput.println("* reads.  After 'stopafter=100' reads the file is closed and a new           ");
                fput.println("* file is randomly selected.                                                 ");
                fput.println("* An other eight threads will do the same, but only for writes.              ");
                fput.println("*                                                                            ");
                fput.println("                                                                             ");
                fput.println("fsd=fsd1,anchor=" + string2 + "fsd1,depth=1,width=1,files=100,size=128k       ");
                fput.println("                                                                             ");
                fput.println("fwd=default,xfersize=4k,fileio=random,fileselect=random,threads=8,           ");
                fput.println("stopafter=100                                                                ");
                fput.println("fwd=fwd1,fsd=fsd1,operation=read                                             ");
                fput.println("fwd=fwd2,fsd=fsd1,operation=write                                            ");
                fput.println("                                                                             ");
                fput.println("rd=rd1,fwd=fwd*,fwdrate=100,format=yes,elapsed=5,interval=1                  ");
            } else {
                fput.println("*");
                fput.println("* This sample parameter file first creates a temporary file");
                fput.println("* if this is the first time the file is referenced.");
                fput.println("* It then does a five second 4k 50% read, 50% write test.");
                fput.println("*");
                fput.println("sd=sd1,lun=" + string2 + "quick_vdbench_test,size=40m");
                fput.println("wd=wd1,sd=sd1,xf=1k,rdpct=50");
                fput.println("rd=rd1,wd=wd1,iorate=100,elapsed=5,interval=1");
            }
            fput.close();
            return fput.getName();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    private static void saveRdExtras(String[] stringArray, int n) {
        String string = stringArray[n].trim();
        if (!string.equals("+")) {
            rd_parm_extras = string.substring(1).trim() + " ";
        }
        ++n;
        while (n < stringArray.length) {
            rd_parm_extras = rd_parm_extras + stringArray[n].trim() + " ";
            ++n;
        }
        if ((rd_parm_extras = rd_parm_extras.trim()).indexOf(" ") != -1) {
            common.failure("Embedded blanks not acceptable: '%s'", rd_parm_extras);
        }
    }

    private static void scanLoopParameter(String string) {
        loop_all_runs = true;
        if (string.equals("-l")) {
            return;
        }
        String string2 = string.substring(2);
        int n = 1;
        if (string2.endsWith("s")) {
            n = 1;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("m")) {
            n = 60;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("h")) {
            n = 3600;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (!common.isNumeric(string2)) {
            common.failure("Expecting no parameter or a numeric paramater after '-l': " + string);
        }
        loop_duration = Long.parseLong(string2) * (long)n;
        loop_duration *= 1000L;
    }

    private static boolean onlyOutput(String[] stringArray) {
        if (stringArray.length != 2) {
            return false;
        }
        if (!stringArray[0].equals("-o")) {
            return false;
        }
        String string = reporting.rep_mkdir(stringArray[1]);
        System.out.println(string);
        return true;
    }

    static {
        workload_done_semaphore = new Semaphore(0L);
        fwd_workload = false;
        simulate = false;
        pdm_output = null;
        output_dir = "output";
        slaves_started = false;
        observed_iorate = 10000.0;
        observed_resp = 0.0;
        last_curve_max = 10000.0;
        elapsed = 0;
        warmup = 0;
        interval = 0;
        rd_parm_extras = "";
        force_fsd_cleanup = false;
        force_format_only = false;
        force_format_no = false;
        force_format_yes = false;
        loop_all_runs = false;
        loop_duration = Long.MAX_VALUE;
        loop_count = Long.MAX_VALUE;
        loops_done = 0L;
        checking_for_errors = true;
        vdbench_ended = false;
        kstat_console = false;
        run_time = new SimpleDateFormat("yyMMdd-HH.mm.ss.SSS").format(new Date());
        reporter = null;
    }
}

