/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.HotBand;
import Vdb.JniIndex;
import Vdb.Native;
import Vdb.RD_entry;
import Vdb.SD_entry;
import Vdb.Validate;
import Vdb.WG_entry;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

class WG_context
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    long next_seq = -1L;
    long last_lba;
    long seek_low;
    long seek_high;
    long seek_width;
    long max_xfersize;
    boolean crossing_range_boundary = false;
    HotBand hotband = null;
    private static HashMap<Integer, Integer> index_map = null;

    WG_context() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static void setup_jni_context(ArrayList<WG_entry> arrayList) {
        RD_entry rD_entry = RD_entry.next_rd;
        Native.allocSharedMemory();
        index_map = new HashMap(16);
        for (int i = 0; i < arrayList.size(); ++i) {
            WG_entry wG_entry = arrayList.get(i);
            SD_entry sD_entry = wG_entry.sd_used;
            if (sD_entry.sd_name8 == null) {
                common.failure("Missing 8-digit internal SD name for sd=%s", sD_entry.sd_name);
            }
            if (wG_entry.hcontext == null) {
                common.failure("hcontext is missing for " + wG_entry.wg_name);
            }
            if (wG_entry.mcontext == null) {
                common.failure("mcontext is missing for " + wG_entry.wg_name);
            }
            if (!Validate.sdConcatenation()) {
                JniIndex jniIndex = wG_entry.jni_index_list.get(0);
                Native.setup_jni_context(jniIndex.jni_index, sD_entry.sd_name8, jniIndex.old_stats.read_hist.getJniBucketArray(), jniIndex.old_stats.write_hist.getJniBucketArray());
                WG_context.checkIndexMap(jniIndex.jni_index);
                continue;
            }
            for (int j = 0; j < wG_entry.sds_in_concatenation.size(); ++j) {
                SD_entry sD_entry2 = wG_entry.sds_in_concatenation.get(j);
                JniIndex jniIndex = wG_entry.jni_index_list.get(j);
                Native.setup_jni_context(jniIndex.jni_index, sD_entry.sd_name8, jniIndex.old_stats.read_hist.getJniBucketArray(), jniIndex.old_stats.write_hist.getJniBucketArray());
                WG_context.checkIndexMap(jniIndex.jni_index);
            }
        }
        if (common.get_debug(common.TIMEBEGINPERIOD)) {
            long l = Native.allocBuffer(-1);
            common.ptod("TIMEBEGINPERIOD return code: " + l);
            if (l == 97L) {
                common.failure("Windows timeBeginPeriod() call failed");
            }
        }
    }

    private static void checkIndexMap(int n) {
        if (index_map.get(n) != null) {
            common.failure("JNI index %d already exists", n);
        }
        index_map.put(n, n);
    }
}

