/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Cmd_entry;
import Vdb.DeltaCompare;
import Vdb.FifoList;
import Vdb.Native;
import Vdb.ReplayInfo;
import Vdb.Signal;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.ThreadMonitor;
import Vdb.Validate;
import Vdb.WG_entry;
import Vdb.common;
import java.util.ArrayList;
import java.util.Collections;

public class WT_task
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static ArrayList<WG_entry> wgs_to_scan;
    private Task_num tn;
    private static int priorities;
    private static long rr_index;
    private static ThreadMonitor tmonitor;
    private static final boolean spin;
    private static boolean sd_concatenation;
    public static Object sleep_lock;
    public static int sleeping;
    public static long sleep_count;
    public static long sleep_last;
    private static boolean list_sort;
    static long passes;
    static long attempts;
    private static ArrayList sorted_list;
    private static int index;

    WT_task(Task_num task_num) {
        priorities = FifoList.countPriorities(SlaveWorker.work.wgs_for_slave);
        this.tn = task_num;
        this.tn.task_set_start_pending();
        sd_concatenation = Validate.sdConcatenation();
        this.setName("WT_task");
    }

    @Override
    public void run() {
        Cmd_entry cmd_entry = null;
        wgs_to_scan = new ArrayList<WG_entry>(SlaveWorker.work.wgs_for_slave);
        sorted_list.clear();
        Thread.currentThread().setPriority(9);
        try {
            long l;
            tmonitor = new ThreadMonitor("WT_task", null, null);
            this.tn.task_set_start_complete();
            this.tn.waitForMasterGo();
            if (ReplayInfo.isReplay()) {
                this.waitForAllFifosActive();
            }
            WT_task.buildFifoSearchList();
            SlaveWorker.first_tod = l = Native.get_simple_tod();
            long l2 = 0L;
            long l3 = l;
            block6: while (!SlaveJvm.isWorkloadDone() && (cmd_entry = WT_task.getLowest(l)) != null) {
                long l4 = cmd_entry.delta_tod + SlaveWorker.first_tod;
                while (l < l4 && (l = Native.get_simple_tod()) < l4) {
                    if (spin) continue;
                    if (priorities > 1) {
                        common.sleep_some_usecs(1L);
                        continue block6;
                    }
                    long l5 = l4 - l;
                    if (common.get_debug(common.NATIVE_SLEEP)) {
                        Native.nativeSleep(l5 * 1000L);
                    } else {
                        common.sleep_some_usecs(Math.min(1000000L, l5));
                        l2 += Math.min(1000000L, l5);
                        tmonitor.add2();
                    }
                    if (!Thread.interrupted()) continue;
                    common.plog("WT Task interrupted at sleep");
                    break;
                }
                try {
                    if (cmd_entry == null) {
                        common.failure("WT_task error1");
                    }
                    if (cmd_entry.sd_ptr == null) {
                        common.failure("WT_task error2");
                    }
                    if (!sd_concatenation && cmd_entry.sd_ptr.fifo_to_iot == null) {
                        common.failure("WT_task error3 " + cmd_entry.sd_ptr.sd_name);
                    }
                    if (cmd_entry.cmd_wg == null) {
                        common.failure("WT_task error4");
                    }
                    if (priorities == 1) {
                        cmd_entry.sd_ptr.fifo_to_iot.waitAndPut(cmd_entry, cmd_entry.cmd_wg.getpriority());
                    } else {
                        cmd_entry.sd_ptr.fifo_to_iot.put(cmd_entry, cmd_entry.cmd_wg.getpriority());
                    }
                    tmonitor.add1();
                }
                catch (InterruptedException interruptedException) {
                    common.plog("WT Task interrupted at put");
                    break;
                }
                try {
                    if (list_sort) continue;
                    cmd_entry.cmd_wg.pending_cmd = (Cmd_entry)cmd_entry.cmd_wg.fifo_to_wait.get();
                    if (cmd_entry.cmd_wg.pending_cmd == null) break;
                    if (cmd_entry.cmd_wg.pending_cmd.delta_tod != Long.MAX_VALUE) continue;
                    wgs_to_scan.remove(cmd_entry.cmd_wg);
                }
                catch (InterruptedException interruptedException) {
                    common.plog("WT Task interrupted at get");
                    break;
                }
            }
            common.plog("Ended WT_task");
            this.tn.task_set_terminating(0.0);
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    private static synchronized Cmd_entry getLowest(long l) {
        if (!list_sort) {
            return WT_task.getLowestOne(l);
        }
        return WT_task.getLowestList(l);
    }

    private static synchronized Cmd_entry getLowestOne(long l) {
        ++passes;
        WG_entry wG_entry = null;
        if (wgs_to_scan.size() == 0) {
            return null;
        }
        try {
            int n;
            boolean bl = false;
            do {
                bl = false;
                int n2 = (int)(rr_index++ % (long)wgs_to_scan.size());
                n = 0;
                while (n < wgs_to_scan.size()) {
                    wG_entry = wgs_to_scan.get(n2 % wgs_to_scan.size());
                    if (priorities == 1) {
                        bl = true;
                        break;
                    }
                    if (wG_entry.pending_cmd == null) {
                        common.failure("oops1");
                    }
                    if (wG_entry.pending_cmd.sd_ptr == null) {
                        common.failure("oops2");
                    }
                    if (wG_entry.pending_cmd.sd_ptr.fifo_to_iot == null) {
                        common.failure("oops3");
                    }
                    if (!wG_entry.pending_cmd.sd_ptr.fifo_to_iot.isGettingFull(wG_entry.getpriority())) {
                        bl = true;
                        break;
                    }
                    ++n;
                    ++n2;
                }
                if (!bl && !spin) {
                    common.sleep_some_usecs(1L);
                }
                if (!SlaveJvm.isWorkloadDone()) continue;
                return null;
            } while (!bl);
            Cmd_entry cmd_entry = wG_entry.pending_cmd;
            for (n = 0; n < wgs_to_scan.size(); ++n) {
                ++attempts;
                WG_entry wG_entry2 = wgs_to_scan.get(n);
                if (wG_entry2 == wG_entry || priorities != 1 && wG_entry2.pending_cmd.sd_ptr.fifo_to_iot.isGettingFull(wG_entry2.getpriority()) && wG_entry.pending_cmd.delta_tod != Long.MAX_VALUE || wG_entry.pending_cmd.delta_tod <= wG_entry2.pending_cmd.delta_tod) continue;
                wG_entry = wG_entry2;
                cmd_entry = wG_entry.pending_cmd;
            }
            return cmd_entry;
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("lowwg: " + wG_entry);
            common.ptod("lowwg.pending_cmd: " + wG_entry.pending_cmd);
            common.ptod("lowwg.pending_cmd.sd_ptr: " + wG_entry.pending_cmd.sd_ptr);
            common.ptod("lowwg.pending_cmd.sd_ptr.wt_to_iot: " + wG_entry.pending_cmd.sd_ptr.fifo_to_iot);
            common.failure(exception);
            return null;
        }
    }

    private static synchronized Cmd_entry getLowestList(long l) {
        Object var2_1 = null;
        if (wgs_to_scan.size() == 0) {
            return null;
        }
        if (sorted_list.size() != 0 && index < sorted_list.size()) {
            Cmd_entry cmd_entry = (Cmd_entry)sorted_list.get(index++);
            return cmd_entry;
        }
        long l2 = System.currentTimeMillis();
        sorted_list.clear();
        long l3 = 1000L;
        passes = 0L;
        int n = 0;
        do {
            ++passes;
            l3 += 1000L;
            block3: for (int i = 0; i < wgs_to_scan.size(); ++i) {
                WG_entry wG_entry = wgs_to_scan.get(i);
                if (wG_entry == null) continue;
                for (int j = 0; j < 2; ++j) {
                    Cmd_entry cmd_entry = wG_entry.pending_cmd;
                    if (cmd_entry.delta_tod + SlaveWorker.first_tod > l + l3) continue block3;
                    try {
                        sorted_list.add(cmd_entry);
                        wG_entry.pending_cmd = (Cmd_entry)wG_entry.fifo_to_wait.get();
                        if (wG_entry.pending_cmd != null) continue;
                        return null;
                    }
                    catch (InterruptedException interruptedException) {
                        common.plog("WT Task interrupted at get");
                        return null;
                    }
                }
            }
        } while (sorted_list.size() < wgs_to_scan.size());
        if (n > 0) {
            while (wgs_to_scan.remove(null)) {
            }
        }
        Collections.sort(sorted_list, new DeltaCompare());
        Cmd_entry cmd_entry = (Cmd_entry)sorted_list.get(0);
        index = 1;
        return cmd_entry;
    }

    public static synchronized void buildFifoSearchList() {
        Signal signal = new Signal(1);
        ArrayList<WG_entry> arrayList = SlaveWorker.work.wgs_for_slave;
        ArrayList<WG_entry> arrayList2 = new ArrayList<WG_entry>(arrayList.size());
        while (true) {
            for (int i = 0; i < arrayList.size(); ++i) {
                WG_entry wG_entry = arrayList.get(i);
                if (wG_entry.suspend_fifo_use) continue;
                arrayList2.add(wG_entry);
                if (wG_entry.pending_cmd != null) continue;
                try {
                    wG_entry.pending_cmd = (Cmd_entry)wG_entry.fifo_to_wait.get();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    common.ptod("Interrupt during first get");
                    common.interruptThread();
                    return;
                }
            }
            if (arrayList2.size() > 0) break;
            if (signal.go()) {
                common.ptod("WT_task.buildFifoSearchList(): waiting for work from at least one workload generator thread");
            }
            common.sleep_some(100L);
        }
        wgs_to_scan = arrayList2;
    }

    private void waitForAllFifosActive() {
        Signal signal = new Signal(10);
        double d = System.currentTimeMillis();
        while (!signal.go()) {
            int n = 0;
            for (WG_entry wG_entry : SlaveWorker.work.wgs_for_slave) {
                if (wG_entry.fifo_to_wait.getQueueDepth() <= 0) continue;
                ++n;
            }
            if (n >= SlaveWorker.work.wgs_for_slave.size()) {
                double d2 = System.currentTimeMillis();
                common.ptod("waitForAllFifosActive: %.2f seconds ", (d2 - d) / 1000.0);
                return;
            }
            common.sleep_some(10L);
        }
        for (WG_entry wG_entry : SlaveWorker.work.wgs_for_slave) {
            common.ptod("waitForAllFifosActive: waiting for " + wG_entry.fifo_to_wait.getLabel() + " " + wG_entry.fifo_to_wait.getQueueDepth());
        }
        common.failure("waitForAllFifosActive: unable to obtain stable fifo count after %d seconds", signal.getDuration());
    }

    static {
        rr_index = 0L;
        tmonitor = null;
        spin = common.get_debug(common.SPIN);
        sleep_lock = new Object();
        sleeping = 1;
        sleep_count = 0L;
        sleep_last = 0L;
        list_sort = common.get_debug(common.WT_TASK_LIST_SORT);
        passes = 0L;
        attempts = 0L;
        sorted_list = new ArrayList(1024);
        index = 0;
    }
}

