/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Kstat_cpu;
import Vdb.Report;
import Vdb.SdStats;
import Vdb.Vdbmain;
import Vdb.WD_entry;

public class WdReport
extends Report {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";

    public static void createRunWdReports() {
        if (Vdbmain.wd_list.size() < 2) {
            return;
        }
        int n = 0;
        for (WD_entry wD_entry : Vdbmain.wd_list) {
            if (!wD_entry.wd_is_used) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        Report.getSummaryReport().println("");
        for (WD_entry wD_entry : Vdbmain.wd_list) {
            if (!wD_entry.wd_is_used) continue;
            String string = wD_entry.wd_name;
            Report report = new Report(string, "Workload Report for wd=" + string);
            Report.getSummaryReport().printHtmlLink("Link to workload report", report.getFileName(), string);
            Report report2 = new Report((Object)string, "histogram", "wd=" + string + " response time histogram.");
            report.printHtmlLink("Link to response time histogram", report2.getFileName(), "histogram");
        }
    }

    public static void reportWdStats() {
        if (Vdbmain.wd_list.size() < 2) {
            return;
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getIntervalCpuStats();
        for (WD_entry wD_entry : Vdbmain.wd_list) {
            if (!wD_entry.wd_is_used || !wD_entry.isWdUsedThisRd()) continue;
            String string = wD_entry.wd_name;
            SdStats sdStats = Report.getReport(string).getData().getIntervalSdStats();
            WdReport.getReport(string).reportDetail(sdStats, kstat_cpu);
        }
    }

    public static void reportWdTotalStats() {
        if (Vdbmain.wd_list.size() < 2) {
            return;
        }
        String string = Report.getAvgLabel();
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getTotalCpuStats();
        for (WD_entry wD_entry : Vdbmain.wd_list) {
            if (!wD_entry.wd_is_used || !wD_entry.isWdUsedThisRd()) continue;
            SdStats sdStats = WdReport.getReport(wD_entry.wd_name).getData().getTotalSdStats();
            WdReport.getReport(wD_entry.wd_name).reportDetail(sdStats, kstat_cpu, string);
            WdReport.getReport(wD_entry.wd_name, "histogram").println(sdStats.printHistograms());
        }
    }
}

