/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BoxPrint;
import Vdb.Host;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.Slave;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WD_entry;
import Vdb.WG_entry;
import Vdb.common;
import java.util.HashMap;

public class WhereWhatWork {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static HashMap<String, Slave> dv_sdmap = new HashMap(8);
    private static HashMap<String, Slave> seq_wdmap = new HashMap(8);

    public static void checkWorkForSlave0(RD_entry rD_entry) {
        for (Host host : Host.getDefinedHosts()) {
            int n = 0;
            for (Slave slave : host.getSlaves()) {
                if (slave.getCurrentWork() == null) continue;
                ++n;
            }
            if (n <= 0 || host.getSlaves().get(0).getCurrentWork() != null) continue;
            BoxPrint boxPrint = new BoxPrint();
            boxPrint.add("If ANY work is selected for a host the first slave on that host MUST have work.", new Object[0]);
            boxPrint.add("rd=%s", rD_entry.rd_name);
            boxPrint.add("", new Object[0]);
            boxPrint.add("Workaround: adjust thread or JVM count, see 'jvms=' in the doc.", new Object[0]);
            boxPrint.print();
            common.failure("If ANY work is selected for a host the first slave on that host MUST have work.");
        }
    }

    public static void clearWdMap() {
        seq_wdmap.clear();
    }

    public static void clearDvMap() {
        dv_sdmap.clear();
    }

    public static void addDvSd(WG_entry wG_entry, Slave slave) {
        dv_sdmap.put(wG_entry.sd_used.sd_name, slave);
        RD_entry.printWgInfo("addDvSd wd=%s,sd=%s for slave %s", wG_entry.wd_name, wG_entry.sd_used.sd_name, slave.getLabel());
    }

    public static Slave getDvSlave(String string) {
        return dv_sdmap.get(string);
    }

    public static void paranoiaDvCheck() {
        if (!Validate.isRealValidate()) {
            return;
        }
        if (!Vdbmain.isWdWorkload()) {
            return;
        }
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            for (WG_entry wG_entry2 : RD_entry.getAllWorkloads()) {
                if (wG_entry == wG_entry2 || wG_entry.getSlave() == wG_entry2.getSlave() || !wG_entry.sd_used.sd_name.equals(wG_entry2.sd_used.sd_name)) continue;
                BoxPrint boxPrint = new BoxPrint();
                boxPrint.add("Sending Data Validation for sd=%s to multiple slaves.", wG_entry.sd_used.sd_name);
                boxPrint.add("", new Object[0]);
                boxPrint.add("This will lead to false data corruptions being reported.", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("This is a Vdbench bug, please report it.", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("Workaround: use only a single slave, see 'jvms=' in the doc,", new Object[0]);
                boxPrint.add("or, if multiple hosts are used, cut down to a single host with single JVM.", new Object[0]);
                boxPrint.print();
                common.failure("Sending Data Validation sd=%s to multiple slaves.", wG_entry.sd_used.sd_name);
            }
        }
    }

    public static void rememberWhereDvWent() {
        if (!Validate.isRealValidate()) {
            return;
        }
        if (!Vdbmain.isWdWorkload()) {
            return;
        }
        for (WG_entry wG_entry : RD_entry.getAllWorkloads()) {
            wG_entry.sd_used.slave_used_for_dv = wG_entry.getSlave();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printWorkForSlaves(String string, RD_entry rD_entry) {
        void var3_12;
        if (!Vdbmain.isWdWorkload()) {
            return;
        }
        if (!common.get_debug(common.DETAIL_SLV_REPORT)) {
            return;
        }
        RD_entry.printWgInfo2("", new Object[0]);
        RD_entry.printWgInfo2(string, new Object[0]);
        RD_entry.printWgInfo2("SlaveList.printWorkForSlaves() for rd=%s (%s)", rD_entry.rd_name, RD_entry.next_rd.use_waiter ? "w" : "nw");
        RD_entry.printWgInfo2("Sort order: WD", new Object[0]);
        for (WG_entry comparable : WG_entry.sortWorkloads(RD_entry.getAllWorkloads(), "wd")) {
            RD_entry.printWgInfo2(comparable.report(rD_entry), new Object[0]);
        }
        RD_entry.printWgInfo2("Sort order: slave", new Object[0]);
        for (WG_entry wG_entry : WG_entry.sortWorkloads(RD_entry.getAllWorkloads(), "slave")) {
            RD_entry.printWgInfo2(wG_entry.report(rD_entry), new Object[0]);
        }
        RD_entry.printWgInfo2("Sort order: SD", new Object[0]);
        for (WG_entry wG_entry : WG_entry.sortWorkloads(RD_entry.getAllWorkloads(), "sd")) {
            RD_entry.printWgInfo2(wG_entry.report(rD_entry), new Object[0]);
        }
        RD_entry.printWgInfo2("", new Object[0]);
        for (Host host : Host.getDefinedHosts()) {
            boolean bl = false;
            for (Slave slave : host.getSlaves()) {
                HashMap<String, String> hashMap = new HashMap<String, String>(8);
                int n = 0;
                if (slave.getCurrentWork() == null) continue;
                double d = 0.0;
                for (WG_entry wG_entry : slave.getCurrentWork().wgs_for_slave) {
                    hashMap.put(wG_entry.wd_name, wG_entry.wd_name);
                    n += rD_entry.getSdThreadsUsedForSlave(wG_entry.sd_used.sd_name, slave);
                    d += wG_entry.skew;
                }
                RD_entry.printWgInfo2("slave=%s received work for %4d threads and %2d WDs, and %6.2f%% skew.", slave.getLabel(), n, hashMap.size(), d);
            }
        }
        RD_entry.printWgInfo2("", new Object[0]);
        int n = 0;
        boolean bl = false;
        for (Host host : Host.getDefinedHosts()) {
            int n2 = 0;
            double d = 0.0;
            for (Slave slave : host.getSlaves()) {
                if (slave.getCurrentWork() == null) continue;
                for (WG_entry wG_entry : slave.getCurrentWork().wgs_for_slave) {
                    n2 += rD_entry.getSdThreadsUsedForSlave(wG_entry.sd_used.sd_name, slave);
                    d += wG_entry.skew;
                }
            }
            var3_12 += n2;
            RD_entry.printWgInfo2("host=%s received work for %4d threads and %6.2f%% skew.", host.getLabel(), n2, d);
            n += n2;
        }
        RD_entry.printWgInfo2("Total amount of work received for %4d threads. Small differences with the requested thread count may be caused by integer truncation.", (int)var3_12);
        RD_entry.printWgInfo2("", new Object[0]);
    }

    public static boolean mustRunOnSingleSlave(WD_entry wD_entry, WG_entry wG_entry) {
        if (wD_entry.stream_count != 0) {
            return false;
        }
        boolean bl = Validate.isRealValidate() || wG_entry.seekpct <= 0.0 || ReplayInfo.isReplay();
        if (common.get_debug(common.PTOD_WG_STUFF)) {
            common.ptod("mustRunOnSingleSlave: wd=%s %5b rv=%b seek=%d", wD_entry.wd_name, bl, Validate.isRealValidate(), (int)wG_entry.seekpct);
        }
        return bl;
    }
}

