/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Vdb.common;
import VdbComp.CompException;
import VdbComp.WlComp;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CompRunData
implements Comparable {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    String label;
    String rd_name;
    String rd_short;
    String run_description;
    String reference;
    String vdbench_dir;
    String parent;
    boolean average = false;
    double delta_resp;
    double delta_rate;
    double delta_mb;
    double resp_max;
    double rate_mean;
    double rate_std;
    double relative_std;
    HashMap<String, Object> flatfile_data = null;
    HashMap<String, String> forxx_values;
    ArrayList<CompRunData> detail_list = null;
    private static HashMap<String, String> warning_map = new HashMap(32);

    public CompRunData(String string, HashMap hashMap, String string2) {
        this.flatfile_data = hashMap;
        this.label = string;
        this.vdbench_dir = string2;
        if (this.vdbench_dir != null) {
            this.parent = new File(this.vdbench_dir).getName();
        }
        this.rd_short = (String)this.flatfile_data.get("run");
        this.rd_name = WlComp.add_parent ? this.parent + "/" + "rdxyz" : (String)this.flatfile_data.get("run");
        if (this.rd_name == null) {
            new CompException("No proper 'Run' column found in file " + this.label);
        }
    }

    public void parseForxxValues(HashMap hashMap) {
        String string;
        this.forxx_values = new HashMap();
        if (this.run_description == null) {
            return;
        }
        if (this.run_description.indexOf("For loops: None") != -1) {
            return;
        }
        if (this.run_description.indexOf("For loops:") == -1) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.run_description, " <");
        while (!stringTokenizer.nextToken().contains("loops:")) {
        }
        while (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).startsWith("/b")) {
            if (string.indexOf("=") == -1) {
                throw new CompException("No '=' value inside of forxx pair: \n" + this.run_description);
            }
            String string2 = string.substring(0, string.indexOf("="));
            String string3 = string.substring(string.indexOf("=") + 1);
            try {
                double d = string3.endsWith("k") ? 1024.0 * Double.parseDouble(string3.substring(0, string3.length() - 1)) : (string3.endsWith("m") ? 1048576.0 * Double.parseDouble(string3.substring(0, string3.length() - 1)) : (string3.endsWith("g") ? 1.073741824E9 * Double.parseDouble(string3.substring(0, string3.length() - 1)) : (string2.equals("iorate") && string3.equals("max") ? 999988.0 : Double.parseDouble(string3))));
                if (WlComp.getopt.check('i') && string2.equalsIgnoreCase(WlComp.getopt.get_string())) continue;
                this.forxx_values.put(string2, string3);
                hashMap.put(string2, string2);
                this.rd_name = this.rd_name + "," + string2 + "=" + string3;
            }
            catch (NumberFormatException numberFormatException) {
                common.ptod(numberFormatException);
                throw new CompException("Invalid numerics in forxx pair: \n" + this.run_description);
            }
        }
    }

    public Object getValue(String string) {
        Object object = this.flatfile_data.get(string);
        if (object != null) {
            return object;
        }
        object = this.flatfile_data.get(string.toLowerCase());
        if (object != null) {
            return object;
        }
        if (warning_map.put(string, string) == null) {
            common.ptod("Unknown getValue for " + string);
            common.where(8);
        }
        return null;
    }

    public int compareTo(Object object) {
        CompRunData compRunData = this;
        CompRunData compRunData2 = (CompRunData)object;
        return compRunData.rd_name.compareToIgnoreCase(compRunData2.rd_name);
    }
}

