/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.Fget;
import Utils.common;
import VdbComp.FractionCellRenderer;
import VdbComp.SdFormat;
import VdbComp.SdLeft;
import VdbComp.SdRight;
import VdbComp.TableWidth;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class LoadFormat {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private static Vector luns_from_format = new Vector(64, 0);
    private static JTable left_table;
    private static JTable right_table;
    private static SdLeft left_model;
    private static SdRight right_model;
    private static String slice;

    public static Vector readFromFile() {
        luns_from_format.removeAllElements();
        String string = "a";
        if (string == null) {
            return new Vector(0);
        }
        String[] stringArray = Fget.readFileToArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            LoadFormat.processLine(stringArray[i], "stdout");
        }
        if (luns_from_format.size() == 0) {
            common.failure("No valid devices found.");
        }
        return luns_from_format;
    }

    private static String askForFile() {
        JFileChooser jFileChooser = new JFileChooser(new File(".").getAbsolutePath());
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(null) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            return string;
        }
        return null;
    }

    private static void processLine(String string, String string2) {
        if (string2.equals("stdout") && string.indexOf("<") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = "n/a";
            stringTokenizer = new StringTokenizer(string4, "ct");
            if (stringTokenizer.countTokens() > 0) {
                string5 = stringTokenizer.nextToken();
            }
            SdFormat sdFormat = new SdFormat();
            sdFormat.disk_number = string3.substring(0, string3.indexOf("."));
            sdFormat.lun = string4;
            sdFormat.target = string5;
            luns_from_format.add(sdFormat);
        }
    }

    public static JTable buildRightTable(Vector vector) {
        right_model = new SdRight(vector);
        right_table = new JTable(right_model);
        right_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    LoadFormat.moveRightToLeft();
                }
            }
        });
        LoadFormat.setColumnWidth(right_table);
        right_table.setFont(new Font("Courier New", 0, 12));
        return right_table;
    }

    public static JTable buildLeftTable() {
        left_model = new SdLeft(new Vector(64, 0));
        left_table = new JTable(left_model);
        left_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    LoadFormat.moveLeftToRight();
                }
            }
        });
        left_table.setFont(new Font("Courier New", 0, 12));
        return left_table;
    }

    public static void moveRightToLeft() {
        int[] nArray = right_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            SdFormat sdFormat = right_model.getRow(n);
            left_model.addRow(sdFormat);
        }
        right_model.removeRows(nArray);
        left_model.fireTableStructureChanged();
        right_model.fireTableStructureChanged();
        LoadFormat.setColumnWidth(left_table);
        LoadFormat.setColumnWidth(right_table);
    }

    public static void moveLeftToRight() {
        int[] nArray = left_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            SdFormat sdFormat = left_model.getRow(n);
            right_model.addRow(sdFormat);
        }
        left_model.removeRows(nArray);
        left_model.fireTableStructureChanged();
        right_model.fireTableStructureChanged();
        LoadFormat.setColumnWidth(left_table);
        LoadFormat.setColumnWidth(right_table);
    }

    private static void setColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableWidth.sizeColumn(i, jTable);
            if (jTable != right_table || i == 0) continue;
            FractionCellRenderer fractionCellRenderer = new FractionCellRenderer(5, 1, 4);
            tableColumnModel.getColumn(i).setCellRenderer(fractionCellRenderer);
        }
    }

    public static String getSlice() {
        return slice;
    }

    public static void storeSlice(String string) {
        slice = string;
        left_model.fireTableStructureChanged();
        right_model.fireTableStructureChanged();
        LoadFormat.setColumnWidth(left_table);
        LoadFormat.setColumnWidth(right_table);
    }

    static {
        slice = "s6";
    }
}

