/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.Fget;
import Vdb.common;
import VdbComp.CompException;
import VdbComp.CompRunData;
import VdbComp.FlatFile;
import VdbComp.WlComp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class ParseData {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private static String[] keep_list = new String[]{"reqrate", "interval", "mb/sec", "resp_max", "resp_std", "resp", "queue_depth", "read%", "rate"};

    public static boolean parseFlatFile(FlatFile flatFile, Vector vector) {
        String string = flatFile.vdbench_dir + "/flatfile.html";
        String[] stringArray = Fget.readFileToArray(string);
        if (stringArray == null) {
            common.ptod("label: %s", flatFile.label);
            common.ptod("File: %s", string);
            common.ptod("File ignored, file is either empty or does not exist");
            return false;
        }
        String string2 = null;
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < stringArray.length && !(string2 = stringArray[n2].trim()).startsWith("tod"); ++n2) {
            if (!string2.startsWith("*")) continue;
            ++n;
        }
        if (!string2.startsWith("tod")) {
            throw new CompException("Missing 'tod' label in file " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        Vector<String> vector2 = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken().toLowerCase());
        }
        CompRunData compRunData = null;
        ++n2;
        while (n2 < stringArray.length) {
            String string3;
            string2 = stringArray[n2].trim();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            stringTokenizer = new StringTokenizer(string2);
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                try {
                    double d = Double.parseDouble(string3);
                    String string4 = (String)vector2.get(n3++);
                    if (!Arrays.asList(keep_list).contains(string4)) continue;
                    hashMap.put(string4, new Double(d));
                }
                catch (NumberFormatException numberFormatException) {
                    hashMap.put((String)vector2.get(n3++), string3);
                }
            }
            if (n3 != vector2.size()) {
                string3 = "\nlast line: " + string2 + "\nheaders: " + vector2.size() + "\ndata: " + n3;
                throw new CompException("Not enough data for all columns in file " + string + string3);
            }
            string3 = hashMap.get("interval");
            if (string3 == null) {
                throw new CompException("Missing 'Interval' column in file " + string);
            }
            if (string3 instanceof Double && (Double)((Object)string3) == 1.0 && compRunData != null) {
                vector.add(compRunData);
                flatFile.rds.add(compRunData);
            }
            compRunData = new CompRunData(flatFile.label, hashMap, flatFile.vdbench_dir);
            ++n2;
        }
        if (compRunData != null) {
            vector.add(compRunData);
            flatFile.rds.add(compRunData);
        }
        if (vector.size() == 0) {
            throw new CompException("No valid run averages found in file " + string);
        }
        return true;
    }

    public static void parseSummary(ArrayList<FlatFile> arrayList) {
        Object object;
        FlatFile flatFile;
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            flatFile = arrayList.get(n);
            for (int i = 0; i < flatFile.rds.size(); ++i) {
                object = flatFile.rds.get(i);
                if (((CompRunData)object).run_description == null) continue;
                common.failure("not expected");
                return;
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            flatFile = arrayList.get(n);
            String string = flatFile.vdbench_dir + "/summary.html";
            object = new Vector(8, 0);
            for (String string2 : Fget.readFileToArray(string)) {
                if (string2.indexOf("Starting RD") == -1) continue;
                ((Vector)object).add(string2);
            }
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                CompRunData compRunData = flatFile.rds.get(i);
                String string2 = (String)((Vector)object).get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "=; ");
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals("RD")) continue;
                    bl = true;
                    String[] stringArray = string2.split("\"+");
                    String string4 = stringArray[1];
                    String string5 = stringTokenizer.nextToken();
                    if (string5.indexOf("</b>") != -1) {
                        string5 = string5.substring(0, string5.indexOf("</b>"));
                    }
                    if (WlComp.add_parent) {
                        string5 = compRunData.parent + "/" + string5;
                    }
                    if (!WlComp.add_parent && !string5.equals(compRunData.rd_name)) {
                        throw new CompException("Unmatched RD names in file " + string + ": " + compRunData.rd_name + "/" + string5);
                    }
                    compRunData.run_description = string2;
                    compRunData.reference = string4;
                    break;
                }
                if (bl) continue;
                throw new CompException("No proper RD name found in " + string2);
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

