/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.Format;
import Utils.common;
import VdbComp.SdFormat;
import VdbComp.SortFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SdRight
extends AbstractTableModel {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String[] column_names;
    private String[] solaris = new String[]{"lun", "s0", "s1", "s2", "s3", "s4", "s5", "s6", "s7"};
    private String[] windows = new String[]{"Drive #", "Drive letters"};
    private String[] linux = new String[]{"Lun", "Size"};
    private Vector luns;

    public SdRight(Vector vector) {
        this.column_names = common.onLinux() ? this.linux : (common.onWindows() ? this.windows : this.solaris);
        this.luns = vector;
        Collections.sort(this.luns, new SortFormat());
    }

    public void addRow(SdFormat sdFormat) {
        this.luns.add(sdFormat);
        Collections.sort(this.luns, new SortFormat());
    }

    public void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.luns.set(nArray[i], null);
        }
        while (this.luns.remove(null)) {
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SdFormat sdFormat = (SdFormat)this.luns.elementAt(n);
        long l = 1024L;
        long l2 = 0x100000L;
        long l3 = 0x40000000L;
        long l4 = 0x10000000000L;
        if (common.onWindows()) {
            if (n2 == 0) {
                return sdFormat.lun;
            }
            if (n2 == 1) {
                return sdFormat.slices;
            }
            common.failure("Invalid column requested");
        }
        if (common.onLinux()) {
            if (n2 == 0) {
                return sdFormat.lun;
            }
            if (n2 == 1) {
                return sdFormat.slices;
            }
            common.failure("Invalid column requested");
        }
        if (n2 == 0) {
            return sdFormat.lun;
        }
        double d = sdFormat.sizes[n2 - 1];
        if (d == 0.0) {
            return "";
        }
        if (d > (double)l4) {
            return Format.f("%.2ft", d / (double)l4);
        }
        if (d > (double)l3) {
            return Format.f("%.2fg", d / (double)l3);
        }
        if (d > (double)l2) {
            return Format.f("%.2fm", d / (double)l2);
        }
        if (d > (double)l) {
            return Format.f("%.2fk", d / (double)l);
        }
        return Format.f("%.2f", d);
    }

    public SdFormat getRow(int n) {
        return (SdFormat)this.luns.elementAt(n);
    }

    @Override
    public int getRowCount() {
        return this.luns.size();
    }

    @Override
    public int getColumnCount() {
        return this.column_names.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.column_names[n];
    }
}

